% Procedure from Bai&Ng, JBES(2005), translated from GAUSS
% u is not demeaned!
function [hac,k] = qsX(u,prewhite,k)

% k is number of lags to be used
% if k is not provided or equals -1, it is determined automatically (Andrews 1991)
% if prewhite == 0 and k == 0, vcv-matrix equals standard vcv-matrix known from OLS 

n = rows(u);
nreg = cols(u);
rho = zeros(nreg,1);
sigma = zeros(nreg,1);
d = zeros(nreg,nreg);
beta = zeros(nreg,nreg);

% do a VAR(1) prewhitening
if prewhite == 1;
    v = zeros(n-1,nreg);
    reg = u(1:n-1,:);
    i = 1;
    while i<=nreg;
        beta(:,i) = lscov( reg , u(2:n,i) );
        v(:,i) = u(2:n,i) - reg * beta(:,i);
        i = i + 1;
    end;
else
    v = u;
end;

if (nargin < 3)||(k==-1);
    i = 1;
    while i<=nreg;
        rho(i) = lscov( v(1:rows(v)-1,i) , v(2:rows(v),i) );
        r = v(2:rows(v),i) - v(1:rows(v)-1,i) * rho(i);
        sigma(i) = r'*r / rows(v);
        i = i + 1;
    end;


    bot = 0; top = 0;
    i = 1;
    while i<=nreg;
        top = top + 4*(rho(i)^2) * sigma(i)^2 / (1-rho(i))^8;
        bot = bot + sigma(i)^2 / ((1-rho(i))^4);
        i = i+1;
    end;
    alpha = top/bot;
    k = ceil(1.3221*(alpha*n)^(0.2));
end






%disp('truncation lag'); 
%disp(k);
vcv = v'*v / (n-1);
i = 1;
while i <= n-1 ;
    x = i/k;
    del = 6 * pi * x / 5;
    w = 3*(sin(del) / del - cos(del)) / (del*del);
    cov = v(i+1:rows(v),:)' * v(1:rows(v)-i,:) / (n-1);
    vcv = vcv + w*cov;
    cov = v(1:rows(v)-i,:)' * v(i+1:rows(v),:)/(n-1);
    vcv = vcv+w*cov;
    i = i + 1;
end;
d = inv(eye(nreg)-beta');
hac = d*vcv*d';

