function [Z2, U_temp]=Z2star_Student(X,R_all,nu_all)
%Perform Z2_star transformation into uniform
%Inputs: 
%X - Data matrix
%R_all - correlation matrix, possibly time-varying (for the static case adapt the
%code below)
%nu_all - degrees-of-freedom, possibly time-varying
%Outputs: 
%Z2 - the transformed series
%U_temp - the corresponding uniform series
%
%written by Hans Manner
T=size(X,1);
d=size(R_all,1);

Z2=zeros(T,1);
U_temp=[];

%remove for time varying problem
%R=R_all;
%nu=nu_all;

for t=1:T
    U=[];
    %activate for time-varying problem
    nu=nu_all(t);
    R=R_all(:,:,t);
for i=1:d
    
    U=[U tcdf(X(t,i),nu)];
    %now make the PIT
    Z2(t)=Z2(t)+norminv(U(end)).^2;
    %Sigma_ii=Sigma(i,i);

    for j=2:d
        ind=nchoosek([1:i-1 i+1:d],j-1);   %all possible conditioning sets of size j-1
        for jj=1:size(ind,1)
            R_ii=R(i,i);
            R_ij=R(i,ind(jj,:));
            R_jj=R(ind(jj,:),ind(jj,:));
            
            X_j=X(t,ind(jj,:));
            X_i=X(t,i);
            Y_i=sqrt((nu+j-1)/nu)*(1+1/nu*X_j*inv(R_jj)*X_j')^(-1/2)*(X_i-R_ij*inv(R_jj)*X_j');
            Y_i=Y_i/(sqrt(R_ii-R_ij*inv(R_jj)*R_ij'));
            nu_c=nu+j-1;    
            Uij=tcdf(Y_i, nu_c);
            U=[U Uij];
            Z2(t)=Z2(t)+norminv(Uij).^2;
            
        end
    end



end;
U_temp=[U_temp' U']';
end   
 
