function [Z2, U_temp]=Z2dag_Student(X,R,nu_all)
%Perform Z2_dagger transformation into uniform for multivariate
%t-distribution with time-varying parameters (or re-estimated every period)
 %Inputs: 
%X - Data matrix
%R_all - correlation matrix, possibly time-varying (for the static case adapt the
%code below)
%nu_all - degrees-of-freedom, possibly time-varying
%Outputs: 
%Z2 - the transformed series
%U_temp - the corresponding uniform series
%
%written by Hans Manner


[T,d]=size(X);
Z2=zeros(T,1);
U_temp=[];

%remove for time varying problem
%R0=R;
%nu=nu_all;
for t=1:T
    %activate for time-varying problem
    R0=R(:,:,t); 
    nu=nu_all(t);
    U=[];
    for i=1:d
        %PIT for Student t, see Kotz and Nadarajah (2004) p. 17
        R_ii=R0(i,i);
        R_ij=[R0(i,1:i-1) R0(i,i+1:end)];
        R_jj=R0;
        R_jj(i,:)=[];
        R_jj(:,i)=[];
        X_j=[X(t,1:i-1) X(t,i+1:end)];
        X_i=X(t,i);
        Y_i=sqrt((nu+d-1)/nu)*(1+1/nu*X_j*inv(R_jj)*X_j')^(-1/2)*(X_i-R_ij*inv(R_jj)*X_j');
        Y_i=Y_i/(sqrt(R_ii-R_ij*inv(R_jj)*R_ij'));
        nu_c=nu+d-1;    
        Uij=tcdf(Y_i, nu_c);
        U=[U Uij];
        Z2(t)=Z2(t)+norminv(Uij).^2;
        
    end
    U_temp=[U_temp' U']';
end
    
