function f=PIT_chi2_mix(Z2, Omega);
%probability integral transform for data coming from a mixture of
%chi-square variables, which must be done by MC
K=10000; %number of simulations for distribution
d=size(Omega,1);

lambda=eig(Omega);

chi=chi2rnd(1,K,d);

chi=chi*lambda;
T=size(Z2,1);
f=zeros(T,1);
for i=1:T
    f(i)=mean(Z2(i)>chi);
end

f(f==0)=0.0000001;