function [U_Z2]=PIT_Z2star_Student(Z2,R_all,nu_all)
%PIT for Z2_star transformation for Student case
M=10000;

[~,d]=size(R_all(:,:,1));
T=length(Z2);
Z2_bs=zeros(T,M);
U_Z2=zeros(T,1);


for t=1:T
    U=[];
    nu=nu_all(t);
    R=R_all(:,:,t);
    parfor m=1:M
    X=mvtrnd(R,nu,1);
    U=[];
    
    for i=1:d
    
    U=[U tcdf(X(i),nu)];
    %now make the PIT
    Z2_bs(t,m)=Z2_bs(t,m)+norminv(U(end)).^2;
    %Sigma_ii=Sigma(i,i);

    for j=2:d
        ind=nchoosek([1:i-1 i+1:d],j-1);   %all possible conditioning sets of size j-1
        for jj=1:size(ind,1)
            R_ii=R(i,i);
            R_ij=R(i,ind(jj,:));
            R_jj=R(ind(jj,:),ind(jj,:));
            
            X_j=X(ind(jj,:));
            X_i=X(i);
            Y_i=sqrt((nu+j-1)/nu)*(1+1/nu*X_j*inv(R_jj)*X_j')^(-1/2)*(X_i-R_ij*inv(R_jj)*X_j');
            Y_i=Y_i/(sqrt(R_ii-R_ij*inv(R_jj)*R_ij'));
            nu_c=nu+j-1;    
            Uij=tcdf(Y_i, nu_c);
            U=[U Uij];
            Z2_bs(t,m)=Z2_bs(t,m)+norminv(Uij).^2;
            
        end
    end

    end;
    end;
    
    U_Z2(t)=mean(Z2_bs(t,:)<Z2(t));
end   
 
