function U=PIT_Z2star(X,Sigma)
%Perform Z2_star transformation into uniform under normality
T=size(X,1);
d=size(Sigma,1);
K=d*2^(d-1);
Index=cell(K,1);    %here I store the indices of the base variable for the covariance and eventually the sampling (if necessary)
k=1;    %running index for for the storage to 'Index'
X_cond=[];
Z2=zeros(T,1);

for i=1:d
    
    X_cond=[X_cond X(:,i)];
    %now make the PIT
    Z2=Z2+X_cond(:,end).^2;
    %Sigma_ii=Sigma(i,i);
    
    Index{k}=i;
    k=k+1;
        
    for j=2:d
        ind=nchoosek([1:i-1 i+1:d],j-1);   %all possible conditioning sets of size j-1
        for jj=1:size(ind,1)
            
            Sigma_ij=Sigma(i,ind(jj,:));
            Sigma_jj=Sigma(ind(jj,:),ind(jj,:));
            
            X_cond=[X_cond (X(:,i)- (Sigma_ij*inv(Sigma_jj)*X(:,ind(jj,:))')')];
            Z2=X_cond(:,end).^2+Z2;
            
            Index{k}=[i ind(jj,:)];
            k=k+1;
        end
    end



end;

    %now make the Omega matrix
    Omega=zeros(K,K);
    for i=1:K
        Sigma_ii=Sigma(Index{i}(1),Index{i}(1));
        Sigma_ij=Sigma(Index{i}(1),Index{i}(2:end));
        Sigma_jj=Sigma(Index{i}(2:end),Index{i}(2:end));    
        
        Omega(i,i)=Sigma_ii-Sigma_ij*inv(Sigma_jj)*Sigma_ij';  %variance of the transformed variable
        
        for p=i+1:K
            Sigma_ip=Sigma(Index{i}(1),Index{p}(1));
            Sigma_pq=Sigma(Index{p}(1),Index{p}(2:end));
            Sigma_qq=Sigma(Index{p}(2:end),Index{p}(2:end));
            Sigma_iq=Sigma(Index{i}(1),Index{p}(2:end));
            Sigma_jq=Sigma(Index{i}(2:end),Index{p}(2:end));
            Sigma_pj=Sigma(Index{p}(1),Index{i}(2:end));
        
            Omega(i,p)=Sigma_ip-Sigma_pq*inv(Sigma_qq)*Sigma_iq'-Sigma_ij*inv(Sigma_jj)*Sigma_pj'...
                +Sigma_ij*inv(Sigma_jj)*Sigma_jq*(inv(Sigma_qq)')*(Sigma_pq'); 
            
            Omega(p,i)=Omega(i,p); %symmetric matrix 
        end
    end 
    
 U=PIT_chi2_mix(Z2, Omega);    %outsource the PIT to another function
