function [U_Z2]=PIT_Z2dag_Student(Z2,R,nu_all)
%PIT for Z2_dagger transformation into uniform for multivariate
%t-distribution with time-varying parameters (or re-estimated every period)
 
M=10000;

[~,d]=size(R(:,:,1));
T=length(Z2);
Z2_bs=zeros(T,M);
U_Z2=zeros(T,1);

for t=1:T
    R0=R(:,:,t); 
    nu=nu_all(t);
    parfor j=1:M
    
    X=mvtrnd(R0,nu,1);
    U=[];
    for i=1:d
        %PIT for Student t, see Kotz and Nadarajah (2004) p. 17
        R_ii=R0(i,i);
        R_ij=[R0(i,1:i-1) R0(i,i+1:end)];
        R_jj=R0;
        R_jj(i,:)=[];
        R_jj(:,i)=[];
        X_j=[X(1:i-1) X(i+1:end)];
        X_i=X(i);
        Y_i=sqrt((nu+d-1)/nu)*(1+1/nu*X_j*inv(R_jj)*X_j')^(-1/2)*(X_i-R_ij*inv(R_jj)*X_j');
        Y_i=Y_i/(sqrt(R_ii-R_ij*inv(R_jj)*R_ij'));
        nu_c=nu+d-1;    
        Uij=tcdf(Y_i, nu_c);
        U=[U Uij];
        Z2_bs(t,j)=Z2_bs(t,j)+norminv(Uij).^2;
        
    end
    end
    U_Z2(t)=mean(Z2_bs(t,:)<Z2(t));
end


    
