function U=PIT_Z2dag(X_base,Sigma)
%Perform Z2_dagger transformation into uniform under normality


T=size(X_base,1);
d=size(Sigma,1);

X_cond=[];          %initiate the transformed variables
Omega=zeros(d,d);   %initiate the covariance matrix of the transformed variables
Z2=zeros(T,1);      
for i=1:d
    X=[X_base(:,i) X_base(:,1:i-1) X_base(:,i+1:end)];
    Sigma_ii=Sigma(i,i);
    Sigma_ij=[Sigma(i,1:i-1) Sigma(i,i+1:end)];
    Sigma_jj=Sigma;
    Sigma_jj(i,:)=[];
    Sigma_jj(:,i)=[];
    X_cond=[X_cond (X(:,1)- (Sigma_ij*inv(Sigma_jj)*X(:,2:end)')')];
    Omega(i,i)= Sigma_ii-Sigma_ij*inv(Sigma_jj)*Sigma_ij';  %variance of the transformed variable
    
    for p=i+1:d   %make the covariance between the transformed variables
        Sigma_ip=Sigma(i,p);
        Sigma_pq=[Sigma(p,1:p-1) Sigma(p,p+1:end)];
        Sigma_qq=Sigma;
        Sigma_qq(p,:)=[];
        Sigma_qq(:,p)=[];
        Sigma_iq=[Sigma(i,1:p-1) Sigma(i,p+1:end)];
        Sigma_jq=Sigma;
        Sigma_jq(i,:)=[];
        Sigma_jq(:,p)=[];
        Sigma_pj=[Sigma(p,1:i-1) Sigma(p,i+1:end)];
        
        Omega(i,p)=Sigma_ip-Sigma_pq*inv(Sigma_qq)*Sigma_iq'-Sigma_ij*inv(Sigma_jj)*Sigma_pj'+Sigma_ij*inv(Sigma_jj)*Sigma_jq*(inv(Sigma_qq)')*(Sigma_pq');
        Omega(p,i)=Omega(i,p); %symmetric matrix
    end

    %now make the PIT, for which I need to get simulated data from the
    %mixture chi-square distribution
    Z2=X_cond(:,i).^2+Z2;

   
end;

 U=PIT_chi2_mix(Z2, Omega);    %outsource the PIT to another function
    
