function [Z2, U_temp]=PIT_Z2_student(X,R,nu_all)
%performs the Z2 transformation for data from a multivariate t-distribution
%Data has to be demeanded beforehand and assumed to come from a standard t
%distribution with correlation matrix R


[T,d]=size(X);
Z2=zeros(T,1);
U_temp=[];
%remove for time varying problem
R0=R;
nu=nu_all;
for t=1:T
    %activate for time-varying problem
     R0=R(:,:,t);  % to be generalized for time-varying correlations within the loop
     nu=nu_all(t);
    U=tcdf(X(t,1),nu);  %PIT
    
    Z2(t)=norminv(U).^2;
    for i=2:d
        %PIT for Student t, see Kotz and Nadarajah (2004) p. 17
        R_ii=R0(i,i);
        R_ij=R0(i,1:i-1);
        R_jj=R0(1:i-1,1:i-1);
        X_j=X(t,1:i-1);
        X_i=X(t,i);
        Y_i=sqrt((nu+i-1)/nu)*(1+1/nu*X_j*inv(R_jj)*X_j')^(-1/2)*(X_i-R_ij*inv(R_jj)*X_j');
        Y_i=Y_i/(sqrt(R_ii-R_ij*inv(R_jj)*R_ij'));
        nu_c=nu+i-1;    %conditional df 
        %V= ( (nu+X2*inv(Sigma_jj)*X2')/nu_c)*(Sigma_ii-Sigma_ij*inv(Sigma_jj)*Sigma_ij');  %variance of the transformed variable
        %Uij=tcdf((X(t,i)- (Sigma_ij*inv(Sigma_jj)*X2')')/sqrt(V*((nu_c-2)/nu_c)),nu_c);
        
        %third possibility
        
%         Y_i=(X_i-R_ij*inv(R_jj)*X_j');
%         Sigma_cond=(1+1/nu*X_j*inv(R_jj)*X_j')*(R_ii-R_ij*inv(R_jj)*R_ij');
%         nu_c=nu/(nu+i-1-2);
%         Y_i=Y_i/sqrt(Sigma_cond);
        Uij=tcdf(Y_i, nu_c);
        U=[U Uij];
        Z2(t)=Z2(t)+norminv(Uij).^2;
        
    end
    U_temp=[U_temp' U']';
end

