function [p1 p2 stat]=Neyman_ST(U)
%performs Neyman's smooth test for uniformity of U
%p2 is the p-value based on the standard version of the test
n=length(U);


Z=2*U-1;
mu1=sum(Z)/n;
mu2=sum(Z.^2)/n;
mu3=sum(Z.^3)/n;
mu4=sum(Z.^4)/n;
u12=3*n*mu1^2;
u22=(45*n*((mu2-1/3)^2))/4;
u32=(7*n*(5*mu3-3*mu1)^2)/4;
u42=(9*n*(35*(mu4-1/5)-30*(mu2-1/3))^2)/64;

p1=1-chi2cdf(u22,1);
p2=1-chi2cdf(u12+u22+u32+u42,4);
stat=u12+u22+u32+u42;




pi1=sqrt(12)*(U-0.5);
pi2=sqrt(5)*(6*(U-0.5).^2-0.5);
pi3=sqrt(7)*(20*(U-0.5).^3-3*(U-0.5));
pi4=210*(U-0.5).^4-45*(U-0.5).^2+9/8;

