function [p, stat]=NST_EU_DM(U,s,lambda,sceme)
%performs Neyman's smooth test for uniformity of U to be used for the case
%when correcting for estimation uncertainty and under dynamic misspecification. 
%Inputs: 
%U - series to be test for uniformity
%Always uses automatic selection of lag length for long run covariance
%estimation
%Here 's' is the score vector
%from the LL estimating the model, 'lambda' is the ratio of OOS and IS
%observations (P/R)
%sceme = 1 for fixed, 2 for recursive, 3 for rolling

if sceme==1
    eta1=0;
    eta2=lambda;
elseif sceme==2
    eta1=1-1/lambda*log(1+lambda);
    eta2=2*(1-1/lambda*log(1+lambda));
elseif sceme==3
    if lambda<=1
        eta1=lambda/2;
        eta2=lambda-lambda^2/3;
    else
        eta1=1-1/(2*lambda);
        eta2=1-1/(3*lambda);
    end
end

n=length(U);

pi1=sqrt(12)*(U-0.5);
pi2=sqrt(5)*(6*(U-0.5).^2-0.5);
pi3=sqrt(7)*(20*(U-0.5).^3-3*(U-0.5));
pi4=210*(U-0.5).^4-45*(U-0.5).^2+9/8;

xi=[pi1 pi2 pi3 pi4]';
%stat=sum(pi1)^2/n+sum(pi2)^2/n+sum(pi3)^2/n+sum(pi4)^2/n;

D=zeros(4,size(s,1));
B=zeros(size(s,1),size(s,1));

for t=1:n
    D=D+(xi(:,t)*s(:,t)');
    B=B+s(:,t)*s(:,t)';
end
D=D/n;
B=B/n;
lag=-1;
warning off all
% tmp=covvar([xi' s'],lag,1);
% Sfh=tmp(1:4,5:end);
% Shh=covvar(s');
% Sff=covvar(xi');  

% %tmp=covnw([xi' s'],lag,0);
% %[tmp] = nwX([xi' s'],lag)
% Shh=covnw(s',lag,0);  %B* in our notation
% Sff=covnw(xi',lag,0); %Simga* in our notation


B_star=qsX(s',0,lag);  %B* in our notation
S_star=qsX(xi',0,lag); 
[tmp] = qsX([xi' s'],lag);
D_star=tmp(1:4,5:end);   %D* in our notation


Sigma=S_star-eta1*(D_star*inv(B)*D'+D*inv(B)*D_star')+ eta2*D*inv(B)*B_star*inv(B)*D'; 
%Sigma=Sff;  %without estimation uncertainty

stat=1/n*sum(xi')*inv(Sigma)*sum(xi')';
p=1-chi2cdf(stat,4);


