function [p, stat]=NST_EU(U,s,lambda)
%performs Neyman's smooth test for uniformity of U to be used for the case
%when correcting for estimation uncertainty. 
%Inputs: 
%U - series to be test for uniformity
%Here 's' is the score vector from the LL estimating the model, 'lambda' is the ratio of OOS and IS
%observations (P/R)

n=length(U);

pi1=sqrt(12)*(U-0.5);
pi2=sqrt(5)*(6*(U-0.5).^2-0.5);
pi3=sqrt(7)*(20*(U-0.5).^3-3*(U-0.5));
pi4=210*(U-0.5).^4-45*(U-0.5).^2+9/8;

xi=[pi1 pi2 pi3 pi4]';
%stat=sum(pi1)^2/n+sum(pi2)^2/n+sum(pi3)^2/n+sum(pi4)^2/n;

D=zeros(4,size(s,1));
B=zeros(size(s,1),size(s,1));

for t=1:n
    
    D=D+(xi(:,t)*s(:,t)');
    B=B+s(:,t)*s(:,t)';
end
Sigma=eye(4,4)+1/n*lambda*D*inv(B)*D';

stat=1/n*sum(xi')*inv(Sigma)*sum(xi')';
p=1-chi2cdf(stat,4);


