function [p, stat]=NST_DM(U,lag)
%performs Neyman's smooth test for uniformity of U to be used for the case
%when correcting only for dynamic misspecification. 
%Inputs: 
%U - series to be test for uniformity
%lag - number of lags for the long-run covariance estimation, set to -1 for
%automatic selection


n=length(U);

pi1=sqrt(12)*(U-0.5);
pi2=sqrt(5)*(6*(U-0.5).^2-0.5);
pi3=sqrt(7)*(20*(U-0.5).^3-3*(U-0.5));
pi4=210*(U-0.5).^4-45*(U-0.5).^2+9/8;

xi=[pi1 pi2 pi3 pi4]';
%stat=sum(pi1)^2/n+sum(pi2)^2/n+sum(pi3)^2/n+sum(pi4)^2/n;
if nargin<2
lag=-1;
end
warning off all

if lag==0
    S_star=eye(4);
else

S_star=qsX(xi',0,lag); 
%S_star=nwX(xi',0,lag); 
end


Sigma=S_star; 
%Sigma=Sff;  %without estimation uncertainty

stat=1/n*sum(xi')*inv(Sigma)*sum(xi')';
p=1-chi2cdf(stat,4);


