function F=KP_PIT(P,d)
%Probability integral transform based on the demeaned product of iid uniforms as in
%Ko and Park (2013) in dimension d

F=(2^(d-1))*P;
aux=0;
for i=1:d
   aux=aux+(1/factorial(d-i))*(log(1./abs(2^d*P))).^(d-i);
end
F=F.*aux+1/2;


