function Z=standard(X)
%Standardized each variable (each column) of X
% Input: X of dimensions TxN
% Output: Standardized version of X

[T,~]=size(X);
mean_X=repmat(mean(X),T,1); sd_X=repmat(std(X),T,1);
Z=(X-mean_X)./sd_X;
