 %Test 1 September 2019
 
clear all
clc
diary Application_september_1_2019.out


%Data application 1
% Import the data
dev1 = csvread('dev1.csv');
% Clear temporary variables
clearvars raw;

% Import the data
eme1 = csvread('eme1.csv');
% Clear temporary variables
clearvars raw;

%Data application 2
% Data from Hirata, Kose, and Otrok (2013)
% Import the data
dev2 =  csvread('dev2.csv');
% Clear temporary variables
clearvars raw;

% Import the data
eme2 =  csvread('eme2.csv');
% Clear temporary variables
clearvars raw;

%Data application 3
% Same data as Sebastien Walti (2010)
dev3 =  csvread('dev3.csv');
% Clear temporary variables
clearvars raw;
% Import the data
eme3 = csvread('eme3.csv');
% Clear temporary variables
clearvars raw;


%Data application 4
% Same data as Mumtaz, Simonelli and Surico (2009)
dev4 =  csvread('dev4.csv');
% Clear temporary variables
clearvars raw;

% Import the data
eme4 =  csvread('eme4.csv');
% Clear temporary variables
clearvars raw;

alpha=0.05; %Level of the test 

%=================================================================
%Application with data 1
x1=dev1;% n1 Developped economy real activity variables over t periods
x2=eme1;% n2 Emerging  economy real activity variables over t periods


%Sample sizes
[t,n1]=size(x1);
[t,n2]=size(x2);
n=n1+n2;    % Total number of variables

x= [x1,x2];   
X= standard(x);  % Standardized the variables


[r,~,~]= nbplog(X,5,1,0); %Selected number of  factors using Bai and Ng (2002, IC_P1)
                           % Can be downloaded using: 
                           % https://drive.google.com/file/d/0B-aG4lrQrBYsTGNvYTNjWld2X1U/view

% Estimate the factor loadings
    [vectors,~,~] = svds(X'*X/(n*t),r);
    lambda = sqrt(n)*vectors;          
  % Finding the test statistic, the critical value, the P value and the
  % decision using the proposed test statistics
    [test_stat1,critical_value1, p_value1,reject1] = lm_test(lambda, n1, alpha)

%=================================================================    
%Application with data 2

x1=dev2(1:48,:);% Developped country
x2=eme2(1:48,:);% Emerging country

%x1=dev2;% Developped country (full sample)
%x2=eme2;% Emerging country (full sample)

[t,n1]=size(x1);
[t,n2]=size(x2);
n=n1+n2;    

x= [x1,x2];
X= standard(x);   

[r,~,~]= nbplog(X,5,1,0); %Selected number of factors

% Testing 
    [vectors,~,~] = svds(X'*X/(n*t),r); 
    lambda = sqrt(n)*vectors;             
    [test_stat2,critical_value2, p_value2,reject2] = lm_test(lambda, n1, alpha)    

%=================================================================
%Application with data 3  

x1=dev3(1:29,:);% Developped country
x2=eme3(1:29,:);% Emerging country  


[t,n1]=size(x1);
[t,n2]=size(x2);
n=n1+n2;    

x= [x1,x2];

%I use the EM algorithm. See Stock and Watson (2002) to fit missing value
for tt=1:t
    for i=1:n
        if x(tt,i)==0 %The 0s in this dataset are missing values in the data set
            x(tt,i)=NaN;
        end
    end
end
x=EM(x);

% Alternatively we can drop Missing Variables
%x(:,n1+[7,8,10,14,15,23,24,28])=[];
%n=n-8;

%We can also drop the missing Time Periods
%x=x(16:end,:);

xf=x;


for i=1:n
    xf(:,i)=hpfilter(x(:,i),100); 
end
xx=(x-xf)./xf; % Detrending and normalization in Walti (2010)
X= standard(xx);
[r,~,~]= nbplog(X,5,1,0); %Selected the number of factors

% Testing 
    [vectors,~,~] = svds(X'*X/(n*t),r); 
    lambda = sqrt(n)*vectors;             
    [test_stat3,critical_value3, p_value3,reject3] = lm_test(lambda, n1, alpha)

    
%=================================================================    
%Application with data 4

x1=log(1+dev4/100);% Developped country
x2=log(1+eme4/100);% Emerging country

[t,n1]=size(x1);
[t,n2]=size(x2);
n=n1+n2;    

x= [x1,x2];
X= standard(x);   

[r,~,~]= nbplog(X,5,1,0); %Selected the number of factors

% Testing 
    [vectors,~,~] = svds(X'*X/(n*t),r); 
    lambda = sqrt(n)*vectors;             
    [test_stat4,critical_value4, p_value4,reject4] = lm_test(lambda, n1, alpha)    
  
%================================================================= 
diary off;