function [test_stat,critical_value, p_value,reject] = lm_test(lambda, N1, level)
%{
 Inputs:

 lambda: PC estimate for factors loading using the full sample
 N1: Number of variable in Group 1
 level: Significance level
%}

%{        
 Outputs:

 test_stat: test statistic test
 critical_value: critical value
 p_value: P-value
 reject: if the null cannot be rejected at the given level then reject=1; 0 if not
%}

[N,r] = size(lambda);
 
    lambda1 = lambda(1: N1, :);
    lambda2 = lambda(N1+1 : N, :);
    
    difference = uptriangle( lambda1'* lambda1/N1 - lambda2'*lambda2/(N - N1));
    
   A = zeros(N, (r+1)*r/2 );
 
    for i = 1 : N
        A(i,:) = (uptriangle(lambda(i,:)' * lambda(i,:) - eye(r)))'; 
    end
    
    % Heteroskedasticity robust variance (White, 1980)
    Omega=A'*A/N;
    
    %Restricted estimate of variance
    Var  =  Omega*(N/N1 + N/(N-N1)) ;
    
    test_stat  = difference' * inv(Var) * difference * N;
        
    % P-value
    p_value=1-chi2cdf(test_stat,r*(r+1)/2);
    
    % Critical Value
    critical_value=chi2inv(1-level, r*(r+1)/2);
    
    % Test results 
    reject = (test_stat>critical_value);  
end