function f = hpfilter(x,w)
%   It extracts the trend of a time series Hodrick-Prescott filter.
% Input:
%   y = Original series
%   w = Smoothing parameter
%
% Output:   
%   f = Filtered series

[m,~] = size (x);
q = repmat([w -4*w ((6*w+1)/2)], m, 1);
q(1,2) = -2*w;      q(m-1,2) = -2*w; q(1,3) = (1+w)/2;   q(m,3) = (1+w)/2; q(2,3) = (5*w+1)/2; q(m-1,3) = (5*w+1)/2; 
f = (spdiags(q, -2:0, m, m)+spdiags(q, -2:0, m, m)')\x;