% Dias and Duarte
% All mistakes are our own. Please email joao.duarte@novasbe.pt for any
% mistakes or bugs found.
% last update: 8/10/2018


% DESCRIPTION
%
% Here we read the price indexes IRFs from the HFI, FAVAR and R&R models 
% and plot CPI vs CPINET as well as PCE vs PCENET in response to a 
% monetary shock


clear all

%% Reading HFI  IRF data


[IRF_hfi,txt,raw] = xlsread('datasets/IRF/irfs_results_hfi.xlsx','IRF');
[LOWER_hfi,txt,raw] = xlsread('datasets/IRF/irfs_results_hfi','LOWER');
[UPPER_hfi,txt,raw] = xlsread('datasets/IRF/irfs_results_hfi','UPPER');


%% Reading FAVAR IRF data

[IRF_favar,txt,raw] = xlsread('datasets/IRF/irfs_results_favar.xlsx','IRF');
[LOWER_favar,txt,raw] = xlsread('datasets/IRF/irfs_results_favar.xlsx','LOWER');
[UPPER_favar,txt,raw] = xlsread('datasets/IRF/irfs_results_favar.xlsx','UPPER');


%% Reading RR IRF data

[IRF_rr_cpi,txt,raw] = xlsread('datasets/IRF/R&R.xlsx','Sheet1');


[IRF_rr_pce,txt,raw] = xlsread('datasets/IRF/price_puzzle_irfs.xlsx','rr');


figure
%%  Gertler and Karadi shocks
X = linspace(1,48,48);

subplot(3,2,1)
h=plot(X, IRF_hfi(:,1), 'r', X, IRF_hfi(:,2), 'b--');
[ph,msg]=jbfill(X,UPPER_hfi(:,1)',LOWER_hfi(:,1)',[0 0 1],[0 0 0],1,0.1)
[ph,msg]=jbfill(X,UPPER_hfi(:,2)',LOWER_hfi(:,2)',[0 0 1],[0 0 0],1,0.25)
set(h(1),'linewidth',1.5);
set(h(2),'linewidth',1.5);
ylim([-0.4 0.2]);
ylabel('High-Frequency Shocks')
title('CPI vs CPI net of shelter')
legend('CPI','CPI net of shelter', 'location','southeast')
ax = gca;
ax.XGrid = 'off';
ax.YGrid = 'on';

subplot(3,2,2)
h=plot(X, IRF_hfi(:,3), 'r', X, IRF_hfi(:,4), 'b--');
[ph,msg]=jbfill(X,UPPER_hfi(:,3)',LOWER_hfi(:,3)',[0 0 1],[0 0 0],1,0.1)
[ph,msg]=jbfill(X,UPPER_hfi(:,4)',LOWER_hfi(:,4)',[0 0 1],[0 0 0],1,0.25)
set(h(1),'linewidth',1.5);
set(h(2),'linewidth',1.5);
ylim([-0.4 0.2]);
title('PCE vs PCE net of shelter')
legend('PCE','PCE net of shelter', 'location','southeast')
ax = gca;
ax.XGrid = 'off';
ax.YGrid = 'on';


%%  FAVAR shocks
X = linspace(1,48,48);

subplot(3,2,3)
h=plot(X, IRF_favar(:,1), 'r', X, IRF_favar(:,2), 'b--');
[ph,msg]=jbfill(X,LOWER_favar(:,1)',UPPER_favar(:,1)',[0 0 1],[0 0 0],1,0.1)
[ph,msg]=jbfill(X,LOWER_favar(:,2)',UPPER_favar(:,2)',[0 0 1],[0 0 0],1,0.25)
set(h(1),'linewidth',1.5);
set(h(2),'linewidth',1.5);
%ylim([-0.4 0.2]);
ylabel('FAVAR Shocks')
%title('FAVAR: CPI vs CPI net of shelter')
%legend('CPI','CPI net of shelter', 'location','south')
ax = gca;
ax.XGrid = 'off';
ax.YGrid = 'on';

subplot(3,2,4)
h=plot(X, IRF_favar(:,3), 'r', X, IRF_favar(:,4), 'b--');
[ph,msg]=jbfill(X,LOWER_favar(:,3)',UPPER_favar(:,3)',[0 0 1],[0 0 0],1,0.1)
[ph,msg]=jbfill(X,LOWER_favar(:,4)',UPPER_favar(:,4)',[0 0 1],[0 0 0],1,0.25)
set(h(1),'linewidth',1.5);
set(h(2),'linewidth',1.5);
%ylim([-0.4 0.2]);
%title('FAVAR: PCE vs PCE net of shelter')
%legend('PCE','PCE net of shelter', 'location','south')
ax = gca;
ax.XGrid = 'off';
ax.YGrid = 'on';




%% Romer and Romer shocks
X = linspace(1,48,48);

subplot(3,2,5)
h=plot(X, IRF_rr_cpi(:,3), 'r', X, IRF_rr_cpi(:,6), 'b--');
[ph,msg]=jbfill(X,IRF_rr_cpi(:,1)',IRF_rr_cpi(:,2)',[0 0 1],[0 0 0],1,0.1)
[ph,msg]=jbfill(X,IRF_rr_cpi(:,4)',IRF_rr_cpi(:,5)',[0 0 1],[0 0 0],1,0.25)
set(h(1),'linewidth',1.5);
set(h(2),'linewidth',1.5);
ylim([-0.4 0.2]);
%title('Romer and Romer: CPI vs CPI net of shelter')
ylabel('Romer and Romer Shocks')
%legend('CPI','CPI net of shelter', 'location','south')
ax = gca;
ax.XGrid = 'off';
ax.YGrid = 'on';

subplot(3,2,6)
h=plot(X, IRF_rr_pce(:,3), 'r', X, IRF_rr_pce(:,6), 'b--');
[ph,msg]=jbfill(X,IRF_rr_pce(:,2)',IRF_rr_pce(:,1)',[0 0 1],[0 0 0],1,0.1)
[ph,msg]=jbfill(X,IRF_rr_pce(:,5)',IRF_rr_pce(:,4)',[0 0 1],[0 0 0],1,0.25)
set(h(1),'linewidth',1.5);
set(h(2),'linewidth',1.5);
ylim([-0.4 0.2]);
%title('Romer and Romer: PCE vs PCE net of shelter')
%legend('PCE','PCE net of shelter', 'location','south')
ax = gca;
ax.XGrid = 'off';
ax.YGrid = 'on';



%matlab2tikz('irfs_test_figure.tikz');








