% Dias and Duarte
% All mistakes are our own. Please email joao.duarte@novasbe.pt for any
% mistakes or bugs found.
% last update: 8/10/2018


clear all

[data,txt,raw] = xlsread('datasets/data/inflation_measures_data.xlsx');

series = txt(1,:);

format long

figure 

%% CPI vs CPI Net and PCE vs PCE net
date2  = datenum(txt(2:end,1), 'yyyy-mm-dd'); 

subplot(1,2,1)
h=plot(date2, data(:,3), 'b', date2, data(:,21), 'r');
set(h,'linewidth',1.5);
%ylim([-0.1 0.4]);
xlim([724277 737030])
xticks([724277, 737030])
datetick('x','mmm/yyyy', 'keepticks')
title('CPI vs CPI net of shelter', 'FontName', 'AvantGarde','FontSize',12)
legend('CPI','CPI net of shelter', 'location', 'southeast')
ax = gca;
ax.XGrid = 'off';
ax.YGrid = 'on';


subplot(1,2,2)
h=plot(date2, data(:,4), 'b', date2, data(:,23), 'r');
set(h,'linewidth',1.5);
%ylim([-0.1 0.4]);
xlim([724277 737030])
xticks([724277, 737030])
datetick('x',2,'keepticks')
title('PCE vs PCE net of shelter', 'FontName', 'AvantGarde','FontSize',12)
legend('PCE','PCE net of shelter', 'location', 'southeast')
ax = gca;
ax.XGrid = 'off';
ax.YGrid = 'on';

%matlab2tikz('index_vs_net_figure2.tikz');

%print('irfs_index_vs_net_figure','-dpng', '-r1500')

figure

subplot(1,2,1)
h=plot(date2(2:end), diff(log(data(:,3)))*100, 'b', date2(2:end), diff(log(data(:,21)))*100, 'r--');
set(h(1),'linewidth',1.15);
set(h(2),'linewidth',0.8);
ylim([-3 2]);
xlim([724277 737030])
xticks([724277, 737030])
datetick('x',2,'keepticks')
title('CPI vs CPI net of shelter Inflation', 'FontName', 'AvantGarde','FontSize',12)
legend('CPI','CPI net of shelter', 'location', 'southwest')
ax = gca;
ax.XGrid = 'off';
ax.YGrid = 'on';

subplot(1,2,2)
h=plot(date2(2:end), diff(log(data(:,4)))*100, 'b', date2(2:end), diff(log(data(:,23)))*100, 'r--');
set(h(1),'linewidth',1.15);
set(h(2),'linewidth',0.8);
ylim([-3 2]);
xlim([724277 737030])
xticks([724277, 737030])
datetick('x',2, 'keepticks')
title('PCE vs PCE net of shelter Inflation', 'FontName', 'AvantGarde','FontSize',12)
legend('PCE','PCE net of shelter', 'location', 'southwest')
ax = gca;
ax.XGrid = 'off';
ax.YGrid = 'on';

%matlab2tikz('inf_vs_net_figure2.tikz');

