***********************************************************************************************************
** this do file produces falsification graphs
** last update: 26/09/2021
***********************************************************************************************************

clear all
set more off
set scheme s1mono

global dir "dl-files/Empirical"

cd $dir
global raw_data "$dir/Data/Raw"
global working_data "$dir/Data/Working"
global out_files "$dir/Output"

**==============================================================================
use $working_data/sampleHealth.dta, clear
keep if male == 0

frame create sim mean var
quietly{
	forvalues i = 1/5000 {
		shufflevar stdcount1
		ivregress 2sls stdcount1_shuffled (hunger = logedr) if male == 0, cl(birthProv)
		frame post sim (_b[hunger]) (_se[hunger])
		drop stdcount1_shuffled
	}
}

frame sim: gen tstdcount = mean/var
*t 2.68
frame sim: hist tstdcount, xline(2.64, lc(cranberry)) ysc(r(0 0.42)) ylab(0(0.1)0.4) xsc(r(-10 10)) xlab(-10(5)10) xtitle("t-stat") width(0.5)  /*
*/ text(0.41 -0.75 "p = .028")
graph export "$out_files/Fig5a.pdf", replace

**==============================================================================
use $working_data/sampleHealth.dta, clear
keep if male == 1

frame create sim2 mean var
quietly{
	forvalues i = 1/5000 {
		shufflevar stdcount1
		ivregress 2sls stdcount1_shuffled (hunger = logedr) if male == 1, cl(birthProv)
		frame post sim2 (_b[hunger]) (_se[hunger])
		drop stdcount1_shuffled
	}
}

frame sim2: gen tstdcount = mean/var
*t 0.12
frame sim2: hist tstdcount, xline(0.225, lc(cranberry)) ysc(r(0 0.42)) ylab(0(0.1)0.4) xsc(r(-10 10)) xlab(-10(5)10) xtitle("t-stat") width(0.5) /*
*/ text(0.41 -0.75 "p = .91")
graph export "$out_files/Fig5b.pdf", replace






