alpha.est = function(filename, Nobs, D = 2, type = "pers", p = 1, Niter = 20){
  
  data = as.matrix(read.table(paste(filename,".txt",sep="")))
  Ncases = 26
  a.sym = 0.5
  
  ######## Main code ########
  alphas =  matrix(0,nrow=Ncases/2, ncol=1)           #zeros(Ncases/2,1); 
  sdevs = matrix(0,nrow=Ncases/2, ncol=1)             #zeros(Ncases/2,1);
  jtests = matrix(0,nrow=Ncases/2, ncol=4)            #zeros(Ncases/2,4);
  ttests = matrix(0,nrow=Ncases/2, ncol=1) 
  
  a = c()
  iter = 1
  while(iter <= Ncases){
    t = Nobs[iter]                                                    # the number of years
    VARf = matrix(data[(max(Nobs)-t+1):(max(Nobs)),iter],ncol=1)      # forecast series
    VARt = matrix(data[(max(Nobs)-t+1):(max(Nobs)),(iter+1)],ncol=1)  # true series 
    fe = VARt-VARf                                                    # forecast error series
    
    ##################################################################
    # Construction of instruments
    if(D==1){
      w = matrix(1,nrow=(t-1),ncol=1)
    }else{
      if(D==2){
        if(type=="stat"){
          # constant and a stationary instrument
          w = cbind(matrix(1,nrow=(t-1),ncol=1), fe[1:(t-1),])
        }else{
            # constant and a persistent instrument
            w = cbind(matrix(1,nrow=(t-1),ncol=1), VARt[1:(t-1),])
            }
      }else{
        w = cbind(matrix(1,nrow=(t-1),ncol=1),fe[1:(t-1),],VARt[1:(t-1),]) 
      }
    }
    ##################################################################
    
    # Construction of series to be analysed from 2:T
    VARf = VARf[2:t,]
    VARt = VARt[2:t,]
    fe = fe[2:t,]
    vfe = matrix(0, nrow=t-1, ncol=D)     #zeros(t-1,D);
    vdfe = matrix(0, nrow=t-1, ncol=D)    #zeros(t-1,D);
    vdafe = matrix(0, nrow=t-1, ncol=D)   #zeros(t-1,D);
    
    ##################################################################
    # Iteration i = 1
    # Starting value for S
    s = array(0, dim=c(D,D,t-1))
    for(i in 1:(t-1)){
      s[,,i] = outer(w[i,],w[i,])*(as.integer(fe[i]<0)-a.sym)^2*abs(fe[i])^(2*p-2)
      }
    
    S = apply(s,c(1,2),mean)

    for(i in 1:(t-1)){
      vfe[i,] = w[i,]*abs(fe[i])^(p-1)
      vdfe[i,] = w[i,]*abs(fe[i])^(p-1)*as.integer(fe[i]<0)
    }
    ##################################################################
    a[1] = (colMeans(vfe)%*%solve(S)%*%as.matrix(colMeans(vdfe)))/
           (colMeans(vfe)%*%solve(S)%*%as.matrix(colMeans(vfe)))
    ##################################################################
    
    # Iterations i = 2,3... until convergence
    for(j in 2:Niter){ 
      
      s = array(0, dim=c(D,D,t-1))
      for(i in 1:(t-1)){
        s[,,i] = outer(w[i,],w[i,])*(as.integer(fe[i]<0)-a[j-1])^2*abs(fe[i])^(2*p-2)
      }
      
      S = apply(s,c(1,2),mean)
      #S = round(S,2)
      for(i in 1:(t-1)){
        vfe[i,] = w[i,]*abs(fe[i])^(p-1)
        vdfe[i,] = w[i,]*abs(fe[i])^(p-1)*as.integer(fe[i]<0)
      }
      
      a[j] = (colMeans(vfe)%*%solve(S)%*%as.matrix(colMeans(vdfe)))/
             (colMeans(vfe)%*%solve(S)%*%as.matrix(colMeans(vfe)))
    }
    ##################################################################
    a = a[Niter]
    ##################################################################

    # Estimation of parameter std deviation (proposition (4))

    h = colMeans(vfe)
    sig2 = as.numeric((h%*%solve(S)%*%as.matrix(h))^(-1))
    sig = sqrt(sig2)/sqrt(t-1)
    
    ##################################################################
    # Construction of the J-statistic (Corollary 5) under ASYMMETRIC loss
    for(i in 1:(t-1)){
      vdafe[i,] = w[i,]*(as.integer(fe[i]<0)-a)*abs(fe[i])^(p-1)
    }
    J = (1/(t-1))*(colSums(vdafe)%*%solve(S)%*%as.matrix(colSums(vdafe)))
    
    ##################################################################
    # Construction of the t-statistic
    tstat = (a-a.sym)/sig
    ##################################################################
    
    alphas[(iter+1)/2] = a
    sdevs[(iter+1)/2] = sig
    jtests[(iter+1)/2,1] = as.numeric(J)
    ttests[(iter+1)/2] = tstat
    
    ##################################################################
    # J-statistic under SYMMETRIC loss: a=0.20;
    a0 = 0.2
    s = array(0, dim=c(D,D,t-2))
    for(i in 1:(t-2)){
      s[,,i] = outer(w[i,],w[i,])*(as.integer(fe[i]<0)-a0)^2*abs(fe[i])^(2*p-2)
    }
    S = apply(s,c(1,2),mean)
    #S = round(S,2)
    for(i in 1:(t-2)){
      vdafe[i,] = w[i,]*(as.integer(fe[i]<0)-a0)*abs(fe[i])^(p-1)
    }
    
    Jasym = (1/(t-1))*(colSums(vdafe)%*%solve(S)%*%as.matrix(colSums(vdafe)))
    jtests[(iter+1)/2,2] = as.numeric(Jasym)
    ##################################################################
    # J-statistic under SYMMETRIC loss: a=0.50;
    a0 = 0.5
    s = array(0, dim=c(D,D,t-2))
    for(i in 1:(t-2)){
      s[,,i] = outer(w[i,],w[i,])*(as.integer(fe[i]<0)-a0)^2*abs(fe[i])^(2*p-2)
    }
    S = apply(s,c(1,2),mean)
    #S = round(S,2)
    for(i in 1:(t-2)){
      vdafe[i,] = w[i,]*(as.integer(fe[i]<0)-a0)*abs(fe[i])^(p-1)
    }
    Jasym = (1/(t-1))*(colSums(vdafe)%*%solve(S)%*%as.matrix(colSums(vdafe)))
    jtests[(iter+1)/2,3] = as.numeric(Jasym)
    ##################################################################
    # J-statistic under SYMMETRIC loss: a=0.80;
    a0 = 0.8
    s = array(0, dim=c(D,D,t-2))
    for(i in 1:(t-2)){
      s[,,i] = outer(w[i,],w[i,])*(as.integer(fe[i]<0)-a0)^2*abs(fe[i])^(2*p-2)
    }
    S = apply(s,c(1,2),mean)
    #S = round(S,2)
    for(i in 1:(t-2)){
      vdafe[i,] = w[i,]*(as.integer(fe[i]<0)-a0)*abs(fe[i])^(p-1)
    }
    Jasym = (1/(t-1))*(colSums(vdafe)%*%solve(S)%*%as.matrix(colSums(vdafe)))
    jtests[(iter+1)/2,4] = as.numeric(Jasym)
    ##################################################################
    
    iter = iter + 2
  }#### End Main code
  
  final = cbind(alphas,sdevs,ttests,jtests)
  row.names(final) = c("BE","DK","DE","GR","ES","FR","IE","IT","LU","NL",
                       "PT","UK","EU")
  colnames(final) = cbind("alpha","SE","t","J","J_02","J_05","J_08")
  return(final)
}

