
gen id=1
gen cat=1
replace id=sum(id)
replace id=ceil(id/4)
sort id
replace cat=cat[_n-1]+1 if id==id[_n-1]
sort id cat

set seed 1

local T = 4

forvalues j = 1(1)`T'{

* FIRST  AND SECOND FACTOR TECHNOLOGY

gen TFPC`j'   = 1.5
gen psiC`j' = 1.25   /*  */
gen phiC`j' = 0.5   /*  */
gen tau1C`j' = 0.5   /*   */
gen tau2C`j' = 0.2   /*   */


gen TFPN`j'   = 1.5
gen psiN`j' = 1.25  /*  */
gen phiN`j' = -0.5   /*  */
gen tau1N`j' = 0.5   /*   */
gen tau2N`j' = 0.1   /*   */

gen sigma`j' = 0.5

* INVESTMENT FUNCTION

gen alpha0`j'=0.5
gen alpha1`j'=0.2   /*   */
gen alpha2`j'=0.2   /*   */
gen alpha3`j'=0.2   /*   */
gen alpha4`j'=0.2   /*   */

gen sigmai`j'=0.3

}


* WAGE FUNCTION

gen rho0=0.2  /* Constant */
gen rho1=0.8  /* Past Income */
gen sigmaw=0.7

* INITIAL CONDITIONS

gen mu_1=2  /* Skill 1 */
gen mu_2=2  /* Skill 2 */
gen mu_3=0  /* Mothers' Skills */
gen mu_4=10  /* Income */


matrix V=[0,0,0,0\0,0,0,0\0,0,0,0\0,0,0,0]

* C
matrix V[1,1] = 2.0
matrix V[1,2] = 0.5
matrix V[2,1] = 0.5
matrix V[1,3] = 0.15
matrix V[3,1] = 0.15
matrix V[1,4] = 0.3
matrix V[4,1] = 0.3
* NC
matrix V[2,2] = 2.0
matrix V[2,3] = 0.15
matrix V[3,2] = 0.15
matrix V[2,4] = 0.25
matrix V[4,2] = 0.25
* M
matrix V[3,3] = 0.3
matrix V[3,4] = 0.1
matrix V[4,3] = 0.1
* Y
matrix V[4,4] = 1.0

matrix S = cholesky(V)

mat list S


*Adult outcome

gen mu_Q=5

gen alpha_Q1=1
gen alpha_Q2=0.5

gen c1=rnormal(0,1) if cat==1
gen c2=rnormal(0,1) if cat==1
gen c3=rnormal(0,1) if cat==1
gen c4=rnormal(0,1) if cat==1

gen C=mu_1+S[1,1]*c1
gen N=mu_2+S[2,1]*c1+S[2,2]*c2
gen M=mu_3+S[3,1]*c1+S[3,2]*c2+S[3,3]*c3
gen FI=mu_4+S[4,1]*c1+S[4,2]*c2+S[4,3]*c3+S[4,4]*c4
gen I=.

by id: replace M=M[_n-1] if id==id[_n-1]


forvalues j = 2(1)`T'{
local j_m1 = `j' - 1

replace I=alpha0`j_m1'+alpha1`j_m1'*C+alpha2`j_m1'*N+alpha3`j_m1'*FI+alpha4`j_m1'*M+sigmai`j_m1'*rnormal(0,1) if cat==`j'-1

replace C=TFPC`j_m1'+(psiC`j_m1'/phiC`j_m1')*log(tau1C`j_m1'*exp(C[_n-1]*phiC`j_m1')+tau2C`j_m1'*exp(N[_n-1]*phiC`j_m1')+(1-tau1C`j_m1'-tau2C`j_m1')*exp(I[_n-1]*phiC`j_m1'))+sigma`j_m1'*rnormal(0,1) if cat==`j'
replace N=TFPN`j_m1'+(psiN`j_m1'/phiN`j_m1')*log(tau1N`j_m1'*exp(N[_n-1]*phiN`j_m1')+tau2N`j_m1'*exp(C[_n-1]*phiN`j_m1')+(1-tau1N`j_m1'-tau2N`j_m1')*exp(I[_n-1]*phiN`j_m1'))+sigma`j_m1'*rnormal(0,1) if cat==`j'

replace FI=rho0+rho1*FI[_n-1]+sigmaw*rnormal(0,1) if cat==`j'

}


gen Q=mu_Q+alpha_Q1*C+alpha_Q2*N if cat==4


*******************************;
*Generate Observed Variables
*******************************;

gen lambda_Mi1 = 1
gen lambda_Mi2 = 1
gen lambda_Mi3 = 1

gen mu_Mi1 = 0
gen mu_Mi2 = 0
gen mu_Mi3 = 0

gen Z_1 = .
gen Z_2 = .
gen Z_i =.

forvalues j = 1(1)4{
replace Z_1 = mu_M1`j'+lambda_M1`j'*C if cat==`j'
replace Z_2 = mu_M2`j'+lambda_M2`j'*N if cat==`j'

if (`j'<4) {
replace Z_i = mu_Mi`j'+lambda_Mi`j'*I if cat==`j'
}


}

gen Z_M=M
gen Z_W=FI
gen Z_Q=Q

keep id cat Z_*

save data_mis_specify,replace



