
local T = 4

*Average INITIAL skills
sum Z_1 if cat==1
gen MU_C1=(r(mean)-MU1)/LAMBDA1
sum Z_2 if cat==1
gen MU_N1=(r(mean)-MU1)/LAMBDA1
sum Z_M if cat==1
gen MU_M=r(mean)

*loading
gen L_C1=LAMBDA1
gen L_C2= LAMBDA2
gen L_C3= LAMBDA3
gen L_C4= LAMBDA4

*loading
gen L_N1=LAMBDA1
gen L_N2= LAMBDA2
gen L_N3= LAMBDA3
gen L_N4= LAMBDA4

*mean
gen M_C1=MU1
gen M_C2=MU2
gen M_C3=MU3
gen M_C4=MU4

gen M_N1=MU1
gen M_N2=MU2
gen M_N3=MU3
gen M_N4=MU4


*Average skills
gen MU_C=MU_C1
gen MU_N=MU_N1


*standardized
gen Z_C=(Z_1-M_C1)/L_C1 if cat==1
gen Z_N=(Z_2-M_N1)/L_N1 if cat==1
gen Z_I=.
 

******  INCOME  ***********

sum Z_W if cat==1
gen M_y0=r(mean)

sort id cat
gen P_W=Z_W[_n-1] if id==id[_n-1]

reg Z_W P_W

gen sigmaw=sqrt(e(rss)/(e(N)-1))

gen rho0=_b[_cons]
gen rho1=_b[P_W]


* Time Loop
foreach i in 1 2 3 {


** INITIAL CONDITIONS **

if (`i'==1){

matrix V=[0,0,0,0\0,0,0,0\0,0,0,0\0,0,0,0]

* C
correlate Z_C Z_C if cat==1, covariance
matrix V[1,1] = r(cov_12)
correlate Z_C Z_N if cat==1, covariance
matrix V[1,2] = r(cov_12)
matrix V[2,1] = r(cov_12)
correlate Z_C Z_M if cat==1, covariance
matrix V[1,3] = r(cov_12)
matrix V[3,1] = r(cov_12)
correlate Z_C Z_W if cat==1, covariance
matrix V[1,4] = r(cov_12)
matrix V[4,1] = r(cov_12)
* N
correlate Z_N Z_N if cat==1, covariance
matrix V[2,2] = r(cov_12)
correlate Z_N Z_M if cat==1, covariance
matrix V[2,3] = r(cov_12)
matrix V[3,2] = r(cov_12)
correlate Z_N Z_W if cat==1, covariance
matrix V[2,4] = r(cov_12)
matrix V[4,2] = r(cov_12)
* M
correlate Z_M Z_M if cat==1, covariance
matrix V[3,3] = r(cov_12)
correlate Z_M Z_W if cat==1, covariance
matrix V[3,4] = r(cov_12)
matrix V[4,3] = r(cov_12)
* Y
correlate Z_W Z_W if cat==1, covariance
matrix V[4,4] = r(cov_12)

matrix S = cholesky(V)

}

******  INVESTMENTS ***********


reg Z_i Z_C Z_N Z_M Z_W  if cat==`i'

est store Inv$run`i'

predict err_I`i', residual

*gen L_I`i'= _b[Z_C]+_b[Z_N]+_b[Z_M]+_b[Z_W]
gen L_I`i'= 1

gen alpha_0`i'=_b[_cons]

gen alpha_1`i'=_b[Z_C]/L_I`i'
gen alpha_2`i'=_b[Z_N]/L_I`i'
gen alpha_3`i'=_b[Z_M]/L_I`i'
gen alpha_4`i'=_b[Z_W]/L_I`i'
gen M_I`i'=0

mat INV$run`i'=e(b)
mat INV$run`i'[1,1]=INV$run`i'[1,1]/L_I`i'[1]
mat INV$run`i'[1,2]=INV$run`i'[1,2]/L_I`i'[1]
mat INV$run`i'[1,3]=INV$run`i'[1,3]/L_I`i'[1]
mat INV$run`i'[1,4]=INV$run`i'[1,4]/L_I`i'[1]
mat INV$run`i'[1,5]=INV$run`i'[1,5]


replace Z_I=(Z_i-M_I`i')/L_I`i' if cat==`i'

************** TECHNOLOGY ***********************

sort id cat

gen C_f= Z_1[_n+1] if  cat==`i' & id==id[_n+1]

gen int1=Z_C*Z_C
gen int2=Z_C*Z_N
gen int3=Z_C*Z_I

reg C_f Z_C Z_N Z_I int1 int2 int3 if cat==`i'

est store TechC$run`i'

predict err_C`i', residual

local i_f=`i'+1

gen AC`i'=(_b[_cons]-M_C`i_f')/L_C`i_f'

gen gammaC_1`i'=_b[Z_C]/L_C`i_f'
gen gammaC_2`i'=_b[Z_N]/L_C`i_f'
gen gammaC_3`i'=_b[Z_I]/L_C`i_f'
gen gammaC_4`i'=_b[int1]/L_C`i_f'
gen gammaC_5`i'=_b[int2]/L_C`i_f'
gen gammaC_6`i'=_b[int3]/L_C`i_f'


mat TECHC$run`i'=e(b)
mat TECHC$run`i'[1,1]=TECHC$run`i'[1,1]/L_C`i_f'[1]
mat TECHC$run`i'[1,2]=TECHC$run`i'[1,2]/L_C`i_f'[1]
mat TECHC$run`i'[1,3]=TECHC$run`i'[1,3]/L_C`i_f'[1]
mat TECHC$run`i'[1,4]=TECHC$run`i'[1,4]/L_C`i_f'[1]
mat TECHC$run`i'[1,5]=TECHC$run`i'[1,5]/L_C`i_f'[1]
mat TECHC$run`i'[1,6]=TECHC$run`i'[1,6]/L_C`i_f'[1]
mat TECHC$run`i'[1,7]=(TECHC$run`i'[1,7]- M_C`i_f'[1])/L_C`i_f'[1]


replace  Z_C=(Z_1-M_C`i_f')/L_C`i_f' if cat==`i_f'

sum Z_C if cat==`i_f'
replace MU_C=r(mean)


gen N_f= Z_2[_n+1] if  cat==`i' & id==id[_n+1]

replace int1=Z_N*Z_N
replace int2=Z_C*Z_N
replace int3=Z_N*Z_I

reg N_f Z_N Z_C Z_I int1 int2 int3 if cat==`i'

est store TechN$run`i'

predict err_N`i', residual

local i_f=`i'+1

gen AN`i'=(_b[_cons]-M_N`i_f')/L_N`i_f'

gen gammaN_1`i'=_b[Z_N]/L_N`i_f'
gen gammaN_2`i'=_b[Z_C]/L_N`i_f'
gen gammaN_3`i'=_b[Z_I]/L_N`i_f'
gen gammaN_4`i'=_b[int1]/L_N`i_f'
gen gammaN_5`i'=_b[int2]/L_N`i_f'
gen gammaN_6`i'=_b[int3]/L_N`i_f'


mat TECHN$run`i'=e(b)
mat TECHN$run`i'[1,1]=TECHN$run`i'[1,1]/L_N`i_f'[1]
mat TECHN$run`i'[1,2]=TECHN$run`i'[1,2]/L_N`i_f'[1]
mat TECHN$run`i'[1,3]=TECHN$run`i'[1,3]/L_N`i_f'[1]
mat TECHN$run`i'[1,4]=TECHN$run`i'[1,4]/L_N`i_f'[1]
mat TECHN$run`i'[1,5]=TECHN$run`i'[1,5]/L_N`i_f'[1]
mat TECHN$run`i'[1,6]=TECHN$run`i'[1,6]/L_N`i_f'[1]
mat TECHN$run`i'[1,7]=(TECHN$run`i'[1,7]- M_N`i_f'[1])/L_N`i_f'[1]


replace  Z_N=(Z_2-M_N`i_f')/L_N`i_f' if cat==`i_f'

sum Z_N if cat==`i_f'
replace MU_N=r(mean)


************** SHOCKS ***********************

sort id cat

replace err_I`i'=err_I`i'/L_I`i' if cat==`i'

replace err_C`i'=err_C`i'/L_C`i_f' if cat==`i'
by  id: replace err_C`i'=err_C`i'[_n-1] if  cat>`i'

replace err_N`i'=err_N`i'/L_N`i_f' if cat==`i'
by  id: replace err_N`i'=err_N`i'[_n-1] if  cat>`i'


correlate err_I`i' err_I`i'  if cat==`i', covariance
gen S_I`i'= sqrt(r(cov_12))

correlate err_C`i' err_C`i'  if cat==`i', covariance
gen S_C`i'= sqrt(r(cov_12))

correlate err_N`i' err_N`i'  if cat==`i', covariance
gen S_N`i'= sqrt(r(cov_12))


drop err_* C_f N_f  int*

}

reg Z_Q Z_C Z_N if cat==4

est store Adult$run

gen M_schooling=_b[_cons]
gen alpha_C=_b[Z_C]
gen alpha_N=_b[Z_N]


************************************************************************************************
************************************************************************************************
**************** SIMULATIONS *******************************************************************
************************************************************************************************
************************************************************************************************

set seed 10

local T = 4

sort id cat

gen c1=rnormal(0,1) if cat==1
gen c2=rnormal(0,1) if cat==1
gen c3=rnormal(0,1) if cat==1
gen c4=rnormal(0,1) if cat==1

gen C=MU_C1+S[1,1]*c1
gen N=MU_N1+S[2,1]*c1+S[2,2]*c2
gen M=MU_M+S[3,1]*c1+S[3,2]*c2+S[3,3]*c3
gen FI=M_y0+S[4,1]*c1+S[4,2]*c2+S[4,3]*c3+S[4,4]*c4
gen I=.

by id: replace M=M[_n-1] if id==id[_n-1]

forvalues j = 2(1)`T'{
replace FI=rho0+rho1*FI[_n-1]+sigmaw*rnormal(0,1) if cat==`j'
}

egen Y_shock=sd(FI) if cat==1


gen C_c1=C
gen N_c1=N
gen FI_c1=FI
replace FI_c1=FI+Y_shock if cat==1
gen I_c1=.

gen C_c2=C
gen N_c2=N
gen FI_c2=FI
replace FI_c2=log(exp(FI)+10000) if cat==1
gen I_c2=.

gen I_shock=.
gen C_shock=.
gen N_shock=.


forvalues j = 2(1)`T'{
local j_m1 = `j' - 1

replace I_shock=S_I`j_m1'*rnormal(0,1) if cat==`j'-1
replace C_shock=S_C`j_m1'*rnormal(0,1) if cat==`j'
replace N_shock=S_N`j_m1'*rnormal(0,1) if cat==`j'

replace I=alpha_0`j_m1'+alpha_1`j_m1'*C+alpha_2`j_m1'*N+alpha_3`j_m1'*M+alpha_4`j_m1'*FI if cat==`j'-1
replace I_c1=alpha_0`j_m1'+alpha_1`j_m1'*C_c1+alpha_2`j_m1'*N_c1+alpha_3`j_m1'*M+alpha_4`j_m1'*FI_c1 if cat==`j'-1
replace I_c2=alpha_0`j_m1'+alpha_1`j_m1'*C_c2+alpha_2`j_m1'*N_c2+alpha_3`j_m1'*M+alpha_4`j_m1'*FI_c2 if cat==`j'-1

replace C=AC`j_m1'+gammaC_1`j_m1'*C[_n-1]+gammaC_2`j_m1'*N[_n-1]+gammaC_3`j_m1'*I[_n-1]+gammaC_4`j_m1'*C[_n-1]*C[_n-1]+gammaC_5`j_m1'*N[_n-1]*C[_n-1]+gammaC_6`j_m1'*I[_n-1]*C[_n-1]+C_shock if cat==`j'
replace C_c1=AC`j_m1'+gammaC_1`j_m1'*C_c1[_n-1]+gammaC_2`j_m1'*N_c1[_n-1]+gammaC_3`j_m1'*I_c1[_n-1]+gammaC_4`j_m1'*C_c1[_n-1]*C_c1[_n-1]+gammaC_5`j_m1'*N_c1[_n-1]*C_c1[_n-1]+gammaC_6`j_m1'*I_c1[_n-1]*C_c1[_n-1]+C_shock if cat==`j'
replace C_c2=AC`j_m1'+gammaC_1`j_m1'*C_c2[_n-1]+gammaC_2`j_m1'*N_c2[_n-1]+gammaC_3`j_m1'*I_c2[_n-1]+gammaC_4`j_m1'*C_c2[_n-1]*C_c2[_n-1]+gammaC_5`j_m1'*N_c2[_n-1]*C_c2[_n-1]+gammaC_6`j_m1'*I_c2[_n-1]*C_c2[_n-1]+C_shock if cat==`j'

replace N=AN`j_m1'+gammaN_1`j_m1'*N[_n-1]+gammaN_2`j_m1'*C[_n-1]+gammaN_3`j_m1'*I[_n-1]+gammaN_4`j_m1'*N[_n-1]*N[_n-1]+gammaN_5`j_m1'*N[_n-1]*C[_n-1]+gammaN_6`j_m1'*I[_n-1]*N[_n-1]+N_shock if cat==`j'
replace N_c1=AN`j_m1'+gammaN_1`j_m1'*N_c1[_n-1]+gammaN_2`j_m1'*C_c1[_n-1]+gammaN_3`j_m1'*I_c1[_n-1]+gammaN_4`j_m1'*N_c1[_n-1]*N_c1[_n-1]+gammaN_5`j_m1'*N_c1[_n-1]*C_c1[_n-1]+gammaN_6`j_m1'*I_c1[_n-1]*N_c1[_n-1]+N_shock if cat==`j'
replace N_c2=AN`j_m1'+gammaN_1`j_m1'*N_c2[_n-1]+gammaN_2`j_m1'*C_c2[_n-1]+gammaN_3`j_m1'*I_c2[_n-1]+gammaN_4`j_m1'*N_c2[_n-1]*N_c2[_n-1]+gammaN_5`j_m1'*N_c2[_n-1]*C_c2[_n-1]+gammaN_6`j_m1'*I_c2[_n-1]*N_c2[_n-1]+N_shock if cat==`j'


}

 


******************************************************************************************************************************************************************************************;
*Anchoring and policy effects
******************************************************************************************************************************************************************************************;

gen Sch=M_schooling+alpha_C*C+alpha_N*N if cat==4
gen Sch_c1=alpha_C*(C_c1-C)+alpha_N*(N_c1-N) if cat==4
gen Sch_c2=alpha_C*(C_c2-C)+alpha_N*(N_c2-N) if cat==4


sum Sch_c1
gen treat_adult_sd=r(mean)
sum Sch_c2
gen treat_adult_1k=r(mean)


egen sd=sd(C) if cat==4

gen C_std=C/sd if cat==4
gen C_c1_std=C_c1/sd if cat==4
gen C_c2_std=C_c2/sd if cat==4

gen D_C_c1_std=C_c1_std-C_std
gen D_C_c2_std=C_c2_std-C_std

sum D_C_c1_std
gen treat_stand_sd=r(mean)
sum D_C_c2_std
gen treat_stand_1k=r(mean)



























