clear all
set more off
capture log close

log using TABLE-B3.txt, replace text

****************************************
* Simulate data from a TL and cubic specification


run codes/sim-gen.do


*****************************************
*****************************************
* Estimate using a cubic specification

use data_gen_TL-flex,clear

gen LAMBDA1 = 10
gen LAMBDA2 = 15
gen LAMBDA3 = 5
gen LAMBDA4 = 11

gen MU1 = 4
gen MU2 = 6
gen MU3 = 5
gen MU4 = 6

global run=3

run codes/mis-specify-TL-flex.do

sum treat*


*****************************************
*****************************************
* Estimate using a more flexible translog
 

use data_gen_TL-flex,clear

gen LAMBDA1 = 1
gen LAMBDA2 = 1
gen LAMBDA3 = 1
gen LAMBDA4 = 1

gen MU1 = 0
gen MU2 = 0
gen MU3 = 0
gen MU4 = 0

global run=4

run codes/mis-specify-TL-flex.do

sum treat*

mat TECHC1=(TECHC31\TECHC32\TECHC33)
mat list TECHC1

mat TECHN1=(TECHN31\TECHN32\TECHN33 )
mat list TECHN1

mat TECHC2=(TECHC41\TECHC42\TECHC43)
mat list TECHC2

mat TECHN2=(TECHN41\TECHN42\TECHN43 )
mat list TECHN2
 
