

**** Identify number of zero and missing bilateral trade observations by income group and run probit regressions that are reported in Table OE.2

version 13.1

// prep helpman data for merge with gravity_98_final
use data1980s_share_iso3, clear
replace exp_iso3="IDN" if expcode==453600
replace imp_iso3="IDN" if impcode==453600

keep  year exp_iso3 imp_iso3 religion_same religion_same_recoded  n_islands
keep if year==1985
drop year

* adjustment for BEL and LUX (no observations for BEL-BLX and LUX-BLX)
preserve
keep if imp_iso3=="BLX"|exp_iso=="BLX"
replace imp_iso3="BEL" if imp_iso3=="BLX"
replace exp_iso3="BEL" if exp_iso3=="BLX"
tempfile t_1
save `t_1'

restore, preserve
keep if imp_iso3=="BLX"|exp_iso=="BLX"
replace imp_iso3="LUX" if imp_iso3=="BLX"
replace exp_iso3="LUX" if exp_iso3=="BLX"
tempfile t_2
save `t_2'

restore, preserve
keep if exp_iso3=="BLX" & imp_iso3=="FRA"
replace exp_iso3="BEL" 
replace imp_iso3="LUX"
tempfile t_3
save `t_3'

restore, preserve
keep if imp_iso3=="BLX" & exp_iso3=="FRA"
replace imp_iso3="BEL" 
replace exp_iso3="LUX"
tempfile t_4
save `t_4'

restore
append using "`t_1'"
append using "`t_2'"
append using "`t_3'"
append using "`t_4'"

* adjustment for BWA
preserve
keep if imp_iso3=="ZAF"|exp_iso=="ZAF"
replace imp_iso3="BWA" if imp_iso3=="ZAF"
replace exp_iso3="BWA" if exp_iso3=="ZAF"
tempfile t_5
save `t_5'

restore, preserve
keep if (exp_iso3=="ZAF" & imp_iso3=="AGO")
replace imp_iso3="BWA"
tempfile t_6
save `t_6'

restore, preserve
keep if imp_iso3=="ZAF" & exp_iso3=="AGO"
replace exp_iso3="BWA"
tempfile t_7
save `t_7'

restore
append using "`t_5'"
append using "`t_6'"
append using "`t_7'"


rename exp_iso3 iso3_reporter
rename imp_iso3 iso3_partner
replace iso3_rep="ROM" if iso3_rep=="ROU"
replace iso3_par="ROM" if iso3_par=="ROU"

drop if iso3_rep==""|iso3_par==""
drop if iso3_rep=="BLX"|iso3_par=="BLX"
sort iso3_r iso3_par
tempfile rel
save `rel'

// add to bilateral trade data set
use gravity_98_final, clear

sort iso3_r iso3_p

merge 1:1 iso3_r iso3_p using gravdata_headetal_1985
keep if _merge==3
drop _merge

* generate dummy variable for WTO:
egen d_wto=group(gatt_reporter gatt_partner)
gen d_wto_none = d_wto==1
	label variable d_wto_none "1 if neither country is member of GATT/WTO"
gen d_wto_both = d_wto==4
	label variable d_wto_both "1 if both countries are members of GATT/WTO"
drop d_wto

sort iso3_rep iso3_par
merge 1:1 iso3_rep iso3_par using `rel', keep(master match) nogenerate

rename iso3_rep iso3
merge m:1 iso3 using structural_98_final, keepusing(lrgdpch) nogenerate
rename iso3 iso3_rep
rename lrgdpch lrgdpch_rep


// generate dependent variables for probit regressions
gen pos_notzero_tij=bil_trade>0 if !missing(bil_trade)
	label variable pos_notzero_tij "1 if positive bilateral trade is observed, 0 if zero non-missing, excl missing"
	* 12,592 observations: 9,757 positive, 2,835 zeros
gen pos_notmissing_tij=bil_trade!=. if bil_trade!=0  
	label variable pos_notmissing_tij "1 if positive bilateral trade is observed, 0 if missing, excl zeros"
	* 12,943 observations: 9,757 postive, 3,186 missing


drop if missing(n_islands) & missing(religion_same_recoded)
	* drops 16 partner countries for which there is no data

	
	
cd ../Output

// Probit regressions

// including income as dependent variable
probit pos_notzero_tij lrgdpch_r ldistw border n_islands sumll comleg comlang_off comcur rta religion_same_recoded d_wto_none d_wto_both, vce(robust)

	outreg2 using Table_OE2_replica.xls, ///
dec(3) se paren nolabel ctitle("Prob trade>0, excl missing values") nocons nor2 ///
sortvar(lrgdpch_r ldistw border n_islands sumll comleg comlang_off comcur rta religion_same_recoded d_wto_none d_wto_both) ///
addstat("Pseudo R^2", e(r2_p)) ///
addtext("Reporter FE", "NO") ///
replace


probit pos_notmissing_tij lrgdpch_r ldistw border n_islands sumll comleg comlang_off comcur rta religion_same_recoded d_wto_none d_wto_both, vce(robust)

	outreg2 using Table_OE2_replica.xls, ///
dec(3) se paren nolabel ctitle("Prob trade>0, excl zeros") nocons nor2 ///
sortvar(lrgdpch_r ldistw border n_islands sumll comleg comlang_off comcur rta religion_same_recoded d_wto_none d_wto_both) ///
addstat("Pseudo R^2", e(r2_p)) ///
addtext("Reporter FE", "NO") ///
append

// using reporter fixed effects and without income
probit pos_notzero_tij ldistw border n_islands sumll comleg comlang_off comcur rta religion_same_recoded d_wto_none d_wto_both i.id_r, vce(robust)

	outreg2 using Table_OE2_replica.xls, ///
dec(3) se paren nolabel ctitle("Prob trade>0, excl missing values") nocons nor2 ///
keep(lrgdpch ldistw border n_islands sumll comleg comlang_off comcur rta religion_same_recoded d_wto_none d_wto_both) ///
sortvar(lrgdpch ldistw border n_islands sumll comleg comlang_off comcur rta religion_same_recoded d_wto_none d_wto_both) ///
addstat("Pseudo R^2", e(r2_p)) ///
addtext("Reporter FE", "YES") ///
append


probit pos_notmissing_tij ldistw border n_islands sumll comleg comlang_off comcur rta religion_same_recoded d_wto_none d_wto_both i.id_r, vce(robust)

	outreg2 using Table_OE2_replica.xls, ///
dec(3) se paren nolabel ctitle("Prob trade>0, excl zeros") nocons nor2 ///
keep(lrgdpch ldistw border n_islands sumll comleg comlang_off comcur rta religion_same_recoded d_wto_none d_wto_both) ///
sortvar(lrgdpch ldistw border n_islands sumll comleg comlang_off comcur rta religion_same_recoded d_wto_none d_wto_both) ///
addstat("Pseudo R^2", e(r2_p)) ///
addtext("Reporter FE", "YES") ///
append


cd ../Data
