

// generates outcomes Online Appendix Table OE.1

version 13.1

clear

use data_regulation_share

replace iso3="IDN" if name=="Indonesia" & missing(iso3)
replace iso3="YUG" if name=="Serbia and Montenegro" & missing(iso3)
replace iso3="KIR" if name=="Kiribati" & missing(iso3)
replace iso3="ROM" if iso3=="ROU"


expand 2 if iso3=="BLX" , generate(kopie)
replace iso3="BEL" if iso3=="BLX" & kopie==0
replace iso3="LUX" if iso3=="BLX" & kopie==1
drop kopie

sort iso3

tempfile tregulation
save `tregulation'


clear
use structural_98_final
merge 1:1 iso3 using `tregulation'
drop if _merge==2
drop _merge
sum cost_gni_cap if !missing(cost_gni_cap) , detail
gen ind_cost_new = 1 if cost_gni_cap>r(p50)
replace ind_cost_new = 0 if cost_gni_cap<=r(p50) & ind_cost_new==.
replace ind_cost_new = . if missing(cost_gni_cap)
browse iso3 days proc ind_procdays
sort days proc
sum proc, detail
sum days, detail
descr days proc ind_procdays
gen ind_procdays_new = 0 if days<=38 
replace ind_procdays_new = 0 if proc<=10
replace ind_procdays_new = 1 if days>38 & proc>10
replace ind_procdays_new =. if missing(days)
tab ind_procdays_new ind_procdays
preserve


use trans_infr_limao-venables, clear
tempfile tinfr
duplicates drop iso3_r, force
keep iso3_reporter *_r
sort iso3_r
rename *_r *
rename iso3_reporter iso3
save `tinfr'


restore
merge 1:1 iso3 using `tinfr'
drop if _merge==2
drop _merge
preserve



* Regressions to construct Table OE.1

cd ../Output

nbreg numpar_i ind_cost_new ind_procdays_new, vce(robust)
	outreg2 using Table_OE1_replica.xls, ///
	dec(4) se paren nolabel ctitle("Ni") nocons nor2 ///
	keep (ind_cost_new ind_procdays_new) ///
	sortvar (ind_cost_new ind_procdays_new) ///
	replace
	

nbreg numpar_i ind_cost_new ind_procdays_new infr infr_trans, vce(robust)
	outreg2 using Table_OE1_replica.xls, ///
	dec(4) se paren nolabel ctitle("Ni") nocons nor2 ///
	keep (ind_cost_new ind_procdays_new infr infr_trans) ///
	sortvar (ind_cost_new ind_procdays_new infr infr_trans) /// 
	append


nbreg numpar_i ind_cost_new ind_procdays_new infr infr_trans lrgdpch, vce(robust)
	outreg2 using Table_OE1_replica.xls, ///
	dec(4) se paren nolabel ctitle("Ni") nocons nor2 ///
	keep (ind_cost_new ind_procdays_new infr infr_trans lrgdpch) ///
	sortvar(ind_cost_new ind_procdays_new infr infr_trans lrgdpch) ///
	append
	
cd ../Data	
