

// Averages results from 1000 replications into Table E, Table OD.1 or Table OD.2

* !!!  significance level is dependendent on number of covariates; used Tsig10 and Tsig05 (as generated in line 17 and 18 throughout).


version 13.1

if "$version"=="use_org_results" {
	use results_r_98_1000dr_org.dta , clear
		// generate tables from results produced by authors
}
else {
	local s = $s
	use "results_r_98_`s'dr_replica.dta" , clear
		// generate tables from results produced by replicating the simulation with $s iterations
}

cd ../Output

if regexm("$coeff", "all vars")== 1 {

	if $p ==1 {
		local tablename "Table_OD1"
		global z = $q
		
		global estlist b_open b_lpop b_larea b_dist2equ b_tropicar b_d_subsahafrica b_d_eseasia b_d_latamerica 

		putexcel A3=("Trade share") A7=("Ln population") A11=("Ln Area") A15=("Distance to Equator") A19=("%Land in Tropics") A23=("Sub-Saharan Africa") A27=("East Asia") A31=("Latin America") A35=("Obs.") using "`tablename'_replica", replace
		
	}
	
	else {
		local tablename "Table_OD2"
		global z = $q+1-$p
	
		global estlist b_open b_lpop b_larea b_dist2equ b_tropicar b_d_subsahafrica b_d_eseasia b_d_latamerica b_latitude b_troppop b_icrg_kk b_corrup b_xconst b_elf60 b_legorigin

		putexcel A3=("Trade share") A7=("Ln population") A11=("Ln Area") A15=("Distance to Equator") A19=("%Land in Tropics") A23=("Sub-Saharan Africa") A27=("East Asia") A31=("Latin America") A35=("Latitude") A39=("%Pop in Tropics") A43=("ICRG index") A47=("Corruption") A51=("Exec. constraint") A55=("Eth-Ling fraction.") A59=("Legal origin") using "`tablename'_replica", replace

		putexcel A63=("Obs.") A65=("T-hat") A69=("Partial R-squared") A71=("KP rk Wald F-sta") /*A73=("CD Wald F-stat")*/ using "`tablename'_replica", modify
	
	}

}

else {
	local tablename "Table_3"
	global z = $q
	
	global estlist b_open 
	
	putexcel A3=("Trade share") A7=("Obs.") A9=("T-hat") A13=("Partial R-squared") A15=("KP rk Wald F-sta") /*A17=("CD Wald F-stat")*/ using "`tablename'_replica", replace
	
	
}

* generate threshold t-value significance at 10% and 5%
egen num_cov=rownonmiss(b_open b_lpop b_larea b_latitude b_troppop b_legorigin b_corrup b_xconst b_elf60 b_icrg_kk b_d_subsahafrica b_d_latamerica b_d_eseasia b_tropicar b_dist2equ)
gen Tsig10=invttail(N-num_cov,0.05)
gen Tsig05=invttail(N-num_cov,0.025)


local a = $p

forvalues n=1(1)$z {
forvalues m=1(1)2 {

* attribute columns to output
if `n'==1 {
	if `m'==2 {
	local col="B"
	}
	else {
	local col="C"
	}
	}
if `n'==2 {
	if `m'==2 {
	local col="D"
	}
	else {
	local col="E"
	}
	}
if `n'==3 {
	if `m'==2 {
	local col="F"
	}
	else {
	local col="G"
	}
	}
if `n'==4 {
	if `m'==2 {
	local col="H"
	}
	else {
	local col="I"
	}
	}
if `n'==5 {
	if `m'==2 {
	local col="J"
	}
	else {
	local col="K"
	}
	}
if `n'==6 {
	if `m'==2 {
	local col="L"
	}
	else {
	local col="M"
	}
	}
if `n'==7 {
	if `m'==2 {
	local col="N"
	}
	else {
	local col="O"
	}
	}
if `n'==8 {
	if `m'==2 {
	local col="P"
	}
	else {
	local col="Q"
	}
	}
if `n'==9 {
	if `m'==2 {
	local col="R"
	}
	else {
	local col="S"
	}
	}	
if `n'==10 {
	if `m'==2 {
	local col="T"
	}
	else {
	local col="U"
	}
	}
if `n'==11 {
	if `m'==2 {
	local col="V"
	}
	else {
	local col="W"
	}
	}
if `n'==12 {
	if `m'==2 {
	local col="X"
	}
	else {
	local col="Y"
	}
	}
if `n'==13 {
	if `m'==2 {
	local col="Z"
	}
	else {
	local col="AA"
	}
	}
if `n'==14 {
	if `m'==2 {
	local col="AB"
	}
	else {
	local col="AC"
	}
	}
	

local row = 3

foreach covariate in $estlist {
sum `covariate' if reg_id==`a' & pred_method==`m'
if r(mean)!=. {
local b`m'=r(mean)
local b`m' : display %9.3f `b`m'' 			/* displays value coeff to 3 decimals */
local sd`m'=r(sd)
local sd`m' : display %9.3f `sd`m''

* count number of times that covariate is significant at 10%
local var=substr("`covariate'",3,.)
gen sig10=1 if abs(t_`var'_adj)>Tsig10
sum sig10 if reg_id==`a' & pred_method==`m'
local freq10`m'=r(N)
* at 5% percent
gen sig05=1 if abs(t_`var'_adj)>Tsig05
sum sig05 if reg_id==`a' & pred_method==`m'
local freq05`m'=r(N)

* transfer to Excel
if `m'==2 {
putexcel `col'1=("Model (`a')") `col'2=("IV-T_hat^All") using "`tablename'_replica", modify
}
else {
putexcel `col'2=("IV-T_hat^Pos") using "`tablename'_replica", modify
}
local rowsd = `row'+1
local rowsig10 = `row'+2
local rowsig05 = `row'+3
putexcel `col'`row'=("`b`m''") `col'`rowsd'=("(`sd`m'')") `col'`rowsig10'=("[`freq10`m'']") `col'`rowsig05'=("{`freq05`m''}") using "`tablename'_replica", modify

drop sig10 sig05
}
local row = `row' + 4 
}

*** Additional results
sum N if reg_id==`a' & pred_method==`m'
putexcel `col'`row'=(r(mean)) using "`tablename'_replica", modify

if regexm("$output", "Table_3")==1 | (regexm("$output", "Table_OD2")==1 & $p ==5) {

local row=`row'+2

* T-hat 
sum b1_T_hat if reg_id==`a' & pred_method==`m'
local b1`m'=r(mean)
local b1`m': display %9.3f `b1`m''
local sd1`m'=r(sd)
local sd1`m': display %9.3f `sd1`m''
* # of sig coefficients at 10%
gen sig10=1 if abs(t1_T_hat)>Tsig10
sum sig10 if reg_id==`a' & pred_method==`m'
local freq10`m'=r(N)
* # of sig coefficients at 5%
gen sig05=1 if abs(t1_T_hat)>Tsig05
sum sig05 if reg_id==`a' & pred_method==`m'
local freq05`m'=r(N)

local rowsd = `row'+1
local rowsig10 = `row'+2
local rowsig05 = `row'+3
putexcel `col'`row'=("`b1`m''") `col'`rowsd'=("(`sd1`m'')") `col'`rowsig10'=("[`freq10`m'']") `col'`rowsig05'=("{`freq05`m''}") using "`tablename'_replica", modify

* Partial R2
sum part_r2 if reg_id==`a' & pred_method==`m'
local pr2`m'=r(mean)
local pr2`m': display %9.3f `pr2`m''
local sdpr2`m'=r(sd)
local sdpr2`m': display %9.3f `sdpr2`m''
local row = `row'+4
local rowsd= `row'+1
putexcel `col'`row'=("`pr2`m''") `col'`rowsd'=("(`sdpr2`m'')") using "`tablename'_replica", modify


* Kleibergen Paap
sum fstat if reg_id==`a' & pred_method==`m'
local fstat`m'=r(mean)
local fstat`m': display %9.3f `fstat`m''
gen sigfstat=1 if fstat>=10
sum sigfstat if sigfstat==1 & reg_id==`a' & pred_method==`m' 
local freqfstat`m'=r(N)
local row = `row'+2
local rowsd= `row'+1
putexcel `col'`row'=("`fstat`m''") `col'`rowsd'=("<`freqfstat`m''>") using "`tablename'_replica", modify

/* // do not report CD F-stat so inactivated code
* CD F-stat
sum cdw_fstat if reg_id==`a' & pred_method==`m'
local cdfstat`m'=r(mean)
local cdfstat`m': display %9.3f `cdfstat`m''
local row = `row'+2
putexcel `col'`row'=("`cdfstat`m''") using "`tablename'_replica", modify
*/
 
drop sig10 sig05 sigfstat

}

}

local a = `a' +1

}

drop num_cov Tsig10 Tsig05


cd ../Data
