version 13.1

timer clear

timer on 1

**** Generate results in .dta files from 1000 draws

* save vars in vars_r_98_`s'dr_replica.dta 
*--> !!! Running the program will replace earlier randomization of variables and then generate differen results to the paper. The randomization used in the paper is the version called vars_r_98_1000dr_org.dta

* save shares in "T_hat_r_98_`s'dr_replica.dta".dta

* save results in "results_r_98_`s'dr_replica.dta".dta

	// where `s' is equal to $s, the number of iterations specified in 2020_replicate_output

* !!!! Note:
	* 1. we correct the condition imposed on the observations to predict alternative shares out of sample (14 sets of predicted trade shares with miniscule changes to the estimated coefficients of the bilateral trade equations)
	* 2. calculates p-values using the t-distribution instead of normal distribution; more accurate given that the structural analysis consists of 98 countries; original code is not active;

***************  END EXPLANATORY NOTE; START EXECUTION   ******************

// if running as individual do-file activate following commands as well as the commands towards the end of this .do-file
/*
global output "Table_3 Table_OD1 Table_OD2"

// specify how much of the full simulation (taking draws, generating the random instruments, running the IV regressions for the models of interest: 1 through 4, or 5 through 14) you want to run by writing either:
	// "full_sim" --> entire simulation is run accross number of iterations specified using global s below
	// "use_org_random_instr" means that iv-regression will use the random instruments produced by authors for number of iterations specified using global s below
	// "use_org_results" generates output tables with results produced by authors. NB! must set global s to 1000
	
global version "use_org_results"
*/
	
	
clear
clear matrix
clear mata
matrix drop _all
set matsize 11000
set maxvar 32767 


if "$version"=="full_sim" {
	
use gravity_98_final

* Step 1: randomize variables --> save in .dta-file

**** create identifying variable for country pair: pair_id	
egen pair1 = concat(iso3_partner iso3_reporter)
egen pair2 = concat(iso3_reporter iso3_partner)
replace pair1 = pair2 if iso3_reporter > iso3_partner
drop pair2
rename pair1 pair_id

save t0, replace			
		/* temporary file to use for remainder of .do-file;
			other temporary files t1, t2rep t2par
			all files will be erased at the end of the .do-file */ 
clear
matrix drop _all

timer on 2

forvalues x=1(1)$s {			
use t0
			
local s = $s			
			
**** create randomized variables for sumll dist and border 
keep pair_id border ldistw sumll
duplicates drop pair_id, force

* sumll is assumed to have a binomial distribution
su sumll 
	local mean=r(mean)
	local p=`mean'/2
	gen sumll_random=rbinomial(2, `p')   		/* eliminates rounding errors */
 
* border
su border
	local mean=r(mean)
gen byte border_random=uniform()<=`mean'   	/* eliminates rounding errors */
	
* distance
su ldistw
	local mean=r(mean)
	local sd=r(sd)
gen ldistw_random=rnormal(`mean', `sd') 

sort pair_id
keep pair_id border_random sumll_random ldistw_random
tempfile t1
save `t1', replace
clear

use t0
keep iso3_rep larea_r lpop_r 
duplicates drop iso3_reporter, force 

* area
su larea_r
	local mean=r(mean)
	local sd=r(sd)
gen larea_r_random=rnormal(`mean',`sd')
	
* population
su lpop_r
	local mean=r(mean)
	local sd=r(sd)
gen lpop_r_random=rnormal(`mean', `sd')
	
keep iso3_reporter larea_r_random lpop_r_random 
sort iso3_reporter
tempfile t2rep
save `t2rep', replace
rename (iso3_reporter larea_r_random lpop_r_random) (iso3_partner larea_p_random lpop_p_random)
tempfile t2par
save `t2par', replace
clear

* randomize population and area for the partner countries outside of sample
use t0
keep if dfr98_p==0
keep iso3_partner larea_p lpop_p 
duplicates drop iso3_partner, force 

* area
su larea_p
	local mean=r(mean)
	local sd=r(sd)
gen larea_p_random=rnormal(`mean',`sd')
	
* population
su lpop_p
	local mean=r(mean)
	local sd=r(sd)
gen lpop_p_random=rnormal(`mean', `sd')
	
keep iso3_partner larea_p_random lpop_p_random 
sort iso3_partner
tempfile t3
save `t3', replace
clear

use t0
sort pair_id
merge m:1 pair_id using `t1'
drop _merge

sort iso3_rep
merge m:1 iso3_rep  using `t2rep'
drop _merge

sort iso3_par
merge m:1 iso3_par using `t2par' 
drop _merge

merge m:1 iso3_par using `t3', update
drop _merge

sort iso3_r iso3_p

* save randomized variables; identified using random_id
preserve
keep iso3_r iso3_p larea_r_random larea_p_random lpop_r_random lpop_p_random  border_random ldistw_random sumll_random
gen random_id=`x'
if `x'>1 {
append using "vars_r_98_`s'dr_replica.dta"
}
save "vars_r_98_`s'dr_replica.dta", replace
restore




* create interaction terms with border for all randomized variables
foreach var in ldistw_random lpop_r_random lpop_p_random larea_r_random larea_p_random sumll_random {
	
	label variable `var' "Randomized variable"
	local varlim=substr("`var'",1,length("`var'")-7)
	generate `varlim'_bord_random = `var' * border_random
	label variable `varlim'_bord_random "Randomized Interaction `var' with border_random"
	}

	
**** STEP 2: GENERATING THE INSTRUMENTS (INCLUDING ALT SHARES TO ADJUST ST.ERRORS)

* 3a: regress bilateral trade equation

regress lbil_tsh ldistw_random lpop_r_random lpop_p_random larea_r_random larea_p_random sumll_random border_random ldistw_bord_random lpop_r_bord_random lpop_p_bord_random larea_r_bord_random larea_p_bord_random sumll_bord_random, vce(robust)

				* ADJ ST ERR: 
				*define matrices of output from the bilateral trade equation 
					matrix a=e(b)
					matrix a`x'=a			/* easiest way to save coeff grav */
					matrix Q`x'=e(V)
					matrix N`x'=e(N)
					
					gen insample=1 if e(sample)==1
						replace insample=0 if insample==.
					*gen outsample=1 if dfr98_p==1 | (dfr98_p==0 & pop_p>=100000)
					*	replace outsample=0 if outsample==.

* 3b: generate instrumental variable						
predict lpbil_tsh_ins if insample==1 , xb
	* only predicts bilateral trade for observations that report nonzero trade and population over 100000
predict lpbil_tsh_tots, xb
	* predicts bilateral trade for all observations (os=out of sample) but not for partner countries with populations under 100000

foreach pred in lpbil_tsh_ins lpbil_tsh_tots {
	label variable `pred' "Log of predicted bilateral TSH; predicted using OLS estimates from gravity"
gen exp`pred'=exp(`pred')
	label variable exp`pred' "Predicted bilateral trade share; =exp(lpbil_tsh)"
}

bysort iso3_r: egen T_rep_hat_98_ins_r`x'=sum(explpbil_tsh_ins)
	label variable T_rep_hat_98_ins_r`x' "Total predicted TSH of reporter country, randomized, in sample"

bysort iso3_r: egen T_rep_hat_98_tots_r`x'=sum(explpbil_tsh_tots)
	label variable T_rep_hat_98_tots_r`x' "Total predicted TSH of reporter country, randomized, out of sample"

* 3c: generate alternate shares to adjust standard errors	
				* ADJ ST ERR:
				* create 14 matrices that function as delta-a; 
				* one for each coeff+0.001 
				forvalues i = 1(1)14 {
					matrix delta`i'=J(1,14,0)	
					* delta`i' is a matrix with all zero's except at `i' = 0.001 
					matrix delta`i'[1,`i']=0.001
					matrix a`i'=a+delta`i'
					} 
				* create id for each observation to facilitate merge below 
				sort iso3_r iso3_p
				gen id=iso3_r + iso3_p
				gen constant=1 
				
				
preserve

* create a matrix of all observations to multiply with a1 through a14 
/*
* for in sample prediction
	* to eliminate predicting for missing trade shares (not used in estimation) we replace values with zero
foreach var in ldistw_random lpop_r_random lpop_p_random larea_r_random larea_p_random sumll_random border_random ldistw_bord_random lpop_r_bord_random lpop_p_bord_random larea_r_bord_random larea_p_bord_random sumll_bord_random constant {
	replace `var'=0 if insample==0
	}
mkmat ldistw_random lpop_r_random lpop_p_random larea_r_random larea_p_random sumll_random border_random ldistw_bord_random lpop_r_bord_random lpop_p_bord_random larea_r_bord_random larea_p_bord_random sumll_bord_random constant in 1/11000, matrix(obs_ins1) rownames(id)

mkmat ldistw_random lpop_r_random lpop_p_random larea_r_random larea_p_random sumll_random border_random ldistw_bord_random lpop_r_bord_random lpop_p_bord_random larea_r_bord_random larea_p_bord_random sumll_bord_random constant in 11001/l, matrix(obs_ins2) rownames(id)

restore, preserve
*/

* for out of sample prediction
*foreach var in ldistw_random lpop_r_random lpop_p_random larea_r_random larea_p_random sumll_random border_random ldistw_bord_random lpop_r_bord_random lpop_p_bord_random larea_r_bord_random larea_p_bord_random sumll_bord_random constant {
*	replace `var'=0 if outsample==0
*	}
mkmat ldistw_random lpop_r_random lpop_p_random larea_r_random larea_p_random sumll_random border_random ldistw_bord_random lpop_r_bord_random lpop_p_bord_random larea_r_bord_random larea_p_bord_random sumll_bord_random constant in 1/11000, matrix(obs1) rownames(id)

mkmat ldistw_random lpop_r_random lpop_p_random larea_r_random larea_p_random sumll_random border_random ldistw_bord_random lpop_r_bord_random lpop_p_bord_random larea_r_bord_random larea_p_bord_random sumll_bord_random constant in 11001/l, matrix(obs2) rownames(id)

clear

* generate 14x bilateral tradeshares using da 
forvalues i=1(1)14 { 
	matrix lptsha`i'_1=obs1*a`i''
	matrix lptsha`i'_2=obs2*a`i''
	tempfile t`i'
	svmat2 lptsha`i'_1, names(lptsha`i'_tots) rnames(id)
	save `t`i''
	clear
	svmat2 lptsha`i'_2, names(lptsha`i'_tots) rnames(id)
	append using "`t`i''"
	sort id
	order id
	save `t`i'', replace
	clear
	}

use `t1'
forvalues i=2(1)14 {
	merge 1:1 id using "`t`i''", nogenerate
	}	
	
sort id
tempfile tshares
save `tshares', replace

restore
sort id
merge 1:1 id using `tshares', nogenerate

* convert from logs into tsh and sum over iso3_r
forvalues i = 1(1)14 {
	gen lptsha`i'_ins = lptsha`i'_tots if insample==1
	replace lptsha`i'_ins=. if insample==0
	gen ptsha`i'_ins=exp(lptsha`i'_ins)
	bysort iso3_r: egen alt`i'_T_rep_hat_ins_r`x'=sum(ptsha`i'_ins)
	
	replace lptsha`i'_tots=. if lptsha`i'_tots==0 
	gen ptsha`i'_tots=exp(lptsha`i'_tots)
	bysort iso3_r: egen alt`i'_T_rep_hat_tots_r`x'=sum(ptsha`i'_tots)
	}	

* 3d: save randomized shares --> merge with cross-country data set in STEP 4
duplicates drop iso3_r, force
keep iso3_r T_rep_hat_98_ins_r`x' alt*_T_rep_hat_ins_r`x' T_rep_hat_98_tots_r`x' alt*_T_rep_hat_tots_r`x' numpar_i
order iso3_r numpar_i T_rep_hat_98_ins_* alt*_T_rep_hat_ins* T_rep_hat_98_tots_* alt*_rep_hat_tots*
rename (iso3_r) (iso3)
sort iso3

if `x'>1 {
merge 1:1 iso3 using "T_hat_r_98_`s'dr_replica.dta", nogenerate
}

mstore a`x', from (a`x')
mstore Q`x', from (Q`x')
mstore N`x', from (N`x')
		* saves matrices from gravity estimation in the .dta-file with shares

sort iso3
save "T_hat_r_98_`s'dr_replica.dta", replace
	* .dta-file contains for each draw
		* 2x predicted trade shares for each set of randomized vars r1
		* 2x 14 sets of predicted trade shares using 14 versions of da
		* one for the in-sample, the other set for the out of sample prediction
clear
matrix drop _all

}

timer off 2
}

***** STEP 3: IV-regressions using random instruments 

timer on 3

use structural_98_final

* merge with instrumental variables: predicted trade shares 

if "$version"=="use_org_random_instr" {
	merge 1:1 iso3 using T_hat_r_98_1000dr_org
}
else {
	merge 1:1 iso3 using "T_hat_r_98_`s'dr_replica.dta"
}

drop _merge


forvalues x=1(1)$s {
	/* x identifies the draw */
	
local s = $s
	
mstore Q`x', make(Q`x') 	   /* activates matrix stored in T_rep_r_98_1000dr */	
	
foreach instr in T_rep_hat_98_ins_r`x' T_rep_hat_98_tots_r`x' {
	local id=substr("`instr'",13,.)
		/* id identifies the instrument used */
	
pwcorr open T_rep_hat_98`id', sig
	matrix rho1`id'=r(rho)
	matrix N_rho1`id'=r(N)

pwcorr numpar_i T_rep_hat_98`id', sig
	matrix rho2`id'=r(rho)
	matrix N_rho2`id'=r(N)
	
local est=1							/* est identifies the structural regression */
quietly ivregress 2sls lrgdpch lpop larea (open=T_rep_hat_98`id'), robust first
	matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)		/* covariates is a list of exog instr */
		local c = e(df_m)+1				/* # of covariates in the regression */
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		* i. regress using easing alternative share
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		* ii. create matrix db/da where column`i' equals b`i'(transpose)-b/0.001 
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
		
		* iii. !!! calculate adjusted variance-covariance matrix for income regression using the formula in FR piece; 
			* sigma is the unadjusted variance-covariance matrix
			* deltab is the db/da matrix constructed above
			* Q`x' is the variance-covariance matrix from the bilateral trade equation
		
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		
		* iv. extract st error for each covariate from var-covariance matrix adj_V
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}

	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)	
		
local est=2		
quietly ivregress 2sls lrgdpch lpop larea dist2equ (open=T_rep_hat_98`id'), robust first		
	matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}	
	
	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)

local est=3		
quietly ivregress 2sls lrgdpch lpop larea tropicar (open=T_rep_hat_98`id'), robust first
	matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}	
	
	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)
		
		
local est=4
quietly ivregress 2sls lrgdpch lpop larea d_subsahafrica d_latamerica d_eseasia (open=T_rep_hat_98`id'), robust first
	matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}	
	
	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)
		

local est=5
quietly ivregress 2sls lrgdpch lpop larea latitude troppop (open=T_rep_hat_98`id'), robust
	matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}	
	
	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)
		

local est=6
quietly ivregress 2sls lrgdpch lpop larea latitude tropicar (open=T_rep_hat_98`id'), robust  
	matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}	
	
	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)
		

local est=7
quietly ivregress 2sls lrgdpch lpop larea troppop dist2equ (open=T_rep_hat_98`id'), robust  
	matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}	

	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)
		
		
local est=8
quietly ivregress 2sls lrgdpch lpop larea latitude troppop tropicar (open=T_rep_hat_98`id'), robust
	matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}
	
	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)
		

local est=9
quietly ivregress 2sls lrgdpch lpop larea latitude troppop d_subsahafrica d_latamerica d_eseasia (open=T_rep_hat_98`id'), robust  
	matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}	

	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)
		
		
local est=10
quietly ivregress 2sls lrgdpch lpop larea latitude troppop icrg_kk (open=T_rep_hat_98`id'), robust
matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}
	
	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)
		

local est=11
quietly ivregress 2sls lrgdpch lpop larea latitude troppop corrup (open=T_rep_hat_98`id'), robust
matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}
	
	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)
		

local est=12
quietly ivregress 2sls lrgdpch lpop larea latitude troppop xconst (open=T_rep_hat_98`id'), robust
	matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}	

	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)
		
		
local est=13
quietly ivregress 2sls lrgdpch lpop larea latitude troppop elf60 (open=T_rep_hat_98`id'), robust  
matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}	
	
	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)
		

local est=14
quietly ivregress 2sls lrgdpch lpop larea latitude troppop legorigin (open=T_rep_hat_98`id'), robust
matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)
		local c = e(df_m)+1
	matrix b`est'`id'=e(b)
	matrix se`est'`id'=J(1,`c',0)
		matrix colnames se`est'`id'= open `covariates' beta0		
			/* beta0 = constant */
	forvalues z=1(1)`c' {
	matrix se`est'`id'[1,`z']=sqrt(sigma[`z',`z'])
	}
	matrix rmse`est'`id'=e(rmse)
	matrix N`est'`id'=e(N)
quietly estat firststage
	matrix firststage=r(singleresults)
	matrix fs`est'`id'=firststage[1,4]
	matrix partr2`est'`id'=firststage[1,3]
	
quietly regress open T_rep_hat_98`id' `covariates' , robust
	matrix fb=e(b)
	matrix fvar=e(V)
	matrix b_that`est'`id'=fb[1,1]
	matrix se_that`est'`id'=sqrt(fvar[1,1])
	
	* calculate adjusted standard errors
		forvalues i=1(1)14 {
		quietly ivregress 2sls lrgdpch `covariates' (open=alt`i'_T_rep_hat`id'), robust
		matrix b`i'=e(b)
		}
		
		matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
				
		matrix adj_V=sigma+deltab*Q`x'*deltab'
		matrix adj_se`est'`id'=J(1,`c',0)
			matrix colnames adj_se`est'`id' = open `covariates' beta0
		forvalues z=1(1)`c' {
			matrix adj_se`est'`id'[1,`z']=sqrt(adj_V[`z',`z'])
		}

	* add Cragg-Donald Wald f-statistic
	quietly ivreg2 lrgdpch `covariates' (open=T_rep_hat_98`id'), ffirst
		matrix cdw_fs`est'`id'=e(widstat)	
		
}


***** EXTRACT DATA FROM MATRICES 
preserve
clear

forvalues y=1(1)14 {

svmat double b`y'_ins_r`x', names(matcol)
	rename b`y'_ins_r`x'* b_*
svmat double se`y'_ins_r`x', names(matcol)
	rename se`y'_ins_r`x'* se_*
svmat double adj_se`y'_ins_r`x', names(matcol)
	rename adj_se`y'_ins_r`x'* adj_se_*
svmat double rmse`y'_ins_r`x', names(rmse)
svmat double N`y'_ins_r`x', names (N)
svmat double fs`y'_ins_r`x', names(fstat)
svmat double cdw_fs`y'_ins_r`x', names(cdw_fstat)
svmat double partr2`y'_ins_r`x', names(part_r2)
svmat double b_that`y'_ins_r`x', names(b1_T_hat)
svmat double se_that`y'_ins_r`x', names(se1_T_hat)
svmat double rho1_ins_r`x', names(rho)
svmat double N_rho1_ins_r`x', names(N_rho)
svmat double rho2_ins_r`x', names(rho2)
svmat double N_rho2_ins_r`x', names(N_rho2)

gen reg_id=`y'
gen pred_method=1				/* label imputation is==1 */
gen random_id=`x'
if `x'==1 {
	if `y'>1 {
	append using "results_r_98_`s'dr_replica.dta"
	}
	save "results_r_98_`s'dr_replica.dta", replace
	clear
	}
else {
	append using "results_r_98_`s'dr_replica.dta"
	save "results_r_98_`s'dr_replica.dta", replace
	clear
	}
}


forvalues y=1(1)14 {

svmat double b`y'_tots_r`x', names(matcol)
	rename b`y'_tots_r`x'* b_*
svmat double se`y'_tots_r`x', names(matcol)
	rename se`y'_tots_r`x'* se_*
svmat double adj_se`y'_tots_r`x', names(matcol)
	rename adj_se`y'_tots_r`x'* adj_se_*
svmat double rmse`y'_tots_r`x', names(rmse)
svmat double N`y'_tots_r`x', names (N)
svmat double fs`y'_tots_r`x', names(fstat)
svmat double cdw_fs`y'_tots_r`x', names(cdw_fstat)
svmat double partr2`y'_tots_r`x', names(part_r2)
svmat double b_that`y'_tots_r`x', names(b1_T_hat)
svmat double se_that`y'_tots_r`x', names(se1_T_hat)
svmat double rho1_tots_r`x', names(rho)
svmat double N_rho1_tots_r`x', names(N_rho)
svmat double rho2_tots_r`x', names(rho2)
svmat double N_rho2_tots_r`x', names(N_rho2)

gen reg_id=`y'
gen pred_method=2				/* label imputation tots==2 */
gen random_id=`x'
append using "results_r_98_`s'dr_replica.dta"
save "results_r_98_`s'dr_replica.dta", replace
clear
}


matrix drop _all

restore
}

timer off 3

timer on 4

clear
use "results_r_98_`s'dr_replica.dta"
label define imputation 1 "in sample" 2 "out of sample"
label values pred_method imputation
rename b__cons b_beta0
rename *1 *

label variable reg_id "# identifying structural regression"
label variable random_id "# identifying draw"
label variable b1_T_hat "1.stage coefficient"
label variable se1_T_hat "1.stage standard error"
label variable fstat "1.stage F-statistic"
label variable cdw_fstat "1.stage Cragg-Donald Wald F-statistic; using ivreg2"
label variable part_r2 "1.stage Partial R-squared"
label variable rho "Correlation between open en pred.TSH used"
label variable N_rho "Number of observations used to calc rho"
label variable rho2 "Correlation between number of partners and pred.TSH used"
label variable N_rho2 "Number of observations used to calc rho2"

* calculate t-values and p-values for each coefficient
local var1="open"
local var2="lpop"
local var3="larea"
local var4="latitude" 
local var5="troppop" 
local var6="tropicar" 
local var7="dist2equ" 
local var8="d_subsahafrica"  
local var9="d_eseasia" 
local var10="d_latamerica"
local var11="icrg_kk"
local var12="xconst"
local var13="elf60"
local var14="legorigin"
local var15="beta0"
local var16="corrup"

egen num_cov=rownonmiss(b_open b_lpop b_larea b_latitude b_troppop b_legorigin b_corrup b_xconst b_elf60 b_icrg_kk b_d_subsahafrica b_d_latamerica b_d_eseasia b_tropicar b_dist2equ)

forvalues v = 1(1)16 {
	generate t_`var`v''=b_`var`v''/se_`var`v''
	generate p_`var`v''=2*ttail(N-num_cov,t_`var`v'')
		label variable p_`var`v'' "P-value generated using t-distribution"
	
	*generate p_`var`v''=2*(1-normal(abs(t_`var`v'')))
		* label variable p_`var`v'' "P-value generated using Normal distribution"
	
	generate t_`var`v''_adj=b_`var`v''/adj_se_`var`v''
		label variable t_`var`v''_adj "t-value using adjusted st.errors"
	generate p_`var`v''_adj=2*ttail(N-num_cov,t_`var`v''_adj)
		label variable p_`var`v'' "P-value generated using t-distribution and adj st.errors"
	
	*generate p_`var`v''_adj=2*(1-normal(abs(t_`var`v''_adj)))
		*label variable p_`var`v''_adj "p-value using adjsted st.errors"
		
}

drop num_cov

generate t1_T_hat=b1_T_hat/se1_T_hat
	label variable t1_T_hat "1.stage t-statistic for T_hat"
*generate p1_T_hat=2*(1-normal(abs(t1_T_hat)))
	*label variable p1_T_hat "1.stage p-value for T_hat"
	* unsure whether to use Normal of student's t-distribuation to calculate p-value


* calculate p-value for the correlation coefficient, rho
gen p_rho=2*ttail((N_rho-2), abs(rho)/(sqrt((1-rho^2)/(N_rho-2))))
	label variable p_rho "p-value of the correlation coefficient"

gen p_rho2=2*ttail((N_rho2-2), abs(rho2)/(sqrt((1-rho2^2)/(N_rho2-2))))
	label variable p_rho2 "p-value of the correlation coefficient"

	
sort random_id reg_id pred_method

order random_id reg_id pred_method b_open se_open adj_se_open t_open t_open_adj p_open p_open_adj N rmse fstat cdw_fstat part_r2 b1* se1* rho p_rho rho2 p_rho2 

save "results_r_98_`s'dr_replica.dta", replace

if "$version"=="full_sim" {
	erase t0.dta
}

timer off 1 
timer off 4

 

timer list 1
	// time taken for total .do-file
timer list 2
	// time taken for draw and generating random instruments
timer list 3
	// time taken to run IV-regressions using random instruments
timer list 4
	// time taken to clean & prep results for each regression

	
/* // generate tables of results
	if regexm("$output", "Table_3")==1 {
		global p = 1
		global q = 4
		global coeff = "only_tsh"
		do ../Programs/table_averages_random_instr.do
	}
	if regexm("$output", "Table_OD1")==1 {
		global p = 1
		global q = 4
		global coeff = "all vars"
		do ../Programs/table_averages_random_instr.do
	}
	if regexm("$output", "Table_OD2")==1 {
		global p =5
		global q =4
		global coeff = "all vars"			
		do ../Programs/table_averages_random_instr.do
	}
