

* generate Table 4 and OF.1

/* create table of results for income equation using the instrument that excludes predictions for zero and missing bilateral trade shares while controlling for number of trading partners 
(also corrects standard errors for generated instruments)
*/


***************  END EXPLANATORY NOTE; START EXECUTION   *****************
version 13.1

clear
matrix drop _all


// if running as individual do-file activate following commands:
/*
global output "Table_4 Table_OF1"

if regexm("$output", "Table_4")==1 {
	global instr ols
	global p = 1
	global q = 4	
}
	
if regexm("$output", "Table_OF1")==1 {
	global instr ols
	global p = 5
	global q = 14
}
*/

* generate alt-shares by executing .do-file
capture noisily use alt_T_hat_98_ols.dta, clear
if _rc!=0 {
	global instr "ols"
	do ../Programs/create_alt_T_hat_98.do
}


* assemble generated shares with country-level data set

use structural_98_final, clear

merge 1:1 iso3 using T_hat_98_ols, nogenerate

merge 1:1 iso3 using alt_T_hat_98_ols, nogenerate


/* program needed to replace st errors in e(V) with adj errors in adj_V --> from now on can use myrepost adj_V to replace these values */
capture program drop myrepost		
program myrepost, eclass
ereturn repost V = `1'
end
	

***** All 14 models 


global model1  lpop larea
global model2  lpop larea dist2equ
global model3  lpop larea tropicar
global model4  lpop larea d_subsahafrica d_latamerica d_eseasia
global model5  lpop larea latitude troppop
global model6  lpop larea latitude tropicar
global model7  lpop larea troppop dist2equ
global model8  lpop larea latitude troppop tropicar
global model9  lpop larea latitude troppop d_subsahafrica d_latamerica d_eseasia
global model10 lpop larea latitude troppop icrg_kk
global model11 lpop larea latitude troppop corrup
global model12 lpop larea latitude troppop xconst
global model13 lpop larea latitude troppop elf60
global model14 lpop larea latitude troppop legorigin


mstore Q_ols, make(Q) 	   /* activates matrix stored in T_hat_98_ref_min */

	local colnms: coln Q
	global x : word count `colnms'

forvalues m = $p(1)$q {
	global m = `m'
	
local controls model`m'	

	forvalues y = 1(1)2 {
		global y = `y'
		
	if $y ==1 {
		ivreg2 lrgdpch $`controls' (open = T_hat_ols_ins), robust first
	}
	if $y ==2 {
	ivreg2 lrgdpch $`controls' numpar_i  (open= T_hat_ols_ins), robust first
	}

estimates store spec$y

	matrix b=e(b)
	matrix sigma=e(V)
		local instr = e(exexog)			/* list of excl instr */
	
	matrix firststage = e(first)

/* firststage OLS */
if $y ==1 {	
quietly regress open `instr' $`controls'  , robust				
}
if $y ==2 {	
quietly regress open `instr' $`controls' numpar_i  , robust				
}
	matrix fb=e(b)
	matrix fvar=e(V)

* calculate adjusted standard errors
	* i. regress using alternative share
	forvalues i=1(1)$x {
		if $y ==1 {
		quietly ivreg2 lrgdpch $`controls' (open=alt_T_hat_ols_ins_`i'), robust
		}
		if $y ==2 {
		quietly ivreg2 lrgdpch $`controls' numpar_i  (open=alt_T_hat_ols_ins_`i'), robust
		}
	matrix b`i'=e(b)	
	}
	* ii. create matrix db/da where column`i' equals b`i'(transpose)-b/0.001
	if $x ==14 {
	matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
	}

	* iii. !!! calculate adjusted variance-covariance matrix for income regression using the formula in FR piece; 
		* sigma is the unadjusted variance-covariance matrix
		* deltab is the db/da matrix constructed above
		* Q is the variance-covariance matrix from the bilateral trade equation
	matrix adj_V=sigma+deltab*Q*deltab'	

	
estimates restore spec$y

// check names of matrices correspond with vars above and below!!!!
	matrix b_T_hat_ols_ins=fb[1,"T_hat_ols_ins"]
	estadd scalar b_T_hat_ols_ins = b_T_hat_ols_ins[1,1]
	
	matrix var_T_hat_ols_ins = fvar["T_hat_ols_ins","T_hat_ols_ins"]
	matrix stderr_T_hat_ols_ins= sqrt(var_T_hat_ols_ins[1,1])
	estadd scalar stderr_T_hat_ols_ins=stderr_T_hat_ols_ins[1,1]
	
	matrix t_T_hat_ols_ins = b_T_hat_ols_ins/stderr_T_hat_ols_ins[1,1]
	estadd scalar t_T_hat_ols_ins = t_T_hat_ols_ins[1,1]
	
	
estadd scalar fs=firststage[4,1]
estadd scalar part_r2=firststage[3,1]
	
myrepost adj_V

estimates store spec$y


cd ../Output

if $p ==1{
	if $m ==1 & $y == 1 {
	outreg2 spec$y using Table_4_replica.xls, ///
	dec(3) se paren nolabel ctitle("Model $m", "T_hat^pos") nocons nor2 ///
	keep (open numpar_i) ///
	sortvar(open numpar_i) ///
	addstat("T_hat^Pos", e(b_T_hat_ols_ins), "std err T_hat^Pos", e(stderr_T_hat_ols_ins), "t-val T_hat^Pos", e(t_T_hat_ols_ins), "Part R2", e(part_r2),  "KP rk Wald F-stat", e(fs)) /// 
	replace
	}
	else {
		if ($y ==1 & $m >1) | ($y ==2) {
		outreg2 spec$y using Table_4_replica.xls, ///
	dec(3) se paren nolabel ctitle("Model $m", "T_hat^pos") nocons nor2 ///
	keep (open numpar_i) ///
	sortvar(open numpar_i) ///
	addstat("T_hat^Pos", e(b_T_hat_ols_ins), "std err T_hat^Pos", e(stderr_T_hat_ols_ins), "t-val T_hat^Pos", e(t_T_hat_ols_ins), "Part R2", e(part_r2), "KP rk Wald F-stat", e(fs)) /// 
	append
		}
	}
}
if $p ==5 {	
	if $m ==1 & $y == 1 {
	outreg2 spec$y using Table_OF1_replica.xls, ///
	dec(3) se paren nolabel ctitle("Model $m", "T_hat^pos") nocons nor2 ///
	keep (open numpar_i) ///
	sortvar(open numpar_i) ///
	addstat("T_hat^Pos", e(b_T_hat_ols_ins), "std err T_hat^Pos", e(stderr_T_hat_ols_ins), "t-val T_hat^Pos", e(t_T_hat_ols_ins), "Part R2", e(part_r2),  "KP rk Wald F-stat", e(fs)) /// 
	replace
	}
	else {
		if ($y ==1 & $m >1) | ($y ==2) {
		outreg2 spec$y using Table_OF1_replica.xls, ///
	dec(3) se paren nolabel ctitle("Model $m", "T_hat^pos") nocons nor2 ///
	keep (open numpar_i) ///
	sortvar(open numpar_i) ///
	addstat("T_hat^Pos", e(b_T_hat_ols_ins), "std err T_hat^Pos", e(stderr_T_hat_ols_ins), "t-val T_hat^Pos", e(t_T_hat_ols_ins), "Part R2", e(part_r2), "KP rk Wald F-stat", e(fs)) /// 
	append
		}
	}
}

cd ../Data
	

}
}
