
****************************************************************************
* REPLICATION OF THE LITERATURE - RESULTS FROM THE INCOME EQUATION
****************************************************************************

/* create table of results for income equation using either instrument that excludes predictions for zero and missing bilateral trade shares (_ins) or the instrument that includes predictions for all possible bilateral trade shares (_tots)  
(also corrects standard errors for generated instruments)
*/

* Models to be tested are defined by global macro's at the start of the .do-file


***************  END EXPLANATORY NOTE; START EXECUTION   ******************
version 13.1

clear
matrix drop _all

// if running as individual do-file activate following commands:
/*
global output "Table_2 Table_OB1 Table_OC2 Table_OC3"

f regexm("$output", "Table_2")==1  {
	global instr ols
	global p = 1
	global q = 4
}

if regexm("$output", "Table_OB1")==1 {
	global instr ols
	global p = 5
	global q = 14
}	
	
if regexm("$output", "Table_OC2")==1 {
	global instr ppml
	global p = 1
	global q = 4
}
	
if regexm("$output", "Table_OC3")==1 {
	global instr ppml
	global p = 5
	global q = 14
}	
*/

* specify the list of instruments for which you want results
	global instrlist $instr


* generate alt-shares by executing .do-file
do ../Programs/create_alt_T_hat_98.do


* assemble generated shares (incl alt_shares for correcting standard errors) with country data set

use structural_98_final

merge 1:1 iso3 using T_hat_98_$instr, nogenerate

merge 1:1 iso3 using alt_T_hat_98_$instr, nogenerate


/* program needed to replace st errors in e(V) with adj errors in adj_V --> from now on can use myrepost adj_V to replace these values */
capture program drop myrepost		
program myrepost, eclass
ereturn repost V = `1'
end
	

***** basic four models 


global controls1  lpop larea
global controls2  lpop larea dist2equ
global controls3  lpop larea tropicar
global controls4  lpop larea d_subsahafrica d_latamerica d_eseasia
global controls5  lpop larea latitude troppop
global controls6  lpop larea latitude tropicar
global controls7  lpop larea troppop dist2equ
global controls8  lpop larea latitude troppop tropicar
global controls9  lpop larea latitude troppop d_subsahafrica d_latamerica d_eseasia
global controls10 lpop larea latitude troppop icrg_kk
global controls11 lpop larea latitude troppop corrup
global controls12 lpop larea latitude troppop xconst
global controls13 lpop larea latitude troppop elf60
global controls14 lpop larea latitude troppop legorigin

forvalues n = $p (1) $q {

local controls controls`n'

		if "$instr" == "ols" {
			if $p ==1 {
				local Z = "2"
			}
			else {
				local Z = "OB1"
			}
		}
		if "$instr" == "ppml" {
			if $p ==1 {
				local Z = "OC2"
			}
			else {
				local Z = "OC3"
			}
		}
		
* OLS results
regress lrgdpch open $`controls', robust


if $p == 1  {
cd ../Output
	if `n'==$p {
		outreg2 using Table_`Z'_replica.xls, ///
dec(3) se paren nolabel ctitle("Model `n'", "OLS") nocons ///
sortvar(open lpop larea dist2equ tropicar d_subsahafrica d_eseasia d_latamerica) replace
	}
	else {
		*if `n' > 1 & `n' <=4 {
		outreg2 using Table_`Z'_replica.xls,  ///
dec(3) se paren nolabel ctitle("Model `n'", "OLS") nocons ///
sortvar(open lpop larea dist2equ tropicar d_subsahafrica d_eseasia d_latamerica) append
		*}
	}
cd ../Data
}


foreach gravest in $instrlist  {

mstore Q_`gravest', make(Q_`gravest') 	  // activates matrix stored in T_hat_98 

	
foreach instr in T_hat_`gravest'_tots T_hat_`gravest'_ins {
	
pwcorr open `instr', sig
	matrix rho1=r(rho)
		local rho1=r(rho)
	
if regexm("`instr'", "ins")==1 {
	local method="T_hat^Pos"
	local pm="ins"
	}
if regexm("`instr'", "tots")==1 {
	local method="T_hat^All"
	local pm="tots"
	}
	
	local x = 14
	
local controls controls`n'	
	
ivregress 2sls lrgdpch $`controls' (open=`instr'), robust

	estimates store `gravest'_r`n'_`pm'
	matrix b=e(b)
	matrix sigma=e(V)
		local covariates = e(exogr)		/* covariates is a list of exog instr */
quietly estat firststage
	matrix firststage=r(singleresults)

quietly regress open `instr' `covariates' , robust				/* firststage */
	matrix fb=e(b)
	matrix fvar=e(V)

* calculate adjusted standard errors
	* i. regress using alternative share
	forvalues i=1(1)`x' {
	quietly ivregress 2sls lrgdpch `covariates' (open=alt_T_hat_`gravest'_`pm'_`i'), robust
	matrix b`i'=e(b)
	}
	* ii. create matrix db/da where column`i' equals b`i'(transpose)-b/0.001
	if `x'==14 {
	matrix deltab=((b1'-b')/0.001,(b2'-b')/0.001,(b3'-b')/0.001,(b4'-b')/0.001, (b5'-b')/0.001, (b6'-b')/0.001, (b7'-b')/0.001, (b8'-b')/0.001, (b9'-b')/0.001, (b10'-b')/0.001, (b11'-b')/0.001, (b12'-b')/0.001,(b13'-b')/0.001, (b14'-b')/0.001)
	}
	* iii. !!! calculate adjusted variance-covariance matrix for income regression using the formula in FR piece; 
		* sigma is the unadjusted variance-covariance matrix
		* deltab is the db/da matrix constructed above
		* Q`x' is the variance-covariance matrix from the bilateral trade equation
	matrix adj_V=sigma+deltab*Q_`gravest'*deltab'	

* add the Cragg-Donald Wald F-statistic to output
	quietly ivreg2 lrgdpch `covariates' (open=`instr'), ffirst
	scalar cdw_fstat=e(widstat)
	
estimates restore `gravest'_r`n'_`pm'
estadd scalar b_that=fb[1,1]
	*local T_hat = fb[1,1]
estadd scalar stdev_that=sqrt(fvar[1,1])
	*local se_That = sqrt(fvar[1,1])
estadd scalar fs=firststage[1,4]
	*local fs = firststage[1,4]
estadd scalar cdw_fs=cdw_fstat
estadd scalar part_r2=firststage[1,3]
estadd scalar rho1=rho1[1,1]

myrepost adj_V
estimates store `gravest'_r`n'_`pm'

cd ../Output

if `n' >=1 & `n' <=4 {
	outreg2 `gravest'_r`n'_`pm' using Table_`Z'_replica.xls, ///
	dec(3) se paren nolabel ctitle("Model `n'", "`method'") nocons nor2 ///
	sortvar(open lpop larea dist2equ tropicar d_subsahafrica d_eseasia d_latamerica) /// 
	addstat("T_hat", e(b_that), "st.dev ", e(stdev_that), "Partial R-squared", e(part_r2), "KP rk Wald F-stat", e(fs)) append
	}
else {
	if `n' == $p & "`pm'"=="tots" {
		outreg2 `gravest'_r`n'_`pm' using Table_`Z'_replica.xls, ///
		dec(3) se paren nolabel ctitle("Model `n'", "`method'") nocons nor2 ///
		sortvar(open lpop larea latitude troppop dist2equ tropicar d_subsahafrica d_eseasia d_latamerica icrg_kk corrup xconst elf60 legorigin) ///
		addstat("T_hat", e(b_that), "st.dev ", e(stdev_that), "Partial R-squared", e(part_r2), "KP rk Wald F-stat", e(fs)) replace
	}
	else {
		outreg2 `gravest'_r`n'_`pm' using Table_`Z'_replica.xls, ///
		dec(3) se paren nolabel ctitle("Model `n'", "`method'") nocons nor2 ///
		sortvar(open lpop larea latitude troppop dist2equ tropicar d_subsahafrica d_eseasia d_latamerica icrg_kk corrup xconst elf60 legorigin) ///
		addstat("T_hat", e(b_that), "st.dev ", e(stdev_that), "Partial R-squared", e(part_r2), "KP rk Wald F-stat", e(fs)) append
	}	
}


cd ../Data
	
}
}
}	

	
