
version 13.1

clear 
cd ../Data

use structural_98_final

merge m:1 iso3 using T_hat_98_ols , keepusing(T_hat_ols_ins)
drop _merge


reg  lrgdpch lpop larea, r
predict e_lrgdp, res

reg open lpop larea, r
predict e_open, res

reg numpar_i lpop larea, r
predict e_numpar, res


cd ../Output

// Figure 1
twoway (scatter  e_numpar e_open, mcolor(black)) (lfit e_numpar e_open, lcolor(black)), xtitle("Trade openness, residuals") ytitle("Number of trading partners, residuals")  ylabel(, nogrid angle(horizontal) tlwidth(medium)) yline(0, lpattern(dash) lcolor(gs10)) xline(0, lpattern(dash) lcolor(gs10)) legend(off) name(g1, replace) graphregion(color(white))

twoway (scatter e_numpar e_lrgdp , mcolor(black)) (lfit e_numpar e_lrgdp , lcolor(black)), ytitle("Number of trading partners, residuals") xtitle("Log of Real GDP per capita, residuals")  ylabel(, nogrid angle(horizontal) tlwidth(medium)) yline(0, lpattern(dash) lcolor(gs10)) xline(0, lpattern(dash) lcolor(gs10)) legend(off) name(g2, replace) graphregion(color(white))

graph combine g1 g2 , graphregion(color(white))

graph export Fig1.pdf, replace
graph export Fig1.png, replace

cd ../Data
