	
****************************************************************************
* CREATE ALT TSH NEEDED TO CORRECT ST ERRORS WHEN USING GENERATED INSTRUMENTS
****************************************************************************


/* 
suffix _tots denotes instruments generated summing across all possible partners
suffix _ins denotes instruments generated summing across actual partners (those featuring non-zero trade)
*/


* The alt shares are saved separately to the actual shares in alt_T_hat_98_~.dta
* The set of instruments are identified in inc_equ.do using a global macro called 'instrlist'
	
***************  END EXPLANATORY NOTE; START EXECUTION   ********************************

version 13.1

* clear all matrices from memory to speed up the program
matrix drop _all


* uses earlier regression results to predict alt TSH, used to correct standard error
clear
use "T_hat_98_$instr"
foreach gravest in $instrlist {
mstore a_`gravest', make(a_`gravest')


clear


use gravity_98_final

* to identify in/out of sample using original ols-gravity estimation
regress lbil_tsh ldistw lpop_r lpop_p larea_r larea_p sumll border ldistw_bord lpop_r_bord lpop_p_bord larea_r_bord larea_p_bord sumll_bord, vce(robust)

gen insample=1 if e(sample)==1
	replace insample=0 if missing(insample)
	label variable insample "Equal to 1 if country pair report nonzero trade"


********************************************************************************
* STEP 01: CONSTRUCT MATRICES OF BILATERAL OBSERVATIONS
********************************************************************************

* in preparation of constructing matrices containing observations to manually construct predicted bilateral trade shares (where we excluded FE estimators)
gen constant = 1
gen id = iso3_r+iso3_p
sort id
set matsize 11000


* A. original FR 
mkmat ldistw lpop_r lpop_p larea_r larea_p sumll border ldistw_bord lpop_r_bord lpop_p_bord larea_r_bord larea_p_bord sumll_bord constant in 1/11000, matrix(obs_1A) rownames(id)

mkmat ldistw lpop_r lpop_p larea_r larea_p sumll border ldistw_bord lpop_r_bord lpop_p_bord larea_r_bord larea_p_bord sumll_bord constant in 11001/l, matrix(obs_2A) rownames(id)

preserve
clear

********************************************************************************
* STEP 02: CONSTRUCT MATRIX ALL delta_a using saved a_~
****************************************************************************

	* z specifies the set of observations to use
	* x specifies the number of covariates (incl constant) in specification

	local z "A"
	local x = 14

					  
* create x vectors that function as delta-a; one for each coeff+0.001 
forvalues i = 1(1)`x' {
	matrix delta`i'=J(1,`x',0)	
		/* delta`i' is a matrix with all zero's except at `i' = 0.001 */
	matrix delta`i'[1,`i']=0.001
	matrix a`i'=a_`gravest'+delta`i'
	}

* generate x bilateral tradeshares for all obs using da 
forvalues i=1(1)`x' { 
	
	matrix biltsh_hat_a`i'_1=obs_1`z'*a`i''
	matrix biltsh_hat_a`i'_2=obs_2`z'*a`i''
	
	tempfile t`i'
	svmat2 biltsh_hat_a`i'_1, names(biltsh_hat_`gravest'_a`i') rnames(id) 
	save `t`i''
	clear
	svmat2 biltsh_hat_a`i'_2, names(biltsh_hat_`gravest'_a`i') rnames(id) 
	append using "`t`i''"
	save `t`i'', replace
	sort id
	order id
	save `t`i'', replace
	clear	
	matrix drop a`i' biltsh_hat_a`i'_1 biltsh_hat_a`i'_2 
	
}

* merge all tempfiles together
tempfile tall
use `t1'
forvalues i = 2(1)`x' {
	merge 1:1 id using "`t`i''", nogenerate
	}
	*?rename *1 *
sort id
save `tall'

restore
merge 1:1 id using `tall', nogenerate

forvalues i = 1(1)`x' {
* convert predictions from logs 
gen expbiltsh_`gravest'_a`i'=exp(biltsh_hat_`gravest'_a`i')
drop biltsh_hat_`gravest'_a`i'

* distinguish between predictions across only insample (_ins) and predictions across total sample  - all possible partners
gen alt_biltsh_`gravest'_ins_`i' = expbiltsh_`gravest'_a`i' if insample==1
rename  expbiltsh_`gravest'_a`i' alt_biltsh_`gravest'_tots_`i' 

* sum instruments across partners for each reporter
bysort iso3_r: egen alt_T_hat_`gravest'_ins_`i'= sum(alt_biltsh_`gravest'_ins_`i')
bysort iso3_r: egen alt_T_hat_`gravest'_tots_`i' = sum(alt_biltsh_`gravest'_tots_`i')
	}

*drop alt_biltsh_*

sort id

preserve
clear

}

restore 
	
duplicates drop iso3_reporter, force
keep iso3_r  alt_T_hat_*
rename iso3_r iso3
sort iso3

save alt_T_hat_98_$instr, replace
	* .dta-file contains x sets of predicted trade shares for each instrument 

clear
matrix drop _all
