

****************************************************************************
* Generate instruments using different estimators of gravity equation
****************************************************************************

/* changes to notation of predicted instruments: 
all instruments include suffix denoting estimation method (ols vs ppml): 

The following instruments are generated
* 1. OLS (original FR): _ols
* 2. PPML: _ppml


NB! All regressions across ALL obs means that missing observations of bil_tsh are converted to zero.  
  
*/


/* 
suffix _tots denotes instruments generated summing across all possible partners
suffix _ins denotes instruments generated summing across actual partners (those featuring non-zero trade)
*/


* the estimation results are saved in and excel file named gravity_estimates
	* located in the Output folder
	
***************  END EXPLANATORY NOTE; START EXECUTION   ******************

version 13.1

// if running as individual do-file activate following commands:
/*
global output "Table_1 Table_OC1"

if regexm("$output", "Table_1")==1 {
	global instr ols
}
if regexm("$output", "Table_OC1")==1 {
	global instr ppml
}
*/

use gravity_98_final, clear

* in preparation of constructing matrices containing observations to manually construct predicted bilateral trade shares (where we excluded FE estimators)
gen constant = 1
gen id = iso3_r+iso3_p
set matsize 11000


****************************************************************************
* ESTIMATION OF BASIC SPECIFICATION  *********************
****************************************************************************
	
	
/* create three matrices of all observations */

mkmat ldistw sumll border ldistw_bord lpop_r_bord lpop_p_bord larea_r_bord larea_p_bord sumll_bord constant in 1/11000, matrix(obs_1) rownames(id)

mkmat ldistw sumll border ldistw_bord lpop_r_bord lpop_p_bord larea_r_bord larea_p_bord sumll_bord constant in 11001/l, matrix(obs_2) rownames(id)


****************************************************************************
* Estimation of the Bilateral Trade Equation using OLS: 
* --> biltsh_ols_*
****************************************************************************

if "$instr"=="ols"{
regress lbil_tsh ldistw lpop_r lpop_p larea_r larea_p sumll border ldistw_bord lpop_r_bord lpop_p_bord larea_r_bord larea_p_bord sumll_bord, vce(robust)

cd ../Output
outreg2 using Table_1_replica.xls, dec(3) se bracket nolabel ctitle(OLS)  sortvar(constant ldistw lpop_r lpop_p larea_r larea_p sumll border ldistw_bord lpop_r_bord lpop_p_bord larea_r_bord larea_p_bord sumll_bord) replace
cd ../Data

	matrix a_ols=e(b)
	matrix Q_ols=e(V)
	
gen insample=1 if e(sample)==1
	replace insample=0 if missing(insample)
	label variable insample "Equal to 1 if country pair report nonzero trade"
	* equal to 1 for bilateral observations that report nonzero trade 

predict biltsh_ols_ins if insample==1, xb 
	
predict biltsh_ols_tots , xb
	* predicts bilateral trade for all observations (ts=out of sample) 
}
	
****************************************************************************
* Estimates of the bilateral trade equation using PPML
* --> biltsh_ppml_*
****************************************************************************

if "$instr"=="ppml" {
ppml bil_tsh_2 ldistw lpop_r lpop_p larea_r larea_p sumll border ldistw_bord lpop_r_bord lpop_p_bord larea_r_bord larea_p_bord sumll_bord

cd ../Output
outreg2 using Table_OC1_replica.xls, dec(3) se bracket nolabel ctitle(PPML-all) keep(ldistw lpop_r lpop_p larea_r larea_p sumll border ldistw_bord lpop_r_bord lpop_p_bord larea_r_bord larea_p_bord sumll_bord) sortvar(cons ldistw lpop_r lpop_p larea_r larea_p sumll border ldistw_bord lpop_r_bord lpop_p_bord larea_r_bord larea_p_bord sumll_bord) replace
cd ../Data

	matrix a_ppml=e(b)
	matrix Q_ppml=e(V)
	
predict biltsh_ppml_ins if ind_tij==1, xb

predict biltsh_ppml_tots, xb
	
}		
********************************************************************************
* Construct predicted trade shares for each reporter using pred bil shares
********************************************************************************


* take exponent of bil share and sum to generate total trade share for each reporter

sort iso3_r

foreach est in $instr {
	*local var1 = substr("`lpbilsh'",2,.)
	gen ebiltsh_`est'_ins = exp(biltsh_`est'_ins)
	gen ebiltsh_`est'_tots = exp(biltsh_`est'_tots)
	
	*local var2 = substr("`lpbilsh'",11,.)
	bysort iso3_r: egen T_hat_`est'_ins = sum(ebiltsh_`est'_ins)
	bysort iso3_r: egen T_hat_`est'_tots = sum(ebiltsh_`est'_tots)
}

duplicates drop iso3_r, force

keep iso3_r T_hat_*

sort iso3_r
rename iso3_reporter iso3

foreach est in $instr {
mstore a_`est', from(a_`est')
mstore Q_`est', from(Q_`est')
}


foreach est in $instr {
	save T_hat_98_`est', replace
	}
