


* 2020_REPLICATE OUTPUT 

/* 
// List of Tables (and footnotes) listed in the paper....: 
	Table_1 --> Estimates of the bilateral trade equation using OLS 
	Table_2 -->  Estimates of the income equation using actual data and the "OLS instrument" (models 1 through 4) 
	Table_3 --> Estimates of the income equation using randomized instruments (1000 replications), condensed for models 1 through 4
	Figure_1 --> First stage and reduced form: Trade openness and income per capita using T^pos
	Table_4 --> Estimates of the income equation using T^pos as an instrument while controlling for the number of trading partners (models 5 through 14)

	... and those listed in the appendix:
	Table_OB1 --> Estimates of the income equation using actual data and the "OLS instrument" (models 5 through 14) 
	Table_OC1 --> Estimates of the bilateral trade equation using PPML
	Table_OC2 --> Estimates of the income equation using actual data and the "PPML instrument" (models 1 through 4) 
	Table_OC3 --> Estimates of the income equation using actual data and the "PPML instrument" (models 5 through 14) 
	Table_OD1 --> Estimates of the income equation using randomized instruments (1000 replications), all variables for models 1 through 4
	Table_OD2 --> Estimates of the income equation using randomized instruments (1000 replications), condensed for models 5 through 14
	Table_OE1 --> # of partners, trading costs and income per capita
	Table_OE2 --> probability of positive bilateral trade vs zero or missing values
	Figure_OE1 --> distribution of fitted bilateral shares
	Table_OF1 --> Estimates of the income equation using T^pos as an instrument while controlling for the number of trading partners (models 5 through 14)

*/

// ensure that the following Stata packages are installed:
	// estadd
	// ivreg2 
	// mstore  
	// outreg2
	// ppml (package name:st0225.pkg)
	// svmat2

// List the desired output in between the double quotes (INCLUDE the underscore):
global output "Table_1 Table_2 Table_3 Figure_1 Table_4"


// For Tables 3, OD1 and OD2, 
// specify how much of the randomization exercise (taking draws, generating the random instruments, running the IV regressions for the models of interest) you want to run by writing either:
	// "full_sim" --> entire randomization exercise is run accross number of iterations specified using global s below
	// "use_org_random_instr" means that iv-regression will use the random instruments produced by authors (saved in T_hat_r_98_1000dr_org) from the original set of draws (saved in vars_r_98_1000dr_org)
	// "use_org_results" generates output tables with results produced by authors and saved in results_r_98_1000dr_org (default setting) NB! must set global s to the default of 1000 
	
	global version "use_org_results"
	
	
// specify the number of desired iterations (default is 1000):
global s = 1000
		
	
// Ensure that the working directory is the folder called "Data"


if regexm("$output", "Table_1")==1 {
	global instr "ols"
	do ../Programs/bilateral_equ.do
	}

	
if regexm("$output", "Table_2")==1  {
	global instr "ols"
	global p = 1
	global q = 4
	do ../Programs/inc_equ.do
	}


if regexm("$output", "Table_3")==1 | regexm("$output", "Table_OD1")==1 | regexm("$output", "Table_OD2")==1 {

	if "$version" =="full_sim" | "$version"=="use_org_random_instr" {
		do  ../Programs/simulation.do
	}

	if regexm("$output", "Table_3")==1 {
		global p = 1
		global q = 4
		global coeff = "only_tsh"
		do ../Programs/table_averages_random_instr.do
	}
	if regexm("$output", "Table_OD1")==1 {
		global p = 1
		global q = 4
		global coeff = "all vars"
		do ../Programs/table_averages_random_instr.do
	}
	if regexm("$output", "Table_OD2")==1 {
		global p =5
		global q =4
		global coeff = "all vars"			
		do ../Programs/table_averages_random_instr.do
	}

}
		
	
if regexm("$output", "Figure_1")==1 {
	do  ../Programs/figure_1.do
	}
		
	
if regexm("$output", "Table_4")==1 {
	global instr ols
	global p = 1
	global q = 4
	do  ../Programs/inc_equ_control_num.do
	}
		
	
if regexm("$output", "Table_OB1")==1 {
	global instr ols
	global p = 5
	global q = 14
	do  ../Programs/inc_equ.do
	}	

	
if regexm("$output", "Table_OC1")==1 {
	global instr ppml
	do  ../Programs/bilateral_equ.do
	}

	
if regexm("$output", "Table_OC2")==1 {
	global instr ppml
	global p = 1
	global q = 4
	do  ../Programs/inc_equ.do
	}

	
if regexm("$output", "Table_OC3")==1 {
	global instr ppml
	global p = 5
	global q = 14
	do  ../Programs/inc_equ.do
	}	

	
if regexm("$output", "Table_OE1")==1 {
	do  ../Programs/z_appendix_numpar_trade-costs.do
}

if regexm("$output", "Table_OE2")==1 {
	do  ../Programs/z_appendix_zero-vs-missing.do 
}

if regexm("$output", "Figure_OE1")==1 {
	do  ../Programs/z_appendix_figure_OE1.do
}


if regexm("$output", "Table_OF1")==1 {
	global p = 5
	global q = 14
	do  ../Programs/inc_equ_control_num.do
}
