*! Version 2 (23/02/2009)
*! De Luca Giuseppe

*-------------------------------------------------------------------------------------------------
* snpbpsel_ll
*-------------------------------------------------------------------------------------------------

program define snpbpsel_ll_m

	version 10.0
	args lnf xb2 xb1 
	*${SNP_PAR}
	qui {
	* Get estimation sample
		loc touse $ML_samp

	* Degree of polinomial expansion
		tempname Rl
		matrix `Rl'=($R1, $R2)

	* Get lhs variables
		loc yl $ML_y2 $ML_y1 
		*noi di "`yl'"

	* Get indexes of the selection and main equations		
		tempname con1 con2
		scalar `con1'=${Con1}
		scalar `con2'=${Con2}

		tempvar u1 u2 
		gen double `u1'  =-(`con1'+`xb1')
		gen double `u2'  =-(`con2'+`xb2')		
		local U1l `u1'
		local U2l `u2'

	* Get snp parameters [g_{i,j}] 
		macro shift 3
		tempname gaml  
		matrix `gaml'=J(${R1}+1,${R2}+1, 0)
		matrix `gaml'[1,1]=1
		forvalues i=1(1)${R1} {
			forvalues j=1(1)${R2} {
				tempname g_`i'_`j' 
				sum `1'
				scalar `g_`i'_`j''=r(max)
				matrix `gaml'[`i'+1,`j'+1]=`g_`i'_`j''
				macro shift
			}
		}

	* Get indicator variables for lhs variables
	      loc YINDl $YIND

	* Likelihood evaluator
	      noi mata: snpbpselmata("`touse'","`lnf'","`yl'","`U1l'","`U2l'","`gaml'","`Rl'","`YINDl'")  
		replace `lnf' = . if $ML_samp!=1
}
end


*-------------------------------------------------------------------------------------------------
* snpbpselmata
*-------------------------------------------------------------------------------------------------
mata:
mata clear
void snpbpselmata(touse,lnfl,yl,U1l,U2l,gaml,Rl,YINDl)
	{
	// Declarations 
		real colvector lnf
		real matrix Y, gam, YIND, A_fix, A1, A2 
		real scalar N1, Rmax, upto, R12, R22, Psi
		real colvector mbar1, mbar2, U1, U2, R, A1s, A2s, A12s 
		real matrix gams 

	// Loading data from stata into mata
		st_view(lnf, ., (st_varindex(tokens(lnfl))))
		Y = st_data(., (st_varindex(tokens(yl))))
		U1 = st_data(., (st_varindex(tokens(U1l))))
		U2 = st_data(., (st_varindex(tokens(U2l))))
		YIND = st_data(., (st_varindex(tokens(YINDl))))
		gam = st_matrix(gaml)
		R = st_matrix(Rl)

	// Number of observations 
		N1  =rows(Y[.,1])

	// Degree of the polinomial expansion
		Rmax = 2*max(R)
		upto = Rmax+1
		R12 = 2*R[1]
		R22 = 2*R[2]

	// Vectors of central moments
		mbar1=J(R12+1,1,0)
		mbar1[1,1]=1
		for (i=3; i<=R12+1; i++) {
			mbar1[i,1]=(i-2)*mbar1[i-2,1]
		}		
		mbar2=J(R22+1,1,0)
		mbar2[1,1]=1
		for (i=3; i<=R22+1; i++) {
			mbar2[i,1]=(i-2)*mbar2[i-2,1]
		}		

	// Expanded gam matrix (gams)
		gams=J(R12+1,R22+1,0)
		for (i=0; i<=R12; i++) {
			ai=rowmax((0,i-R[1]))
			bi=rowmin((i,R[1]))
			ci=(ai,bi)
			for (j=0; j<=R22; j++) {
				aj=rowmax((0,j-R[2]))
				bj=rowmin((j,R[2]))
				for (is=ai; is<=bi; is++) {
					iis=i-is
					for (js=aj; js<=bj; js++) {
						jjs=j-js
						gams[i+1,j+1]=gams[i+1,j+1]+gam[is+1,js+1]*gam[iis+1,jjs+1]	
					}			
				}			
			}
		}

	// Compute normalization factor 
		Psi=(mbar1)' * gams * mbar2

	// Compute A1 and A2
		A_fix=(J(N1,1,0),J(N1,1,1))
		A1=A_fix
		for (i=3; i<=R12+1; i++) {
			A1=(A1, (i-2)*A1[.,(i-2)]+U1:^(i-2))
		}
		A2=A_fix
		for (i=3; i<=R22+1; i++) {
			A2=(A2, (i-2)*A2[.,(i-2)]+U2:^(i-2))
		}

	// Compute A1s, A2s and A12s
		A1s=A1*gams*mbar2
		A2s=A2*(gams)'*mbar1
		A12s=quadrowsum(A1 :* (A2 * (gams)'))
		//***Elimina: A1s "Questo era A3" 
		//***Elimina: A2s "Questo era A2" 
		//***Elimina: A12s "Questo era A1" 

	// Compute cdf
		Fu1 	= normal(U1) - (A1s :* normalden(U1) :/ Psi)
		Fu2 	= normal(U2) - (A2s :* normalden(U2) :/ Psi)
		Fu1u2	= normal(U1) :* normal(U2) 					/*
		*/	+ (A12s :* normalden(U1) :* normalden(U2)		   	/*
	    	*/    - A2s  :* normal(U1)    :* normalden(U2)	   		/*
	    	*/    - A1s  :* normalden(U1) :* normal(U2)    ):/ Psi  

	// Compute Log-likelihood
		lnf2=J(N1,3,0)
		lnf2[.,1]=ln(Fu1)
		lnf2[.,2]=ln(Fu2 :- Fu1u2)
		lnf2[.,3]=ln((1 :+ (Fu1u2-Fu1-Fu2)))
		lnf[.,.] = quadrowsum(YIND :* lnf2)
	}
end
*-------------------------------------------------------------------------------------------------

