
program define plinear, eclass
	version 8.2
	if replay() {
		if "`e(cmd)'" != "plinear" {
			di as error "results for plinear not found"
			exit 301
		}
		exit `rc'
	}
	else	Estimate `0'
end

program define Estimate, eclass 

	* Dependent variable
		gettoken dep 0 : 0 , parse(" =,[")
		gettoken equals rest : 0 , parse(" =")
		if "`equals'" == "=" local 0 `"`rest'"'
		local depn : subinstr local dep "." "_"

	* Other equations & options
		syntax varlist(min=1) [if] [in] [pw fw iw], nonlinear(varname)			///
			[noCONstant OFFset(varname numeric) Robust Cluster(varname)   		///
			order(integer 3) TRIMming(integer 0) Level(integer $S_level)		///
			reps(integer 100) Seed(integer 123456789) save(string)]

	* Identify noconstant and offset main equation
		local nc `constant'
		if "`offset'"  != "" local off "offset(`offset')" 

	* Estimation sample 
		marksample touse
		markout `touse' `dep' `cluster', strok

	* Other options
		if "`weight'" 	!= "" local wgt [`weight'`exp']
		if "`cluster'" 	!= "" local clopt "cluster(`cluster')" 
		if "`level'" 	!= "" local level "level(`level')"
		if "`save'"		!= "" local saving "saving(`save')"
		if "`weight'" == "pweight" | "`cluster'" != "" local robust "robust"
		local title "Patially linear model"

	* Trimming
		if `trimming'!=0 {
			local t_inf=`trimming'
			local t_sup=100-`trimming'
			_pctile `nonlinear' 		if `touse', p(`t_inf' `t_sup')
			local inf1=r(r1)
			local sup1=r(r2)
			local touse1 "`touse' & (`nonlinear'>= `inf1' & `nonlinear' <= `sup1')"
		}
		else local touse1 "`touse'"

	* Bootstrapped second step 
		noi bootstrap _b,									///
			reps(`reps') seed(`seed') `level' nol				///
			saving("`save'" , every(5) replace) title(`title'):		///
			plinear_0 `dep' `varlist' if `touse', `nc' `off'		///
			nonlinear(`nonlinear') wtype(`weight') wvar(`exp')	order(`order') 				///
			trimming(`trimming') `level'  

	* Store estimated coefficients
		tempname b sd
		matrix `b'=e(b)
		matrix `sd'=e(V)
		matrix coleq `b'= `dep'
		matrix roweq `sd'= `dep'
		matrix coleq `sd'= `dep'

	* Set estimation sample
		tempvar sample
		qui gen `sample'=1 	if `touse1'
		markout `touse' `sample', strok
		qui count if `touse1'
		local n=r(N)
		
	
	* Return
		eret post `b' `sd', esample(`touse') dep("`dep'")
		eret local depvar "`dep'"
		eret local rhs "`varlist'"
		ereturn scalar N=`n'
		ereturn local cmd="plinear"
end





