
program define pl2se, eclass
	version 8.2
	if replay() {
		if "`e(cmd)'" != "pl2se" {
			di as error "results for pl2se not found"
			exit 301
		}
		exit `rc'
	}
	else	Estimate `0'
end

program define Estimate, eclass 
qui{
	* Dependent variable
		gettoken dep 0 : 0 , parse(" =,[")
		gettoken equals rest : 0 , parse(" =")
		if "`equals'" == "=" local 0 `"`rest'"'
		local depn : subinstr local dep "." "_"

	* Other equations & options
		syntax varlist(min=1) [if] [in] [pw fw iw] , 						///
			SEL1(string) SEL2(string) 								///
			[noCONstant OFFset(varname numeric) Robust Cluster(varname)   		///
			ENDOGeneity(string) First Second TRIMming(integer 0)				///
			s1order1(integer 3) s1order2(integer 3) From(string) startprobit		///
			s2list1(string) s3list1(string) s3list2(string)					///
			sample2(varname) sample3(varname)							///
			reps(integer 100) Seed(integer 123456789) save(string) 	 		///
			MLOpts(string) Level(integer $S_level) noLOG * ]

	* Identify noconstant and offset main equation
		local nc `constant'
		if "`offset'"  != "" local off "offset(`offset')" 

	* Identify Selection equations
		forvalues i=1(1)2 {
			Select seldep`i' selind`i' selnc`i' seloff`i' : `"`sel`i''"'
			local selname`i' : subinstr local seldep`i' "." "_"
			if "`seloff`i''" != "" local soff`i' "offset(`seloff`i'')" 
		}
		if "`endogeneity'"!="" {
			Select enddep endind endnc endoff : `"`endogeneity'"'
			local endog_eqs "endog(`enddep'=`endind',`endnc' `endoff')"
		}

	* Estimation sample 
		marksample touse1, novarlist
		markout `touse1' `seldep1' `selind1' `seloff1' `cluster', strok

		marksample touse2, novarlist
		markout `touse2' `seldep1' `selind1' `seloff1' `cluster', strok
		markout `touse2' `seldep2' `selind2' `seloff2' `cluster', strok

		marksample touse
		markout `touse' `dep' `varlist' `offset' 
		qui replace `touse2' = 0 	if `seldep2' & !`touse'
		qui replace `touse1' = 0 	if `seldep1' & !`touse2'
		if "`endogeneity'"!="" {
			marksample touse_e
			markout `touse_e' `enddep' `endind' `endoff' 
			qui replace `touse2' = 0 	if `seldep2' & !`touse_e'
			qui replace `touse1' = 0 	if `seldep1' & !`touse2'
		}

	* Other options
		if "`weight'" 	!= "" local wgt [`weight'`exp']
		if "`cluster'" 	!= "" local clopt "cluster(`cluster')" 
		if "`level'" 	!= "" local level "level(`level')"
		if "`weight'" == "pweight" | "`cluster'" != "" local robust "robust"
		local showf = cond("`first'" == "", "quietly", "noisily")
		if "`endogeneity'"!="" local shows = cond("`second'" == "", "quietly", "noisily")
		mlopts mlopts, `options'

	*  Check dependent variables and estimation sample
		count if `touse' 
		if r(N) == 0 { 
			di as error "no valid observations in main equation"
		   	error 2000
		}
		local N = r(N)

		count if `touse1' 
		if r(N) == 0 { 
			di as error "no valid observations in first selection equation"
		   	error 2000
		}
		local N1 = r(N)

		count if `touse2' 
		if r(N) == 0 { 
			di as error "no valid observations in second selection equation"
		   	error 2000
		}
		local N2 = r(N)

		capture assert (`seldep1' == 1 | `seldep1' == 0) if `touse1'
		if _rc==9 {
			di as error "depvar `seldep1' should be binary (0 or 1)"
			exit 450
		}
		count if `seldep1' == 0 & `touse1'
		local d0 = r(N)
		if `d0' == 0 {
			di as error "`seldep1' is never zero"
			exit 2000
		}
		else if `d0' == `N1' {
			di as error "`var' is always zero"
			exit 2000 
		}

		capture assert (`seldep2' == 1 | `seldep2' == 0) if `touse2'
		if _rc==9 {
			di as error "depvar `seldep2' should be binary (0 or 1)"
			exit 450
		}	
		count if `seldep2' == 0 & `touse2'
		local d0 = r(N)
		if `d0' == 0 {
			di as error "`seldep2' is never zero"
			exit 2000
		}
		else if `d0' == `N2' {
			di as error "`seldep2' is always zero"
			exit 2000 
		}

	* First Estimation Step
		tempname est1 b_SNP_start
		tempvar z1 z2 
		`showf' snpbpsel_m `seldep2' `selind2' 			///
			if `touse1',`selnc2' `seloff2'			///
			sel(`seldep1'=`selind1', `selnc1' `seloff1')	///
			order1(`s1order1') order2(`s1order2') 		///
			`startprobit' from(`from')				///
			xb1(`z1') xb2(`z2')					///
			`robust' `clopt' `mlopts' `level' `log' 
		estimates store `est1'
		matrix `b_SNP_start'=e(b)
		local from2 "from(`b_SNP_start')"


	* Bootstrap
		tempname est2
		noi bootstrap ["`dep'"]_b, 									///
			reps(`reps') seed(`seed') `level' nol 						///
			saving("`save'" , every(5) replace):						///
			pl2se_0 `dep' `varlist' if `touse1', `nc' `off' 				///
			sel1(`seldep1'=`selind1', `selnc1' `seloff1')					///
			sel2(`seldep2'=`selind2', `selnc2' `seloff2') 					///
			`endog_eqs' 										///
			s1order1(`s1order1') s1order2(`s1order2') `from2' `startprobit'		///
			s2list1(`s2list1') s3list1(`s3list1') s3list2(`s3list2')			///
			trimming(`trimming') sample2(`sample2') sample3(`sample3')			///
			`robust' `clopt' `iter' `mlopts' `level' `log' 
		estimates store `est2'

	* Store estimated parameters		
		tempname b1 sd1 
		matrix `b1'=e(b)
		matrix `sd1'=e(V)

	* Restore First Estimation Step
		estimates restore `est1'
		if e(converged)==1 {

			* Set estimation sample
				local use1 "`touse'==1 & `seldep2'==1"

			* Get correlation coefficient
				tempname rho_12 sig_a
				sca def `rho_12'=e(rho)
				sca def `sig_a'=sqrt(1-`rho_12'^2)

			* Bias correction terms
				tempvar phi_1 phi_2 Phi_12
				gen double `phi_1'=normden(`z1')
				gen double `phi_2'=normden(`z2')
				gen double `Phi_12'=binorm(`z1',`z2',`rho_12')
				gen double lambda1=`phi_1'*norm((`z2'-`rho_12'*`z1')/`sig_a')/`Phi_12'
				gen double lambda2=`phi_2'*norm((`z1'-`rho_12'*`z2')/`sig_a')/`Phi_12'

			* Centering bias correction terms
				tempname alp1 alp2 l1 l2 
				sca def `alp1'=${Con1}
				sca def `alp2'=${Con2}
				sca def `l1'=normd(`alp1')*norm((`alp2'-`rho_12'*`alp1')/`sig_a')/binorm(`alp1',`alp2',`rho_12')
				sca def `l2'=normd(`alp2')*norm((`alp1'-`rho_12'*`alp2')/`sig_a')/binorm(`alp1',`alp2',`rho_12')
				replace lambda1=lambda1-`l1'
				replace lambda2=lambda2-`l2'

			* Model without endogeneity
			if "`endogeneity'"=="" {

				* Trimming
					if `trimming'!=0 {
						local t_inf=`trimming'
						local t_sup=100-`trimming'

						_pctile `z1' 		if `use1', p(`t_inf' `t_sup')
						local inf1=r(r1)
						local sup1=r(r2)

						_pctile `z2' 		if `use1', p(`t_inf' `t_sup')
						local inf2=r(r1)
						local sup2=r(r2)

						_pctile `dep'  		if `use1', p(`t_inf' `t_sup')
						local inf3=r(r1)
						local sup3=r(r2)

						count 			if `use1'						///
										& ((`z1' <`inf1'|`z1'  >`sup1')		///
										| (`z2'  <`inf2'|`z2'  >`sup2')		///
										| (`dep' <`inf3'|`dep' >`sup3'))
						noi di _n "{hline 78}"	 							///
							 _n in gr "Trimming" 							///
							 _n in gr "z1: inf = " 	in ye %9.2f `inf1'			///
							    in gr " - sup = " 	in ye %9.2f `sup1'			///
							 _n in gr "z2: inf = " 	in ye %9.2f `inf2'			///
							    in gr " - sup = " 	in ye %9.2f `sup2'			///
							 _n in gr "inc: inf = " in ye %9.2f `inf3'			///
							    in gr " - sup = " 	in ye %9.2f `sup3'			///
							 _n in gr " Observations = " in ye r(N)				///
							 _n "{hline 78}"

						#delimit;
						local use2 "`use1' 
								& (`z1'    >= `inf1' & `z1'     <= `sup1') 
								& (`z2'    >= `inf2' & `z2'     <= `sup2')	
								& (`dep'   >= `inf3' & `dep'	  <= `sup3')";
						#delimit cr
					}
					if "`sample2'"!="" {
						local use2 "`sample2'==1"
					}
					if `trimming'==0 & "`sample2'"=="" {
						local use2 "`use1'"
					}

				* Determine powers and interaction - second step
					local lambda_list "lambda1 lambda2"
					local lambda_list_norm ""
					if "`s2list1'"!="" {
						local s2nvar: word count `s2list1'
						forvalues j=1(1)`s2nvar' {
							local s2var_`j': word `j' of `s2list1'
							local t1=real(substr("`s2var_`j''",1,1))
							local t2=real(substr("`s2var_`j''",3,1))
							if `t1'>0 & `t2'==0 {
								gen double l1_`t1'=lambda1^`t1'
								local lambda_list "`lambda_list' l1_`t1'"
								local lambda_list_norm "`lambda_list_norm' l1_`t1'"
							}
							if `t1'==0 & `t2'>0 {
								gen double l2_`t2'=lambda2^`t2'
								local lambda_list "`lambda_list' l2_`t2'"
								local lambda_list_norm "`lambda_list_norm' l2_`t2'"
							}
							if `t1'>0 & `t2'>0 {
								gen double l1_`t1'_l2_`t2'=lambda1^`t1'*lambda2^`t2'
								local lambda_list "`lambda_list' l1_`t1'_l2_`t2'"
								local lambda_list_norm "`lambda_list_norm' l1_`t1'_l2_`t2'"
							}		
						}	
					}
				* Restore second step estimates
					qui estimates restore `est2'

				* Test for selection
					qui test `lambda_list' 
					noi di in gr "Joint test selection - chi2(" in ye r(df) in gr ")=" 	///
				 		in ye %9.2f r(chi2) 								///
						 _col(50) in gr "- Prob > chi2 =" in ye %9.4f r(p)			///
					 _n in gr "{hline 78}"

				* Test for Gaussianity
					qui test `lambda_list_norm' 
					noi di in gr "Joint test Gaussianity - chi2(" in ye r(df) in gr ")=" 	///
				 		in ye %9.2f r(chi2) 								///
						 _col(50) in gr "- Prob > chi2 =" in ye %9.4f r(p)			///
					 _n in gr "{hline 78}"

				* Second step
					cap drop `lambda_list' 
			}

			* Model with endogeneity - Three step estimator
			else {
				* Trimming on second step
					if `trimming'!=0 {
						local t_inf=`trimming'
						local t_sup=100-`trimming'

						_pctile `z1' 		if `use1', p(`t_inf' `t_sup')
						local inf1=r(r1)
						local sup1=r(r2)

						_pctile `z2' 		if `use1', p(`t_inf' `t_sup')
						local inf2=r(r1)
						local sup2=r(r2)

						_pctile `enddep' 		if `use1', p(`t_inf' `t_sup')
						local inf3=r(r1)
						local sup3=r(r2)

						count 			if `use1' 						///
										& ((`z1' <`inf1'|`z1' >`sup1')		///
										| (`z2' <`inf2'|`z2' >`sup2')			///
										| (`enddep' <`inf3'|`enddep' >`sup3'))
						noi di _n "{hline 78}"	 							///
							 _n in gr "Trimming" 							///
							 _n in gr "z1: inf = " 	in ye %9.2f `inf1'			///
							    in gr " - sup = " 	in ye %9.2f `sup1'			///
							 _n in gr "z2: inf = " 	in ye %9.2f `inf2'			///
							    in gr " - sup = " 	in ye %9.2f `sup2'			///
							 _n in gr "inc: inf = " in ye %9.2f `inf3'			///
							    in gr " - sup = " 	in ye %9.2f `sup3'			///
							 _n in gr "Observations = " in ye r(N)				///
							 _n in gr "{hline 78}"

						#delimit;
						local use2 "`use1' 
								& (`z1'     >= `inf1'    & `z1'     <= `sup1') 
								& (`z2'     >= `inf2'    & `z2'     <= `sup2')	
								& (`enddep' >= `inf3'    & `enddep' <= `sup3')";
						#delimit cr
					}
					if "`sample2'"!="" {
						local use2 "`sample2'==1"
					}
					if `trimming'==0 & "`sample2'"=="" {
						local use2 "`use1'"
					}

				* Second Step - Determine powers and interaction of the approximation 
					local lambda_list "lambda1 lambda2"
					if "`s2list1'"!="" {
						local s2nvar: word count `s2list1'
						forvalues j=1(1)`s2nvar' {
							local s2var_`j': word `j' of `s2list1'
							local t1=real(substr("`s2var_`j''",1,1))
							local t2=real(substr("`s2var_`j''",3,1))
							if `t1'>0 & `t2'==0 {
								gen double l1_`t1'=lambda1^`t1'
								local lambda_list "`lambda_list' l1_`t1'"
							}
							if `t1'==0 & `t2'>0 {
								gen double l2_`t2'=lambda2^`t2'
								local lambda_list "`lambda_list' l2_`t2'"
							}
							if `t1'>0 & `t2'>0 {
								gen double l1_`t1'_l2_`t2'=lambda1^`t1'*lambda2^`t2'
								local lambda_list "`lambda_list' l1_`t1'_l2_`t2'"
							}		
						}	
					}

				* Second step on selected specification
					regress `enddep' `endind' `lambda_list' if `use2', 			///
						`endnc' `endoff' `robust' `clopt' `level'

				* Predict residual endogenous variable
					predict double resid 	if `use1', r

				* Estimates of sig_3 (Ham 1982)
					regress `enddep' `endind' lambda1 lambda2 if `use2',				///
						`endnc' `endoff' `robust' `clopt' `level'

					tempname sig_13 sig_23 sig_3
					tempvar  phi_12 lam_12 sig_3_A sig_3_B sig_3_C sig_3_D 
					scalar `sig_13'=_b[lambda1]
					scalar `sig_23'=_b[lambda2]
					gen double `phi_12'=(1/(2*c(pi)*`sig_a'))*					///
						exp(-(1/(2*`sig_a'^2))*(`z1'^2+`z2'^2-2*`rho_12'*`z1'*`z2'))					
					gen double `lam_12'=`phi_12'/`Phi_12'
					gen double `sig_3_A'=`lam_12'*(2*`sig_13'*`sig_23'-`rho_12'*(`sig_13'^2+`sig_23'^2))
					gen double `sig_3_B'=`sig_13'^2*`z1'*lambda1+`sig_23'^2*`z2'*lambda2
					gen double `sig_3_C'=(`sig_13'*lambda1+`sig_23'*lambda2)^2
					gen double `sig_3_D'=`sig_3_A'-`sig_3_B'-`sig_3_C'
					sum `sig_3_D' 										if `use2'
					scalar `sig_3'=sqrt((e(rss)-r(sum))/e(N))
					cap drop `lambda_list'

				* Partial correlation coefficient rho_12_3 
					tempname rho_13 rho_23 rho_12_3
					scalar `rho_13'=max(min(`sig_13'/`sig_3', .7), -.7)
					scalar `rho_23'=max(min(`sig_23'/`sig_3', .7), -.7)
					scalar `rho_12_3'	=(`rho_12'-`rho_13'*`rho_23')/sqrt((1-`rho_13'^2)*(1-`rho_23'^2))


				* Third Estimation Step
					* Trimming
						if `trimming'!=0 {
							_pctile resid		if `use1', p(`t_inf' `t_sup')
							local inf4=r(r1)
							local sup4=r(r2)
							count 			if `use1' 						///
											& ((`z1' <`inf1'|`z1' >`sup1')		///
											| (`z2' <`inf2'|`z2' >`sup2')			///
											| (`enddep' <`inf3'|`enddep' >`sup3')	///
											| (resid <`inf4'|resid >`sup4'))		

							noi di _n "{hline 78}"	 							///
								 _n in gr "Trimming" 							///
								 _n in gr "z1: inf = " 	in ye %9.2f `inf1'			///
								    in gr " - sup = " 	in ye %9.2f `sup1'			///
								 _n in gr "z2: inf = " 	in ye %9.2f `inf2'			///
								    in gr " - sup = " 	in ye %9.2f `sup2'			///
								 _n in gr "inc: inf = " in ye %9.2f `inf3'			///
								    in gr " - sup = " 	in ye %9.2f `sup3'			///
								 _n in gr "res: inf = " in ye %9.2f `inf4'			///
								    in gr " - sup = " 	in ye %9.2f `sup4'			///
								 _n in gr " Observations = " in ye r(N)				///
								 _n "{hline 78}"
							#delimit;
							local use3 "`use1'  
								& (`z1'     >= `inf1' 	& `z1'     <= `sup1') 	
								& (`z2'     >= `inf2' 	& `z2'     <= `sup2')	
								& (`enddep' >= `inf3' 	& `enddep' <= `sup3')
								& (resid    >= `inf4' 	& resid    <= `sup4')";
							#delimit cr
						}
						if "`sample3'"!="" {
							local use3 "`sample3'==1"
						}
						if `trimming'==0 & "`sample3'"=="" {
							local use3 "`use2'"
						}

				* Corrected indexes z1s and z2s
					tempname sig_b sig_c sig_d
					tempvar z1s z2s 
					sca def `sig_b'=sqrt(1-`rho_13'^2)
					sca def `sig_c'=sqrt(1-`rho_23'^2)
					sca def `sig_d'=sqrt(1-`rho_12_3'^2)
					gen double `z1s'	=(`z1'+`rho_13'*resid /`sig_3')/`sig_b'		if `use3'
					gen double `z2s'	=(`z2'+`rho_23'*resid /`sig_3')/`sig_c'		if `use3'

				* Corrected bias correction terms
					tempvar phi_z1s phi_z2s
					gen double `phi_z1s'=normden(`z1s')
					gen double `phi_z2s'=normden(`z2s')
					gen double Lambda1=`phi_z1s'*norm((`z2s'-`rho_12_3'*`z1s')/`sig_d')/binorm(`z1s',`z2s',`rho_12_3')	if `use3'
					gen double Lambda2=`phi_z2s'*norm((`z1s'-`rho_12_3'*`z2s')/`sig_d')/binorm(`z1s',`z2s',`rho_12_3')	if `use3'	

				* Centering corrected bias correction terms
					tempvar  z1s_rc z2s_rc L1_rc L2_rc
					tempname L1 L2
					gen double `z1s_rc'=(`alp1'+`rho_13'*resid /`sig_3')/`sig_b'											if `use3'	
					gen double `z2s_rc'=(`alp2'+`rho_23'*resid /`sig_3')/`sig_c'											if `use3'
					gen double `L1_rc'=normd(`z1s_rc')*norm((`z2s_rc'-`rho_12_3'*`z1s_rc')/`sig_d')/binorm(`z1s_rc',`z2s_rc',`rho_12_3')		if `use3'
					gen double `L2_rc'=normd(`z2s_rc')*norm((`z1s_rc'-`rho_12_3'*`z2s_rc')/`sig_d')/binorm(`z1s_rc',`z2s_rc',`rho_12_3')		if `use3'
					sum `L1_rc'
					sca def `L1'=r(mean)
					sum `L2_rc'
					sca def `L2'=r(mean)
					replace Lambda1=Lambda1-`L1'	if `use3'	
					replace Lambda2=Lambda2-`L2'	if `use3'

				* Determine powers and interaction - third step
					local g1_list "Lambda1 Lambda2 resid"
					local list_norm ""
					if "`s3list1'"!="" {
						local s31nvar: word count `s3list1'
						forvalues j=1(1)`s31nvar' {
							local s31var_`j': word `j' of `s3list1'
							local t1=real(substr("`s31var_`j''",1,1))
							local t2=real(substr("`s31var_`j''",3,1))
							local t3=real(substr("`s31var_`j''",5,1))
							if `t1'>0 & `t2'==0 & `t3'==0 {
								gen double L1_`t1'=Lambda1^`t1'
								local g1_list "`g1_list' L1_`t1'"
								local list_norm "`list_norm' L1_`t1'"
							}
							if `t1'==0 & `t2'>0 & `t3'==0 {
								gen double L2_`t2'=Lambda2^`t2'
								local g1_list "`g1_list' L2_`t2'"
								local list_norm "`list_norm' L2_`t2'"
							}
							if `t1'==0 & `t2'==0 & `t3'>0 {
								gen double Re_`t3'=resid^`t3'
								local g1_list "`g1_list' Re_`t3'"
								local list_norm "`list_norm' Re_`t3'"
							}
							if `t1'>0 & `t2'>0 & `t3'==0 {
								gen double L1_`t1'_L2_`t2'=Lambda1^`t1'	///
												  *Lambda2^`t2'
								local g1_list "`g1_list' L1_`t1'_L2_`t2'"
								local list_norm "`list_norm' L1_`t1'_L2_`t2'"
							}		
							if `t1'>0 & `t2'==0 & `t3'>0 {
								gen double L1_`t1'_Re_`t3'=Lambda1^`t1'	///
												  *resid^`t3'
								local g1_list "`g1_list' L1_`t1'_Re_`t3'"
								local list_norm "`list_norm' L1_`t1'_Re_`t3'"
							}		
							if `t1'==0 & `t2'>0 & `t3'>0 {
								gen double L2_`t2'_Re_`t3'=Lambda2^`t2'	///
												  *resid^`t3'
								local g1_list "`g1_list' L2_`t2'_Re_`t3'"
								local list_norm "`list_norm' L2_`t2'_Re_`t3'"
							}		
							if `t1'>0 & `t2'>0 & `t3'>0 {
								gen double L1_`t1'_L2_`t2'_Re_`t3'=Lambda1^`t1'	///
													    *Lambda2^`t2'	///
													    *resid^`t3'
								local g1_list "`g1_list' L1_`t1'_L2_`t2'_Re_`t3'"
								local list_norm "`list_norm' L1_`t1'_L2_`t2'_Re_`t3'"
							}		
						}	
					}

				* Test
					qui estimates restore `est2'
					qui test `g1_list' 
					noi di in gr "Joint test sel. and endog. - chi2(" in ye r(df) in gr ")=" 		///
					 	in ye %9.2f r(chi2)		 								///
						_col(50) in gr "- Prob > chi2 =" in ye %9.4f r(p)					///
						_n in gr "{hline 78}"

					qui test `list_norm' 
					noi di in gr "Test of Gaussinity - chi2(" in ye r(df) in gr ")=" 		///
					 	in ye %9.2f r(chi2)		 								///
						_col(50) in gr "- Prob > chi2 =" in ye %9.4f r(p)					///
						_n in gr "{hline 78}"

					drop `g1_list'  
			}

		}

	* Return
		eret post `b1' `sd1', esample(`touse') dep("`dep'")
		ereturn local cmd="pl2se"
		eret local depvar "`dep'"
		eret local rhs "`varlist'"
}
end



program define Select
	args seldep selind selnc seloff colon sel_eqn

	gettoken dep rest : sel_eqn, parse(" =")
	gettoken equal rest : rest, parse(" =")

	if "`equal'" == "=" { 
		tsunab dep : `dep'
		c_local `seldep' `dep' 
	}
	else	local rest `"`sel_eqn'"'
	
	local 0 `"`rest'"'
	syntax [varlist(numeric default=none)] 	/*
		*/ [, noCONstant OFFset(varname numeric) ]

	if "`varlist'" == "" {
		di in red "no variables specified for selection equation"
		exit 198
	}

	c_local `selind' `varlist'
	c_local `selnc' `constant'
	c_local `seloff' `offset'
end




