
program define ivgres_0, eclass
	version 8.2
	if replay() {
		if "`e(cmd)'" != "ivgres_0" {
			di as error "results for ivgres_0 not found"
			exit 301
		}
		exit `rc'
	}
	else	Estimate `0'
end

program define Estimate, eclass 

	* Dependent variable
		gettoken dep 0 : 0 , parse(" =,[")
		gettoken equals rest : 0 , parse(" =")
		if "`equals'" == "=" local 0 `"`rest'"'
		local depn : subinstr local dep "." "_"

	* Other equations & options
		syntax varlist(min=1) [if] [in] [pw fw iw] , 						///
			ENDOGeneity(string) 									///
			[noCONstant OFFset(varname numeric) Robust Cluster(varname)   		///
			order1(integer 3) order2(integer 3)	wtype(string) wvar(string) 		///
			TRIMming(real 0)	Level(integer $S_level)]

	* Identify noconstant and offset main equation
		local nc `constant'
		if "`offset'"  != "" local off "offset(`offset')" 

	* Identify Selection equations
		Select enddep endind endnc endoff : `"`endogeneity'"'

	* Estimation sample 
		marksample touse
		markout `touse'  `dep' `enddep' `endind' `endoff' `cluster', strok

	* Other options
		if "`wtype'" 	!= "" local wgt [`wtype'`wvar']
		if "`cluster'" 	!= "" local clopt "cluster(`cluster')" 
		if "`level'" 	!= "" local level "level(`level')"
		if "`weight'" == "pweight" | "`cluster'" != "" local robust "robust"
		local title "IV with generate residual"

	* Estimation sample
		tempvar touse_all
		if `trimming'!=0 {
			noi count if `touse'
			local t_inf=`trimming'
			local t_sup=100-`trimming'
			_pctile `enddep' 		if `touse', p(`t_inf' `t_sup')
			local inf1=r(r1)
			local sup1=r(r2)
			local touse1 "`touse' & (`enddep'>= `inf1' & `enddep' <= `sup1')"
			qui regress `enddep' `endind' 	`wgt' if `touse1', 	///
				`endnc' `endoff' `robust' `clopt' `level'
			predict resid if `touse1', r
			_pctile resid 		if `touse1', p(`t_inf' `t_sup')
			local inf2=r(r1)
			local sup2=r(r2)
			local touse2 "`touse1' & (resid>= `inf2' & resid <= `sup2')"
			gen `touse_all'=(`touse2')
			drop resid
		}
		else 		gen `touse_all'=(`touse')

	* First estimation step
		*if `trimming'!=0 {
		*	local t_inf=`trimming'
		*	local t_sup=100-`trimming'
		*	_pctile `enddep' 		if `touse', p(`t_inf' `t_sup')
		*	local inf1=r(r1)
		*	local sup1=r(r2)
		*	local touse1 "`touse' & (`enddep'>= `inf1' & `enddep' <= `sup1')"
		*}
		*else local touse1 "`touse'"
		qui regress `enddep' `endind' 	`wgt' if `touse_all', 	///
			`endnc' `endoff' `robust' `clopt' `level'

	* Predict residual endogenous variable
		noi predict double resid 	if `touse_all', rstu
		*if `trimming'!=0 {
		*	*local t_inf=`trimming'
		*	*local t_sup=100-`trimming'
		*	*_pctile `enddep' 		if `touse', p(`t_inf' `t_sup')
		*	*local inf1=r(r1)
		*	*local sup1=r(r2)
		*	*local touse1 "`touse' & (`enddep'>= `inf1' & `enddep' <= `sup1')"
		*	_pctile resid 		if `touse', p(`t_inf' `t_sup')
		*	local inf2=r(r1)
		*	local sup2=r(r2)
		*	local touse2 "`touse1' & (resid>= `inf2' & resid <= `sup2')"
		*}
		*else local touse2 "`touse1'"
		local res_list "resid"
		forvalues k=2(1)`order2' {
			gen double resid`k'=resid^`k'		if `touse_all' 
			local res_list "`res_list' resid`k'"
		}

	* List of powers for endogenous variable
		local end_list "`enddep'"
		forvalues k=2(1)`order1' {
			gen double `enddep'`k'=`enddep'^`k'			if `touse_all' 
			local end_list "`end_list' `enddep'`k'"
		}

	* Augmented regression model - variable of interest
		regress `dep' `end_list' `varlist' `res_list'	`wgt' if `touse_all', 	///
			`nc' `off' `robust' `clopt' `level'
		drop `res_list' 
		if `order1'>1 drop `enddep'?

	* Store estimated coefficients
		tempname b sd
		matrix `b'=e(b)
		matrix `sd'=e(V)
		matrix coleq `b'= `dep'
		matrix roweq `sd'= `dep'
		matrix coleq `sd'= `dep'

	* Return
		eret post `b' `sd', esample(`touse_all') dep("`dep'")
		eret local depvar "`dep'"
		eret local rhs "`varlist'"
		ereturn local cmd="bootstrap"
end



program define Select
	args seldep selind selnc seloff colon sel_eqn

	gettoken dep rest : sel_eqn, parse(" =")
	gettoken equal rest : rest, parse(" =")

	if "`equal'" == "=" { 
		tsunab dep : `dep'
		c_local `seldep' `dep' 
	}
	else	local rest `"`sel_eqn'"'
	
	local 0 `"`rest'"'
	syntax [varlist(numeric default=none)] 	/*
		*/ [, noCONstant OFFset(varname numeric) ]

	if "`varlist'" == "" {
		di in red "no variables specified for selection equation"
		exit 198
	}

	c_local `selind' `varlist'
	c_local `selnc' `constant'
	c_local `seloff' `offset'
end




