
program define heck2s, eclass
	version 8.2
	if replay() {
		if "`e(cmd)'" != "heck2s" {
			di as error "results for heck2s not found"
			exit 301
		}
		exit `rc'
	}
	else	Estimate `0'
end

program define Estimate, eclass
qui {
	* Dependent variable
		gettoken dep 0 : 0 , parse(" =,[")
		gettoken equals rest : 0 , parse(" =")
		if "`equals'" == "=" local 0 `"`rest'"'
		local depn : subinstr local dep "." "_"

	* Other equations & options
		syntax varlist(min=1) [if] [in] [pw fw iw] , 						///
			SEL1(string) SEL2(string) 		 						///
			[noCONstant OFFset(varname numeric) Robust Cluster(varname) 		///
			ENDOGeneity(string) First Second ITERations(integer 30) 			///
			TRIMming(integer 0) sample2(varname) sample3(varname)				///
			reps(integer 100) Seed(integer 123456789) save(string) 	 		///
			MLOpts(string) Level(integer $S_level) noLOG *]

	* Identify noconstant and offset main equation
		local nc `constant'
		if "`offset'"  != "" local off "offset(`offset')" 

	* Identify Selection equations
		forvalues i=1(1)2 {
			Select seldep`i' selind`i' selnc`i' seloff`i' : `"`sel`i''"'
			local selname`i' : subinstr local seldep`i' "." "_"
			if "`seloff`i''" != "" local soff`i' "offset(`seloff`i'')" 
		}
		if "`endogeneity'"!="" {
			Select enddep endind endnc endoff : `"`endogeneity'"'
			local endog_eqs "endog(`enddep'=`endind',`endnc' `endoff')"
		}

	* Estimation sample 
		marksample touse1, novarlist
		markout `touse1' `seldep1' `selind1' `seloff1' `cluster', strok

		marksample touse2, novarlist
		markout `touse2' `seldep1' `selind1' `seloff1' `cluster', strok
		markout `touse2' `seldep2' `selind2' `seloff2' `cluster', strok

		marksample touse
		markout `touse' `dep' `varlist' `offset' 
		qui replace `touse2' = 0 	if `seldep2' & !`touse'
		qui replace `touse1' = 0 	if `seldep1' & !`touse2'
		if "`endogeneity'"!="" {
			marksample touse_e
			markout `touse_e' `enddep' `endind' `endoff' 
			qui replace `touse2' = 0 	if `seldep2' & !`touse_e'
			qui replace `touse1' = 0 	if `seldep1' & !`touse2'
		}

	* Other options
		if "`weight'" 	!= "" local wgt [`weight'`exp']
		if "`cluster'" 	!= "" local clopt "cluster(`cluster')" 
		if "`level'" 	!= "" local level "level(`level')"
		if `iterations'	>0 	local iter "iterate(`iterations')"
		if "`weight'" == "pweight" | "`cluster'" != "" local robust "robust"
		local showf = cond("`first'" == "", "quietly", "noisily")
		mlopts mlopts, `options'
		local title "Heckman 2 selection eq."

	*  Check dependent variables and estimation sample
		qui {
			count if `touse' 
			if r(N) == 0 { 
				di as error "no valid observations in main equation"
			   	error 2000
			}
			local N = r(N)

			count if `touse1' 
			if r(N) == 0 { 
				di as error "no valid observations in first selection equation"
			   	error 2000
			}
			local N1 = r(N)

			count if `touse2' 
			if r(N) == 0 { 
				di as error "no valid observations in second selection equation"
			   	error 2000
			}
			local N2 = r(N)

			capture assert (`seldep1' == 1 | `seldep1' == 0) if `touse1'
				if _rc==9 {
					di as error "depvar `seldep1' should be binary (0 or 1)"
					exit 450
				}
			count if `seldep1' == 0 & `touse1'
			local d0 = r(N)
			if `d0' == 0 {
				di as error "`seldep1' is never zero"
				exit 2000
			}
			else if `d0' == `N1' {
				di as error "`var' is always zero"
				exit 2000 
			}
			capture assert (`seldep2' == 1 | `seldep2' == 0) if `touse2'
				if _rc==9 {
					di as error "depvar `seldep2' should be binary (0 or 1)"
					exit 450
				}	
			count if `seldep2' == 0 & `touse2'
			local d0 = r(N)
			if `d0' == 0 {
				di as error "`seldep2' is never zero"
				exit 2000
			}
			else if `d0' == `N2' {
				di as error "`seldep2' is always zero"
				exit 2000 
			}
		}

	* First estimation step
		tempname est1
		`showf' di in gr "First estimation step"
		`showf' heckprob 	`seldep2' `selind2' 					///
					if `touse1',`selnc2' `seloff2'			///
					sel(`seldep1'=`selind1', `selnc1' `seloff1')	///
					`robust' `clopt' `mlopts' `level' `log'
		estimates store `est1'

	* Second estimation step - with bootstrapped standard errors
		if "`nc'"=="" {
			* Estimation
				tempname est2
				noi bootstrap ["`dep'"]_b	 									///
						(rbias: rbias_1=e(rbias1) rbias_2=e(rbias2) rbias=e(rbias)), 		///
						reps(`reps') seed(`seed') `level' nol						///
						saving("`save'" , every(5) replace) title(`title'):				///
						heck2s_0 `dep' `varlist' if `touse1', `nc' `off' 				///
						sel1(`seldep1'=`selind1', `selnc1' `seloff1')					///
						sel2(`seldep2'=`selind2', `selnc2' `seloff2') `endog_eqs'			///
						trimming(`trimming') sample2(`sample2') sample3(`sample3')			///
						`robust' `clopt' `iter' `mlopts' `level' `log' 
				estimates store `est2'
	
			* Store estimated parameters		
				tempname b0 b1 sd0 sd1 
				matrix `b0'=e(b)
				matrix `sd0'=e(V)
				local t=colsof(`b0')-3
				matrix `b1'=`b0'[1,1..`t']
				matrix `sd1'=`sd0'[1..`t',1..`t']
				local sdbias_1=(`sd0'[`t'+1,`t'+1])^.5
				local sdbias_2=(`sd0'[`t'+2,`t'+2])^.5
				local sdbias =(`sd0'[`t'+3,`t'+3])^.5
		}
 		else {
			* Estimation
				tempname est2
				noi bootstrap 	["`dep'"]_b, 									///
						reps(`reps') seed(`seed') `level' nol 						///
						saving("`save'" , every(5) replace) title(`title'):				///
						heck2s_0 `dep' `varlist' if `touse1', `nc' `off' 				///
						sel1(`seldep1'=`selind1', `selnc1' `seloff1')					///
						sel2(`seldep2'=`selind2', `selnc2' `seloff2') `endog_eqs'			///
						trimming(`trimming') sample2(`sample2') sample3(`sample3')			///
						`robust' `clopt' `iter' `mlopts' `level' `log' 
				estimates store `est2'

			* Store estimated parameters		
				tempname b1 sd1 
				matrix `b1'=e(b)
				matrix `sd1'=e(V)
		}


	* Joint test for selection and endogeneity
		estimates restore `est1'
		if e(converged)==1 {
			
			* Set estimation sample
				local use1 "`touse'==1 & `seldep2'==1"

			* Correlation coefficient
				tempname rho_12 sig_a
				sca def `rho_12'=e(rho)
				sca def `sig_a'=sqrt(1-`rho_12'^2)

			* Indexes 
				tempvar z1 z2
				predict double `z1' if e(sample), xbs
				predict double `z2' if e(sample), xb

			* Bias correction terms
				tempvar phi_1 phi_2 Phi_12
				gen double `phi_1'=normden(`z1')
				gen double `phi_2'=normden(`z2')
				predict double `Phi_12' if e(sample), p11
				gen double lambda1=`phi_1'*norm((`z2'-`rho_12'*`z1')/`sig_a')/`Phi_12'
				gen double lambda2=`phi_2'*norm((`z1'-`rho_12'*`z2')/`sig_a')/`Phi_12'

			* Centering bias correction terms
				tempname alp1 alp2 l1 l2 
				sca def `alp1'=_b[`seldep1':_cons]
				sca def `alp2'=_b[`seldep2':_cons]
				sca def `l1'=normd(`alp1')*norm((`alp2'-`rho_12'*`alp1')/`sig_a')/binorm(`alp1',`alp2',`rho_12')
				sca def `l2'=normd(`alp2')*norm((`alp1'-`rho_12'*`alp2')/`sig_a')/binorm(`alp1',`alp2',`rho_12')
				replace lambda1=lambda1-`l1'
				replace lambda2=lambda2-`l2'

			* Test in model without endogeneity
			if "`endogeneity'"=="" {
				qui estimates restore `est2'
				qui test lambda1 lambda2
				noi di in gr "Joint test selection - chi2(" in ye r(df) in gr ")=" 	///
				 	in ye %9.2f r(chi2) 								///
					 _col(50) in gr "- Prob > chi2 =" in ye %9.4f r(p)			///
					 _n in gr "{hline 78}"
				drop lambda1 lambda2

				* Trimming and sample size
					if `trimming'!=0 {
						local t_inf=`trimming'
						local t_sup=100-`trimming'

						_pctile `z1' 		if `use1', p(`t_inf' `t_sup')
						local inf1=r(r1)
						local sup1=r(r2)

						_pctile `z2' 		if `use1', p(`t_inf' `t_sup')
						local inf2=r(r1)
						local sup2=r(r2)

						_pctile `dep'  		if `use1', p(`t_inf' `t_sup')
						local inf3=r(r1)
						local sup3=r(r2)

						#delimit;
						local use2 "`use1' 
								& (`z1'    >= `inf1' & `z1'     <= `sup1') 
								& (`z2'    >= `inf2' & `z2'     <= `sup2')	
								& (`dep'   >= `inf3' & `dep'	  <= `sup3')";
						#delimit cr
					}
					if "`sample2'"!="" {
						local use2 "`sample2'==1"
					}
					if `trimming'==0 & "`sample2'"=="" {
						local use2 "`use1'"
					}
					count if `use2'
					local N=r(N)
			}

			* Test in model with endogeneity 
			else {
				* Trimming on second step
					if `trimming'!=0 {
						local t_inf=`trimming'
						local t_sup=100-`trimming'

						_pctile `z1' 		if `use1', p(`t_inf' `t_sup')
						local inf1=r(r1)
						local sup1=r(r2)

						_pctile `z2' 		if `use1', p(`t_inf' `t_sup')
						local inf2=r(r1)
						local sup2=r(r2)

						_pctile `enddep' 		if `use1', p(`t_inf' `t_sup')
						local inf3=r(r1)
						local sup3=r(r2)

						#delimit;
						local use2 "`use1' 
								& (`z1'    	>= `inf1'    & `z1'    	<= `sup1') 
								& (`z2'    	>= `inf2'    & `z2'    	<= `sup2')	
								& (`enddep' >= `inf3'    & `enddep' <= `sup3')";
						#delimit cr
					}
					if "`sample2'"!="" {
						local use2 "`sample2'==1"
					}
					if `trimming'==0 & "`sample2'"=="" {
						local use2 "`use1'"
					}
					count if `use2'
					local N=r(N)

				* Second Step - Poirier 1980
					`shows' regress `enddep' `endind' lambda1 lambda2 if `use2', 		///
						`endnc' `endoff' `robust' `clopt' `level'

				* Predict residual endogenous variable
					predict double resid if `use1', r

				* Estimates of sig_3 (Ham 1982)
					tempname sig_13 sig_23 sig_3
					tempvar  phi_12 lam_12 sig_3_A sig_3_B sig_3_C sig_3_D 
					scalar `sig_13'=_b[lambda1]
					scalar `sig_23'=_b[lambda2]
					gen double `phi_12'=(1/(2*c(pi)*`sig_a'))*					///
						exp(-(1/(2*`sig_a'^2))*(`z1'^2+`z2'^2-2*`rho_12'*`z1'*`z2'))					
					gen double `lam_12'=`phi_12'/`Phi_12'
					gen double `sig_3_A'=`lam_12'*(2*`sig_13'*`sig_23'-`rho_12'*(`sig_13'^2+`sig_23'^2))
					gen double `sig_3_B'=`sig_13'^2*`z1'*lambda1+`sig_23'^2*`z2'*lambda2
					gen double `sig_3_C'=(`sig_13'*lambda1+`sig_23'*lambda2)^2
					gen double `sig_3_D'=`sig_3_A'-`sig_3_B'-`sig_3_C'
					sum `sig_3_D' 										if `use2'
					scalar `sig_3'=sqrt((e(rss)-r(sum))/e(N))
					drop lambda1 lambda2 

				* Partial correlation coefficient rho_12_3 
					tempname rho_13 rho_23 rho_12_3
					scalar `rho_13'=max(min(`sig_13'/`sig_3', .7), -.7)
					scalar `rho_23'=max(min(`sig_23'/`sig_3', .7), -.7)
					scalar `rho_12_3'	=(`rho_12'-`rho_13'*`rho_23')/sqrt((1-`rho_13'^2)*(1-`rho_23'^2))

			* Third estimation step
				* Trimming
					if `trimming'!=0 {
						_pctile resid		if `use1', p(`t_inf' `t_sup')
						local inf4=r(r1)
						local sup4=r(r2)
						#delimit;
						local use3 "`use1'  
								& (`z1'    >= `inf1' 	& `z1'    <= `sup1') 
								& (`z2'    >= `inf2' 	& `z2'    <= `sup2')	
								& (`enddep' >= `inf3' 	& `enddep' <= `sup3')
								& (resid    >= `inf4' 	& resid    <= `sup4')";
						#delimit cr
					}
					if "`sample3'"!="" {
						local use3 "`sample3'==1"
					}
					if `trimming'==0 & "`sample3'"=="" {
						local use3 "`use2'"
					}

				* Corrected indexes z1s and z2s
					tempname sig_b sig_c sig_d
					sca def `sig_b'=sqrt(1-`rho_13'^2)
					sca def `sig_c'=sqrt(1-`rho_23'^2)
					sca def `sig_d'=sqrt(1-`rho_12_3'^2)

					tempvar z1s z2s 
					gen double `z1s'=(`z1'+`rho_13'*resid /`sig_3')/`sig_b'								if `use3'
					gen double `z2s'=(`z2'+`rho_23'*resid /`sig_3')/`sig_c'								if `use3'

				* Corrected bias correction terms
					tempvar phi_z1s phi_z2s
					gen double `phi_z1s'=normden(`z1s')												if `use3'
					gen double `phi_z2s'=normden(`z2s')												if `use3'
					gen double Lambda1=`phi_z1s'*norm((`z2s'-`rho_12_3'*`z1s')/`sig_d')/binorm(`z1s',`z2s',`rho_12_3')	if `use3'
					gen double Lambda2=`phi_z2s'*norm((`z1s'-`rho_12_3'*`z2s')/`sig_d')/binorm(`z1s',`z2s',`rho_12_3')	if `use3'

				* Centering corrected bias correction terms
					tempvar  z1s_rc z2s_rc L1_rc L2_rc
					tempname L1 L2
					gen double `z1s_rc'=(`alp1'+`rho_13'*resid /`sig_3')/`sig_b'							if `use3'
					gen double `z2s_rc'=(`alp2'+`rho_23'*resid /`sig_3')/`sig_c'							if `use3'
					gen double `L1_rc'=normd(`z1s_rc')*norm((`z2s_rc'-`rho_12_3'*`z1s_rc')/`sig_d')/binorm(`z1s_rc',`z2s_rc',`rho_12_3')	if `use3'
					gen double `L2_rc'=normd(`z2s_rc')*norm((`z1s_rc'-`rho_12_3'*`z2s_rc')/`sig_d')/binorm(`z1s_rc',`z2s_rc',`rho_12_3')	if `use3'
					sum `L1_rc'					
					sca def `L1'=r(mean)
					sum `L2_rc'					
					sca def `L2'=r(mean)
					replace Lambda1=Lambda1-`L1'		if `use3'	
					replace Lambda2=Lambda2-`L2'		if `use3'

				* Test
					qui estimates restore `est2'
					qui test Lambda1 Lambda2 resid
					noi di in gr "Joint test sel. and endog. - chi2(" in ye r(df) in gr ")=" 		///
					 	in ye %9.2f r(chi2)		 								///
						_col(50) in gr "- Prob > chi2 =" in ye %9.4f r(p)					///
						_n in gr "{hline 78}"
					drop Lambda1 Lambda2 resid 
			}
		}

	* Return
		local N1=e(N1)
		local N2=e(N2)
		local N3=e(N3)
		if "`nc'"=="" {
			local rbias_1=e(rbias1)
			local rbias_2=e(rbias2)
			local rbias_3=e(rbias3)
			local rbias	=e(rbias)
		}

		eret post `b1' `sd1', esample(`touse') dep("`dep'")
		ereturn local cmd="heck2s"
		eret local depvar "`dep'"
		eret local rhs "`varlist'"
		ereturn scalar N=`N'
		ereturn scalar N1=`N1'
		ereturn scalar N2=`N2'
		if "`nc'"=="" {
			ereturn scalar rbias1		=`rbias_1'
			ereturn scalar rbias2		=`rbias_2'
			ereturn scalar rbias		=`rbias'
			ereturn scalar sd_rb1		=`sdbias_1'
			ereturn scalar sd_rb2		=`sdbias_2'
			ereturn scalar sd_rb		=`sdbias'
		}
}
end



program define Select
	args seldep selind selnc seloff colon sel_eqn

	gettoken dep rest : sel_eqn, parse(" =")
	gettoken equal rest : rest, parse(" =")

	if "`equal'" == "=" { 
		tsunab dep : `dep'
		c_local `seldep' `dep' 
	}
	else	local rest `"`sel_eqn'"'
	
	local 0 `"`rest'"'
	syntax [varlist(numeric default=none)] 	/*
		*/ [, noCONstant OFFset(varname numeric) ]

	if "`varlist'" == "" {
		di in red "no variables specified for selection equation"
		exit 198
	}

	c_local `selind' `varlist'
	c_local `selnc' `constant'
	c_local `seloff' `offset'
end




