qui {
*------------------------------------------------------------------------------------------------
* Merge capi.dta and unit.dta 
	use capi, clear
	sort sampid2
	merge sampid2 using unit
	drop _merge cv_completed 
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Country dummies
	tab country, gen(cou_)
	rename cou_1 SE
	rename cou_2 NL
	rename cou_3 ES
	rename cou_4 IT
	rename cou_5 DK
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Dummies at the nuts1 level by country
	local countries "DK ES IT NL SE"
	foreach cc of local countries {
		tab nuts1 if `cc'==1, gen(temp1_)
		if r(N)>0 {
			local R=r(r)
			forvalue j=1(1)`R' {
				rename temp1_`j' `cc'_nuts1_`j'
				replace `cc'_nuts1_`j'=0 		if `cc'==0
			}
		}
	}
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Sampling frame information
	replace age_gs=age_r 						if int_completed==1 & age_r!=.
	replace age_r=age_gs 						if int_completed==1 & age_r==. & age_gs!=.
	replace gender_gs=0 						if int_completed==1 & female==1
	replace gender_gs=1 						if int_completed==1 & female==0
	gen gs_fem =(gender_gs==0) 					if gender_gs!=.
	drop gender_gs
	gen gs_agec=age_gs-65
	rename age_gs gs_age
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Interviewers' information
	gen iv_agec=(iv_age-50)
	gen iv_fem=(iv_sex==2) 					if iv_sex!=.
	gen iv_yeduc=(iv_yedu-12)
	drop iv_sex
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Centering delay
*------------------------------------------------------------------------------------------------
	gen DK_M=DK*(1-vignette)
	gen SE_V=SE*vignette
	gen SE_S=SE*suppl
	gen SE_M=SE*(1-vignette)*(1-supplement)
	gen ES_M=ES*(1-vignette)
	gen ES_V=ES*vignette
	gen IT_M=IT*(1-vignette)
	gen IT_V=IT*vignette
	gen NL_M=NL*(1-vignette)
	gen NL_V=NL*vignette
	local countrysamp_list "DK_M SE_M SE_V SE_S ES_M ES_V IT_M IT_V NL_M NL_V"
	gen f_delay_c=f_delay
	foreach cc of local countrysamp_list {
		sum f_delay 						if `cc'==1, d
		replace f_delay_c=f_delay-r(p50) 	if `cc'==1
	}
	gen f_delay_c2=f_delay_c^2
	drop `countrysamp_list'
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* HR demographic
	rename age_r hr_age
	gen  hr_agec=(hr_age-65)
	rename isced_r hr_edu
	rename iscedy_r hr_yedu
	replace hr_edu=0  								if hr_edu==97|hr_edu==95
	replace hr_yedu=0 								if hr_yedu==97|hr_yedu==95
	gen hr_yeduc=(hr_yedu-12)
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Household composition
	gen couple=(mstat<3) 								if int_completed==1 & mstat!=98 & mstat!=99
	lab var couple    "Couple"
	gen single=(couple==0)								if int_completed==1 & couple!=.
	drop dn014_ mstat
	gen youn_chi=0 
	gen children=0			 							if ch001!=. 
	local i 1
	while `i'<=17 {
		replace children=1 								if (ch006_`i'>=1986 & ch006_`i'!=.)
		gen young=0
		replace young=(ch006_`i'>=1986 & ch007_`i'==1) 	if ch006_`i'!=. & ch006_`i'<2004  	///
														& ch007_`i'!=. & ch007_`i'!=98  	///
														& ch007_`i'!=99
		replace youn_chi=youn_chi+1 					if young==1
		drop young
		local i=`i'+1
	}
	replace youn_chi=. 									if ch001_==998 | ch001_==999 | int_completed==0
	lab var youn_chi  	"Number of young children"
	gen equiper		=1+.5*(hsize-1-youn_chi)+.3*youn_chi
	replace equiper	=1 									if equiper<1
	replace hsize=hsize-2
	drop ch006_* ch007_*  
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Age of partner
	gen part_agec=couple*(part_age-65)
	lab var part_agec "Age of partner centered"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Cognitive function variables
	gen orient=orienti - 4 		if int_completed==1 & orienti!=.
	gen recall_d=cf016tot - 7 	if int_completed==1 & cf016tot!=.
	gen math=numeracy - 4 		if int_completed==1 & numeracy!=.
	gen fluency=cf010_ - 25		if int_completed==1 & cf010_<900
	lab var orient 		"Orientation in time score" 
	lab var recall_d 	"Delayed recall score" 
	lab var math 		"Math score" 
	lab var fluency 	"Fluency score" 
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Characteristics of the living area (City and neighboor) 
	gen s_city=(areabldg==5) 				if int_completed==1
	lab var s_city "Living in a small city" 
	drop neig address imped building
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Interview features
	* Proxy interview
		gen proxy_co=(co009==3|co009==2) 					if int_completed==1
		gen proxy_as=(as057_==3|as057_==2) 					if int_completed==1
		gen proxy_ep=(ep210_==3|ep210_==2) 					if int_completed==1
		gen proxy_hh=(hh014==3|hh014==2) 					if int_completed==1
		gen proxy_ho=(ho041==3|ho041==2) 					if int_completed==1
		gen proxy_inc=(proxy_ep==1|proxy_hh==1|proxy_ho==1) if int_completed==1
		gen proxy=(proxy_inc==1|proxy_co==1)				if int_completed==1
		lab var proxy 	"Proxy interview"

	* Interview at the respondent's home
		gen int_out=(ho001_==5) 					if int_completed==1
		lab var int_out "Interview done outside the respondent's home"

	* Asked for clarifications
		gen clarification=(iv007>3) 					if int_completed==1
		lab var clarification "Often asked clarifications"

		drop 	co009_ as057_ ep210_ hh014_ ho041_ 					///
				proxy_co proxy_as proxy_ep proxy_hh proxy_ho 		///
				proxy_inc ho001_ iv007_
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* List of household income components and their flags
	#delimit;
	local income_fin "
		ybaccv_h ybondv_h ystocv_h ymutfv_h
		ybaccvi_h ybondvi_h ystocvi_h ymutfvi_h";
	#delimit cr
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Final dataset
	#delimit;
		keep  country country_s sampid2  				
			samptype vignette supplement
			int_completed nonresponse fahcvi fohcvi				// Nonresponse indicators
			inc_tot_mis inc_tot_mis_n inc_mis inc_mis_n
			fahcv_1 fohcv_1 telcv_1 ppp 						// Consumption variables
			income_1 income_tot_1 inc_mis_par			 		// Income variables	
			`income_fin' 
			gs_fem gs_age gs_agec 								// Sampling frame info
			ans_mac f_delay f_delay_c 								// Fieldwork info
			iv_fem iv_age iv_agec iv_yedu iv_yeduc				// Interviewer Characteristics
			female hr_age hr_agec hr_yedu hr_yeduc				// HR demographic variables
			hsize couple single s_city youn_chi part_agec	
			orient math fluency recall_d						// Cognitive functioning variables 
			proxy int_out clarification 						// Features of the interview process
			nrpart_h wgtach 
			DK* ES* IT* NL* SE*
		; 			
		order  country country_s sampid2  				
			samptype vignette supplement
			int_completed nonresponse fahcvi fohcvi				// Nonresponse indicators
			inc_tot_mis inc_tot_mis_n inc_mis inc_mis_n
			fahcv_1 fohcv_1 telcv_1 ppp 						// Consumption variables
			income_1 income_tot_1 inc_mis_par			 		// Income variables	
			`income_fin' 
			gs_fem gs_age gs_agec 								// Sampling frame info
			ans_mac f_delay f_delay_c 								// Fieldwork info
			iv_fem iv_age iv_agec iv_yedu iv_yeduc				// Interviewer Characteristics
			female hr_age hr_agec hr_yedu hr_yeduc				// HR demographic variables
			hsize couple single s_city youn_chi part_agec	
			orient math fluency recall_d						// Cognitive functioning variables 
			proxy int_out clarification 						// Features of the interview process
			nrpart_h wgtach 
			DK* ES* IT* NL* SE*
		; 		
	#delimit cr
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* PPP adjusted expenditures & income components
*------------------------------------------------------------------------------------------------
	replace fahcv_1=fahcv_1/(ppp)
	replace fahcv_1=fahcv_1/(ppp)
	replace telcv_1=telcv_1/(ppp)
	replace income_1=income_1/(ppp)
	replace income_tot_1=income_tot_1/(ppp)
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Item response indicators
*------------------------------------------------------------------------------------------------
* Food expenditure
	gen food_a1_obs=(fahcvi==0)							if int_completed==1
	gen food_a2_obs=(fohcvi==0)							if int_completed==1
	gen food_a_obs=(food_a1_obs==1 & food_a2_obs==1)	if int_completed==1
	gen food_a1=fahcv_1									if int_completed==1 & food_a1_obs==1
	gen food_a2=fohcv_1									if int_completed==1 & food_a2_obs==1
	gen food_a=food_a1+food_a2							if int_completed==1 & food_a_obs ==1
	rename fahcv_1 food_a1_imp1
	rename fohcv_1 food_a2_imp1
	gen food_a_imp1=food_a1_imp1+food_a2_imp1

* Total household income 
	gen income_obs=(inc_tot_mis==0)						if int_completed==1
	gen income=income_tot_1								if int_completed==1 & income_obs==1
	rename income_tot_1 income_imp1
	cap drop inc_tot_mis_n 

* Total household income (net of nonresponse on income from capital assets) 
	gen income2_obs=(inc_mis==0)						if int_completed==1
	gen income2=income_1								if int_completed==1 & income2_obs==1
	local income_fin "ybaccv ybondv ystocv ymutfv"
	foreach jj of local income_fin {
		replace income2=income2 + `jj'_h				if `jj'i_h==0
	}
	rename income_1 income2_imp1
	foreach jj of local income_fin {
		replace income2_imp1=income2_imp1+`jj'_h		if `jj'i_h==0
	}
	cap drop inc_mis_n 
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Renaming variables
	drop gs_age iv_age
	rename int_completed part
	rename gs_agec gs_age
	rename gs_fem gs_female
	rename iv_agec iv_age
	rename iv_fem iv_female
	rename iv_yeduc iv_edu
	rename supplement suppl
	rename f_delay_c delay
	rename hr_agec age
	rename part_agec partner_age
	rename hr_yeduc education
	rename youn_chi children
	rename s_city small_city
	rename clarification int_clarif
	rename telcv_1 tel_a_imp1

	compress
	sort sampid2 
	save mydata, replace
*------------------------------------------------------------------------------------------------

}
