qui {

*------------------------------------------------------------------------------------------------
* Log file
	cap log close
	log using 5_Merge_fieldwork_capi, replace t
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Check match between unit.dta and capi.dta
*------------------------------------------------------------------------------------------------
	noi di _n in gr "{hline 78}" _n in ye				///
	"Merge between unit.dta and capi.dta"				///
	_n in gr "{hline 78}"
	use unit, clear
	keep sampid2 country 
	merge sampid2 using capi
	noi tab country _merge, mis
	keep if _merge==3
	drop _merge
	compress
	sort sampid2 cvid 
	save capi, replace
	noi di _n in gr "{hline 78}"

	noi di _n in gr "{hline 78}" _n in ye				///
	"Merge between capi.dta and unit.dta"				///
	_n in gr "{hline 78}"
	use capi, clear
	bys sampid2: keep if _n==1
	keep sampid2 country 
	merge sampid2 using unit
	noi tab country _merge
	noi tab eligible _merge, mis
	noi tab int_completed _merge, mis
	drop _merge
	compress 
	sort sampid2
	save unit, replace
	noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Merge contact with unit.dta 
*------------------------------------------------------------------------------------------------
	noi di _n in gr "{hline 78}" _n in ye				///
	"Merge contact.dta with unit.dta"					///
	_n in gr "{hline 78}"
	use contact, clear
	sort sampid
	merge sampid using unit, keep(country eligible int_completed samptype)
	drop if eligible!=1
	noi tab country _merge, mis
	drop if _merge!=3
	gen supplement=(samptype==3)
	gen vignette=(samptype==2)
	keep 	sampid2 cvid country country_s samptype supplement vignette 	///
			code mode date_c 
	order 	sampid2 cvid country country_s samptype supplement vignette 	///
			code mode date_c 
	compress
	sort sampid2 cvid date_c
	save contact, replace
	noi di _n in gr "{hline 78}"


	noi di _n in gr "{hline 78}" _n in ye				///
	"Merge unit.dta with contact.dta"					///
	_n in gr "{hline 78}"
	use contact, clear
	bys sampid2: keep if _n==1
	keep sampid2 country
	merge sampid2 using unit
	drop if eligible!=1
	noi tab country _merge, mis
	drop if _merge!=3
	gen supplement=(samptype==3)
	gen vignette=(samptype==2)

	keep 	sampid2 country country_s samptype supplement vignette 	///
			age_gs gender_gs 										///
			cv_completed int_completed nonresponse n_* nuts? 		///
			iv*	areasize building neig address imped				
			
	order 	sampid2 country country_s samptype supplement vignette 	///
			age_gs gender_gs 										///
			cv_completed int_completed nonresponse n_* nuts? 		///
			iv*	areasize building neig address imped				
	compress
	sort sampid2
	save unit, replace
	noi di _n in gr "{hline 78}"

	noi di _n in gr "{hline 78}" _n in ye				///
	"Merge unit.dta with capi.dta"					///
	_n in gr "{hline 78}"
	use unit, clear
	keep if int_completed==1
	keep sampid2 country
	sort sampid2
	merge sampid2 using capi
	noi tab country _merge, mis
	keep if _merge==3
	drop _merge
	sort sampid2 cvid
	save capi, replace
	noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Add samptype info into capi.dta
*------------------------------------------------------------------------------------------------
	use unit, clear
	keep if int_completed==1
	keep sampid2 samptype
	rename samptype samptype2
	save temp, replace

	use capi, clear
	merge sampid2 using temp
	replace samptype=samptype2
	drop samptype2
	drop _merge
	sort sampid2
	save capi, replace
	cap erase temp.dta
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Add Fieldwork indicators to unit.dta 
*------------------------------------------------------------------------------------------------

	use contact, clear

	* Answering machine
		gen ans_mac=(code==201|code==202)

	* Indicator for delay of contact
		bys sampid: egen delay=min(date_c)
		bys country samptype: egen b0=min(date_c)
		bys country samptype: egen b1=max(date_c)
		gen f_delay=(delay-b0)/(b1-b0)		

	* Contact variables
		collapse 	(max) ans_mac f_delay, by (sampid country) fast
		lab var ans_mac  "Answering machine"
		lab var f_delay  "Delay of contacting process"
		sort sampid2
		merge sampid2 using unit
		assert _merge==3
		drop _merge

	* Final dataset
		keep 	sampid2 country country_s samptype supplement vignette 	///
			age_gs gender_gs 											///
			cv_completed int_completed nonresponse nuts? 				///
			iv*	areasize building neig address imped					///
			ans_mac f_delay 											 

		order 	sampid2 country country_s samptype supplement vignette 	///
			age_gs gender_gs 											///
			cv_completed int_completed nonresponse nuts? 				///
			iv*	areasize building neig address imped					///
			ans_mac f_delay 											 

		compress
		sort sampid
		save unit, replace
		cap erase contact.dta
*------------------------------------------------------------------------------------------------
	
cap log close
}


