qui {

*------------------------------------------------------------------------------------------------
* Log file
	cap log close
	log using 2_Imputations, replace t
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Load original imputation data 
forvalues r=1(1)5 {
	use "${share_w1}\share1rel2-0-1_imputations", clear
	keep if implicat==`r'
	drop if country==11|country==12|country==17|country>18
	drop implicat
	save Imputation`r', replace
}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Load relevant imputation data
forvalues r=1(1)5 {
	use Imputation`r', clear
	order	sampid2 cvid country nrpartn 		///
		ppp		 								///
		fahcv fohcv telcv						///	// Imputed expenditure variables
		fahcvi fohcvi telcvi					///
		hgtincv 								///	// Original income variables
		ydipv yindv 							///		// labor incomes (annual)
		pen1v pen2v pen3v pen4v pen5v 			///		// income from pensions (montly)
		pen6v pen7v pen8v pen9v pen10v 			///
		pen11v 									///
		reg1v reg2v reg3v reg4v reg5v			///		// regular payments (montly)
		yltcv									///		// income from long term care (montly. Only DE and AU)
		yrentv									///		// income from rent 
		yohmv yohbv								///		// income from other hhs members (annual)
		hirentv									/// 		// income from imputed rent 
		ybaccv ybondv ystocv ymutfv				///		// income from capital assett
												///	
												///	// Annual income variables
		annpen1v annpen2v annpen3v annpen4v		///		// Annual pensions
		annpen5v annpen6v annpen7v annpen8v		///
		annpen9v annpen10v annpen11v			///
		annreg1v annreg2v annreg3v				///		// Annual regular payments
		annreg4v annreg5v						///		
												///
												///	// Imputation flags income variables
		ydipvi yindvi 							///		// labor incomes (annual)
		pen1vi pen2vi pen3vi pen4vi pen5vi 		///		// income from pensions (montly)
		pen6vi pen7vi pen8vi pen9vi pen10vi 	///
		pen11vi 								///
		reg1vi reg2vi reg3vi reg4vi reg5vi		///		// regular payments (montly)
		yltcvi									///		// income from long term care (montly)
		yohmvi yohbvi							///		// income from other hhs members (annual)
		yrentvi									/// 		// income from rent
		ybaccvi ybondvi ystocvi ymutfvi			///		// income from capital assett
												///
												///	// Other imputed variables
		age edu numeracy reading urban			///
		agei edui numeracyi readingi urbani	

	keep	sampid2 cvid country nrpartn 		///
		ppp		 								///
		fahcv fohcv telcv						///	// Imputed expenditure variables
		fahcvi fohcvi telcvi					///
		hgtincv 								///	// Original income variables
		ydipv yindv 							///		// labor incomes (annual)
		pen1v pen2v pen3v pen4v pen5v 			///		// income from pensions (montly)
		pen6v pen7v pen8v pen9v pen10v 			///
		pen11v 									///
		reg1v reg2v reg3v reg4v reg5v			///		// regular payments (montly)
		yltcv									///		// income from long term care (montly. Only DE and AU)
		yrentv									///		// income from rent 
		yohmv yohbv								///		// income from other hhs members (annual)
		hirentv									/// 		// income from imputed rent 
		ybaccv ybondv ystocv ymutfv				///		// income from capital assett
												///	
												///	// Annual income variables
		annpen1v annpen2v annpen3v annpen4v		///		// Annual pensions
		annpen5v annpen6v annpen7v annpen8v		///
		annpen9v annpen10v annpen11v			///
		annreg1v annreg2v annreg3v				///		// Annual regular payments
		annreg4v annreg5v						///		
												///
												///	// Imputation flags income variables
		ydipvi yindvi 							///		// labor incomes (annual)
		pen1vi pen2vi pen3vi pen4vi pen5vi 		///		// income from pensions (montly)
		pen6vi pen7vi pen8vi pen9vi pen10vi 	///
		pen11vi 								///
		reg1vi reg2vi reg3vi reg4vi reg5vi		///		// regular payments (montly)
		yltcvi									///		// income from long term care (montly)
		yohmvi yohbvi							///		// income from other hhs members (annual)
		yrentvi									/// 		// income from rent
		ybaccvi ybondvi ystocvi ymutfvi			///		// income from capital assett
												///
												///	// Other imputed variables
		age edu numeracy reading urban			///
		agei edui numeracyi readingi urbani	
*------------------------------------------------------------------------------------------------

	local list 	"age edu numeracy reading urban"



*------------------------------------------------------------------------------------------------
* Generate total hhs gross income and compare with the generated variable (hgtincv)
	noi di _n in gr "{hline 78}" _n in ye														///
	"Imputation `r': Compare total hhs gross income with the generated variable (hgtincv)"		///
	_n in gr "{hline 78}"
	gen double income=ydipv+yindv+yrentv
	replace yltcv=yltcv*12
	replace income=income+yltcv 
	forvalues j=1(1)11 {
		replace income=income+annpen`j'v 
		if `j'<= 5 	replace income=income+annreg`j'v 
	}
	bysort sampid2: egen double income_h=total(income)
	bysort sampid2: gen temp=_n 
	replace income_h=income_h+yohmv+yohbv if temp==1
	bysort sampid2: egen double income_h2=max(income_h)

	bysort sampid2: egen double ybaccv_hh=total(ybaccv)
	bysort sampid2: egen double ybondv_hh=total(ybondv)
	bysort sampid2: egen double ystocv_hh=total(ystocv)
	bysort sampid2: egen double ymutfv_hh=total(ymutfv)
	replace income=income_h2
	gen income_tot=income_h2+ybaccv_hh + ybondv_hh + ystocv_hh + ymutfv_hh
	drop income_h income_h2
	lab var income "Total household income (net of income from financial assett)"
	lab var income_tot "Total household income"
	gen double hgtincv2=hgtincv - ybaccv_hh - ybondv_hh - ystocv_hh - ymutfv_hh
	noi compare income_tot hgtincv 
	noi compare income hgtincv2 
	noi sum income_tot hgtincv income hgtincv2
	noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Generate flag for missing total hhs gross income 
	noi di _n in gr "{hline 78}" _n in ye							///
	"Imputation `r': Flag for missing total hhs gross income"		///
	_n in gr "{hline 78}"
	gen inc_mis=0
	gen inc_mis_par=0
	local list "ydipv yindv yrentv yltcv"
	foreach j of local list {
		replace inc_mis=1 						if `j'i==1 
		replace inc_mis_par=1 					if `j'i==1 
	}
	forvalues j=1(1)11 {
		replace inc_mis=1 						if pen`j'vi==1 
		replace inc_mis_par=1 					if pen`j'vi==1 
		if `j'<= 5 	qui replace inc_mis=1 		if reg`j'vi==1 
	}
	bysort sampid2: egen temp1=max(inc_mis)
	replace inc_mis=1 							if temp1==1 & inc_mis==0
	replace inc_mis_par=1 						if temp1==1 & inc_mis==0

	bysort sampid2: egen temp2=max(yohmvi)
	replace inc_mis=1 							if temp2==1 
	replace inc_mis_par=1 						if temp2==1

	bysort sampid2: egen temp3=max(yohbvi)
	replace inc_mis=1 							if temp3==1 
	replace inc_mis_par=1 						if temp3==1
	drop temp1 temp2 temp3

	gen inc_tot_mis=inc_mis
	local hh_var "ybaccvi ybondvi ystocvi ymutfvi"
	foreach var of local hh_var {
		bysort sampid2: egen temp1=max(`var')
		replace inc_tot_mis=1 					if temp1==1 
		drop temp1
	}

	lab def mis 0 "No imputation" 1 "Some imputation"
	lab val inc_mis mis
	lab val inc_mis_par mis
	lab val inc_tot_mis mis
	lab var inc_mis "total hhs gross income (net from financial assett) - missing flag"
	lab var inc_tot_mis "total hhs gross income - missing flag"
	noi tab inc_mis inc_tot_mis					if temp==1, mis
	noi tab inc_mis inc_mis_par					if temp==1, mis
	noi tab inc_mis_par inc_tot_mis				if temp==1, mis
	noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Generate number of missing income components
	noi di _n in gr "{hline 78}" _n in ye					///
	"Imputation `r': Number of missing income components"	///
	_n in gr "{hline 78}"
	gen inc_mis_n=0
	local list "ydipv yindv yrentv yltcv"
	foreach j of local list {
		replace inc_mis_n=inc_mis_n+1 				if `j'i==1 
	}
	forvalues j=1(1)11 {
		replace inc_mis_n=inc_mis_n+1 				if pen`j'vi==1 
		if `j'<= 5 	replace inc_mis_n=inc_mis_n+1 	if reg`j'vi==1 
	}
	bysort sampid2: egen temp1=total(inc_mis_n)
	replace inc_mis_n=temp1
	bysort sampid2: egen temp2=max(yohmvi)		
	replace inc_mis_n=inc_mis_n+1					if temp2==1 
	bysort sampid2: egen temp3=max(yohbvi)
	replace inc_mis_n=inc_mis_n+temp3				if temp3==1 
	drop temp1 temp2 temp3
	gen inc_tot_mis_n=inc_mis_n
	local hh_var "ybaccvi ybondvi ystocvi ymutfvi"
	foreach var of local hh_var {
		bysort sampid2: egen temp1=max(`var')
		replace inc_tot_mis_n=inc_tot_mis_n+1		if temp1==1 
		drop temp1
	}
	lab var inc_mis_n "Number of missing income components"
	lab var inc_tot_mis_n "Number of missing income components"
	noi tab inc_tot_mis_n inc_tot_mis  if temp==1, mis
	noi tab inc_mis_n inc_mis  if temp==1, mis
	noi sum inc_tot_mis_n inc_mis_n, d
	noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Compute fraction of imputed total household income 
	noi di _n in gr "{hline 78}" _n in ye							///
	"Imputation `r': Fraction of imputed total household income"	///
	_n in gr "{hline 78}"
	gen double fimp_inc=0
	local list "ydipv yindv yrentv yltcv"
	foreach j of local list {
		replace fimp_inc=fimp_inc+`j' 						if `j'i==1 
	}
	forvalues j=1(1)11 {
		replace fimp_inc=fimp_inc+annpen`j'v 				if pen`j'vi==1 
		if `j'<= 5 	replace fimp_inc=fimp_inc+annreg`j'v 	if reg`j'vi==1 
	}
	bysort sampid2: egen double temp1=total(fimp_inc)
	replace fimp_inc=temp1

	bysort sampid2: egen double temp2=mean(yohmv) 			if yohmvi==1 
	replace temp2=0 										if temp2==.

	bysort sampid2: egen double temp3=max(yohbv)			if yohbvi==1 
	replace temp3=0 										if temp3==.

	gen double nmis_income=income-(fimp_inc+temp2+temp3)
	replace fimp_inc=(fimp_inc+temp2+temp3)/income
	replace fimp_inc=0										if fimp_inc==.
	drop temp1 temp2 temp3
	lab var fimp_inc "Fraction of imputed income component"
	noi tabstat fimp_inc 	if temp==1 & inc_mis_n>0, 					///
		stat(count mean p25 p50 p75) by(country) format(%9.3f)
	noi tabstat fimp_inc 	if temp==1 & inc_mis_n>0 & inc_mis_n<5, 	///
		stat(count mean p25 p50 p75) by(inc_mis_n) format(%9.3f) 
	noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Generate number of household income sources 
	noi di _n in gr "{hline 78}" _n in ye							///
	"Imputation `r': Generate number of household income sources"	///
	_n in gr "{hline 78}"
	gen inc_sources=0
	local list "ydipv yindv yrentv yltcv"
	foreach j of local list {
		replace inc_sources=inc_sources+1					if `j'>0 
	}
	forvalues j=1(1)11 {
		replace inc_sources=inc_sources+1 					if annpen`j'v>0
		if `j'<= 5 	replace inc_sources=inc_sources+1 		if annreg`j'v>0
	}
	bysort sampid2: egen temp1=total(inc_sources)
	replace inc_sources=temp1
	drop temp1 
	replace inc_sources=inc_sources+1						if yohmv>0
	replace inc_sources=inc_sources+1						if yohbv>0
	lab var inc_sources "Number of income sources"
	noi tab inc_sources, mis sum(income)
	noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Annual consumption expenditure data
	replace fahcv = fahcv *12
	replace fohcv = fohcv *12
	replace telcv = telcv *12
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Inocome sources at the household level
	bysort sampid2: egen double ydipv_h=total(ydipv)
	bysort sampid2: egen double yindv_h=total(yindv)
	bysort sampid2: egen double yrentv_h=total(yrentv)
	bysort sampid2: egen double pen1v_h=total(annpen1v)
	bysort sampid2: egen double pen2v_h=total(annpen2v)
	bysort sampid2: egen double pen3v_h=total(annpen3v)
	bysort sampid2: egen double pen4v_h=total(annpen4v)
	bysort sampid2: egen double pen5v_h=total(annpen5v)
	bysort sampid2: egen double pen6v_h=total(annpen6v)
	bysort sampid2: egen double pen7v_h=total(annpen7v)
	bysort sampid2: egen double pen8v_h=total(annpen8v)
	bysort sampid2: egen double pen9v_h=total(annpen9v)
	bysort sampid2: egen double pen10v_h=total(annpen10v)
	bysort sampid2: egen double pen11v_h=total(annpen11v)
	bysort sampid2: egen double reg1v_h=total(annreg1v)
	bysort sampid2: egen double reg2v_h=total(annreg2v)
	bysort sampid2: egen double reg3v_h=total(annreg3v)
	bysort sampid2: egen double reg4v_h=total(annreg4v)
	bysort sampid2: egen double reg5v_h=total(annreg5v)
	bysort sampid2: egen double yltcv_h=total(yltcv)
	gen double yohmv_h=yohmv
	gen double yohbv_h=yohbv
	
	bysort sampid2: egen double ybaccv_h=total(ybaccv)
	bysort sampid2: egen double ybondv_h=total(ybondv)
	bysort sampid2: egen double ystocv_h=total(ystocv)
	bysort sampid2: egen double ymutfv_h=total(ymutfv)
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Nonresponse flag indicators at the household level
	bysort sampid2: egen ydipvi_h=max(ydipvi)
	bysort sampid2: egen yindvi_h=max(yindvi)
	bysort sampid2: egen yrentvi_h=max(yrentvi)
	bysort sampid2: egen pen1vi_h=max(pen1vi)
	bysort sampid2: egen pen2vi_h=max(pen2vi)
	bysort sampid2: egen pen3vi_h=max(pen3vi)
	bysort sampid2: egen pen4vi_h=max(pen4vi)
	bysort sampid2: egen pen5vi_h=max(pen5vi)
	bysort sampid2: egen pen6vi_h=max(pen6vi)
	bysort sampid2: egen pen7vi_h=max(pen7vi)
	bysort sampid2: egen pen8vi_h=max(pen8vi)
	bysort sampid2: egen pen9vi_h=max(pen9vi)
	bysort sampid2: egen pen10vi_h=max(pen10vi)
	bysort sampid2: egen pen11vi_h=max(pen11vi)
	bysort sampid2: egen reg1vi_h=max(reg1vi)
	bysort sampid2: egen reg2vi_h=max(reg2vi)
	bysort sampid2: egen reg3vi_h=max(reg3vi)
	bysort sampid2: egen reg4vi_h=max(reg4vi)
	bysort sampid2: egen reg5vi_h=max(reg5vi)
	bysort sampid2: egen yltcvi_h=max(yltcvi)
	gen yohmvi_h=yohmvi
	gen yohbvi_h=yohbvi
	bysort sampid2: egen ybaccvi_h=max(ybaccvi)
	bysort sampid2: egen ybondvi_h=max(ybondvi)
	bysort sampid2: egen ystocvi_h=max(ystocvi)
	bysort sampid2: egen ymutfvi_h=max(ymutfvi)
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* Summary statistics by income components
noi di _n in gr "{hline 78}" _n in ye							///
"Imputation `r': Summary statistics by income components"		///
_n in gr "{hline 78}"

noi di _n "With respect to total hhs income"
	#delimit;
	local income_comp "
		ydipv yindv yrentv 
		pen1v pen2v pen3v
		pen4v pen5v pen6v
		pen7v pen8v pen9v
		pen10v pen11v		
		reg1v reg2v reg3v
		reg4v reg5v yltcv
		yohmv yohbv
		ybaccv ybondv ystocv ymutfv
		";
	#delimit cr
	noi di _n _n _n								///
		 _col(1)	in gr " "					///
		 _col(15)   in gr "& Hhs with" 			///
		 _col(30)   in gr "& Hhs with" 			///
		 _col(45)   in gr "& Frac. income"		///
		 _col(60)   in gr "& Frac. income"		///
		 _col(75)   in gr "& Frac. income"		///
		 _col(90) 	in gr "\\", 				///
		 _n										/// 
		 _col(1)	in gr "Component"			///
		 _col(15)   in gr "& Comp.>0" 			///
		 _col(30)   in gr "& Comp. imp." 		///
		 _col(45)   in gr "& Mean"				///
		 _col(60)   in gr "& P90"				///
		 _col(75)   in gr "& P95"				///
		 _col(90) 	in gr "\\", _continue 
	foreach iv of local income_comp {
		gen double f1_`iv'=`iv'_h/income_tot 		if temp==1 & country!=12
		count if temp==1 & country!=12 				// Numero di Famiglie
		local n1=r(N)
		count if temp==1 & country!=12 & `iv'_h>0 	// Numero di Famiglie con iv
		local n2=r(N)/`n1'
		count if temp==1 & country!=12 & `iv'i_h==1 // Numero di famiglie con iv imputata
		local n3=r(N)/`n1'
		sum f1_`iv' if temp==1 & country!=12,d		// Mean fraction of total hh income
		local n4=r(mean) 					
		local n5=r(p90) 						
		local n6=r(p95) 						
		drop f1_`iv'	
		noi di _n									///
			 _col(1)	in gr "`iv'"				///
			 _col(15)   in gr "&" in ye %9.3f `n2'	///
			 _col(30)   in gr "&" in ye %9.3f `n3'	///
			 _col(45)   in gr "&" in ye %9.3f `n4'	///
			 _col(60)   in gr "&" in ye %9.3f `n5'	///
			 _col(75)   in gr "&" in ye %9.3f `n6'	///
			 _col(90) 	in gr "\\", _continue 
 	}
	noi di _n


noi di _n "With respect to total hhs income net of income from financial assett"

	#delimit;
	local income_comp "
		ydipv yindv yrentv 
		pen1v pen2v pen3v
		pen4v pen5v pen6v
		pen7v pen8v pen9v
		pen10v pen11v		
		reg1v reg2v reg3v
		reg4v reg5v yltcv
		yohmv yohbv
		";
	#delimit cr
	noi di _n _n _n								///
		 _col(1)	in gr " "					///
		 _col(15)   in gr "& Hhs with" 			///
		 _col(30)   in gr "& Hhs with" 			///
		 _col(45)   in gr "& Frac. income"		///
		 _col(60)   in gr "& Frac. income"		///
		 _col(75)   in gr "& Frac. income"		///
		 _col(90) 	in gr "\\", 				///
		 _n										/// 
		 _col(1)	in gr "Component"			///
		 _col(15)   in gr "& Comp.>0" 			///
		 _col(30)   in gr "& Comp. imp." 		///
		 _col(45)   in gr "& Mean"				///
		 _col(60)   in gr "& P90"				///
		 _col(75)   in gr "& P95"				///
		 _col(90) 	in gr "\\", _continue 
	foreach iv of local income_comp {
		gen double f1_`iv'=`iv'_h/income	 		if temp==1 & country!=12
		count if temp==1 & country!=12 				// Numero di Famiglie
		local n1=r(N)
		count if temp==1 & country!=12 & `iv'_h>0 	// Numero di Famiglie con iv
		local n2=r(N)/`n1'
		count if temp==1 & country!=12 & `iv'i_h==1 // Numero di famiglie con iv imputata
		local n3=r(N)/`n1'
		sum f1_`iv' if temp==1 & country!=12,d		// Mean fraction of total hh income
		local n4=r(mean) 					
		local n5=r(p90) 						
		local n6=r(p95) 						
		drop f1_`iv'	
		noi di _n									///
			 _col(1)	in gr "`iv'"				///
			 _col(15)   in gr "&" in ye %9.3f `n2'	///
			 _col(30)   in gr "&" in ye %9.3f `n3'	///
			 _col(45)   in gr "&" in ye %9.3f `n4'	///
			 _col(60)   in gr "&" in ye %9.3f `n5'	///
			 _col(75)   in gr "&" in ye %9.3f `n6'	///
			 _col(90) 	in gr "\\", _continue 
 	}
	noi di _n
	noi di _n in gr "{hline 78}"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* List of household income components and their flags
*------------------------------------------------------------------------------------------------
	#delimit;
	local income_fin "
		ybaccv_h ybondv_h ystocv_h ymutfv_h
		ybaccvi_h ybondvi_h ystocvi_h ymutfvi_h";
	#delimit cr
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Rename other imputed covariates
	local list 	"age edu numeracy reading urban"
	foreach j of local list {
		qui rename `j' `j'_imp
		qui rename `j'i `j'_imp_i
	}
	local list 	"age_imp edu_imp numeracy_imp reading_imp urban_imp"
	local list2	"age_imp_i edu_imp_i numeracy_imp_i reading_imp_i urban_imp_i"
	bysort sampid2: egen nrpart_h=max(nrpartn)
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Drop nonresponding partners
	drop if nrpartn==1
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Select relevant observations
	keep 	sampid2 cvid country nrpart_h			///
		income inc_mis inc_mis_n 					///
		income_tot inc_tot_mis inc_tot_mis_n		///
		inc_mis_par									///
		`income_fin'								///
		fahcv fohcv telcv fahcvi fohcvi telcvi 		///
		ppp `list' `list2' 
	order	sampid2 cvid country nrpart_h			///
		income inc_mis inc_mis_n 					///
		income_tot inc_tot_mis inc_tot_mis_n		///
		inc_mis_par									///
		`income_fin'								///
		fahcv fohcv telcv fahcvi fohcvi telcvi 		///
		ppp `list' `list2' 
	sort sampid2 cvid
	save imp`r'_income, replace
	cap erase Imputation`r'.dta
}
*------------------------------------------------------------------------------------------------





*------------------------------------------------------------------------------------------------
* Merge imputed datasets across replicates
noi di _n in gr "{hline 78}" _n in ye			///
"Merge imputed datasets across replicates"		///
_n in gr "{hline 78}"

	* Select multple imputations only for the relevant sub-set of variables
		forvalues r=2(1)5 {
			use imp`r'_income, clear
			keep sampid2 cvid income income_tot fahcv fohcv telcv 
			rename income income_`r'
			rename income_tot income_tot_`r'
			rename fahcv fahcv_`r'
			rename fohcv fohcv_`r' 
			rename telcv telcv_`r' 
			merge sampid cvid using imp1_income
			assert _merge==3
			drop _merge
			sort sampid2 cvid
			compress
			save imp1_income, replace
		}
		rename income income_1
		rename income_tot income_tot_1
		rename fahcv fahcv_1
		rename fohcv fohcv_1 
		rename telcv telcv_1 

	* Check possible differences in observed (i.e. not imputed data) across replicates
		noi sum income_? 		if inc_mis==0
		noi sum income_tot_? 	if inc_mis==0
		noi sum fahcv_? 		if fahcvi==0
		noi sum fohcv_? 		if fohcvi==0
		noi sum telcv_? 		if telcvi==0
		
	* Replace the small differences with the row mean across replicates	
		egen double mean_i=rmean(income_1 income_2 income_3 income_4 income_5) 					if inc_mis==0
		egen double mean_i_tot=rmean(income_tot_1 income_tot_2 income_tot_3 income_tot_4 income_tot_5) 	if inc_tot_mis==0
		egen double mean_c1=rmean(fahcv_1 fahcv_2 fahcv_3 fahcv_4 fahcv_5) 					if fahcvi==0
		egen double mean_c2=rmean(fohcv_1 fohcv_2 fohcv_3 fohcv_4 fohcv_5) 					if fohcvi==0
		egen double mean_c3=rmean(telcv_1 telcv_2 telcv_3 telcv_4 telcv_5) 					if telcvi==0
		forvalues r=1(1)5 {
			replace income_`r'=mean_i			if inc_mis==0
			replace income_tot_`r'=mean_i_tot	if inc_tot_mis==0
			replace fahcv_`r'=mean_c1			if fahcvi==0
			replace fohcv_`r'=mean_c2			if fohcvi==0
			replace telcv_`r'=mean_c3			if telcvi==0
		}
		noi sum income_? 		if inc_mis==0
		noi sum income_tot_? 	if inc_tot_mis==0
		noi sum fahcv_? 		if fahcvi==0
		noi sum fohcv_? 		if fohcvi==0
		noi sum telcv_? 		if telcvi==0
		drop mean_i mean_i_tot mean_c1 mean_c2 mean_c3
		compress
		
	* Ordering relevant variables and save imputation dataset
		keep	sampid2 cvid country nrpart_h					///
			income_tot_1 inc_tot_mis inc_tot_mis_n				///
			income_1 inc_mis inc_mis_n							///
			inc_mis_par											///
			fahcv_1 fahcvi fohcv_1 fohcvi telcv_1				///
			`income_fin'										///
			ppp `list' `list2' 
		order	sampid2 cvid country nrpart_h					///
			income_tot_1 inc_tot_mis inc_tot_mis_n				///
			income_1 inc_mis inc_mis_n							///
			inc_mis_par											///
			fahcv_1 fahcvi fohcv_1 fohcvi telcv_1				///
			`income_fin'										///
			ppp `list' `list2' 

		sort sampid2 cvid
		save imp_income, replace

	* Erasing single imputation files
		forvalues j=1(1)5 {
			cap erase imp`j'_income.dta
		}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Check for zeros in household income and outliers in the budget share 
	noi di _n in gr "{hline 78}" _n in ye				///
	"Check outliers in the budget share"				///
	_n in gr "{hline 78}"

noi di _n "With respect to total hhs income"
	noi tab country 		if income_tot_1==0
	noi tab country 		if income_tot_1>0 & fahcv_1/income_tot_1>1

noi di _n "With respect to total hhs income net of income from financial assett"
	noi tab country 		if income_1==0
	noi tab country 		if income_1>0 & fahcv_1/income_1>1
*------------------------------------------------------------------------------------------------
 
cap log close
}
