qui {

*------------------------------------------------------------------------------------------------
* Define list of variables
	local Variables 		"a"
	local Country_list 		"ALL DK ES IT NL SE"
	local Model_list 		"M1 M2 M3"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over Variables2
*------------------------------------------------------------------------------------------------
foreach V of local Variables {

	* Dependent variables
		local U		="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y		="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"

	* Variable specific log file
		cap log close
		log using "${TS_EST}/`V'_wad", replace text
		local Xvar "ln_hincome_1_`V'"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over Country_list2
*------------------------------------------------------------------------------------------------

foreach C of local Country_list {

	* Select country
		if "`C'"!="ALL" local keep "keep if `C'==1"
		else local keep ""

	* Country title
		if "`C'"=="ALL" 	{
			local C_tit "All countries"
			local lower=8.5
			local upper=12
			local step=.1
			local obs=1000

			local M1_order=3
			local M2_order=3
			local M3_order=3
		}
		if "`C'"=="DK" 	{
			local C_tit "Denmark"
			local M1_order=3
			local M2_order=3
			local M3_order=3
		}
		if "`C'"=="ES" 	{
			local C_tit "Spain"
			local M1_order=1
			local M2_order=3
			local M3_order=1
		}
		if "`C'"=="IT" 	{
			local C_tit "Italy"
			local M1_order=2
			local M2_order=3
			local M3_order=1
		}
		if "`C'"=="NL" 	{
			local C_tit "Netherland"
			local M1_order=2
			local M2_order=3
			local M3_order=1
		}
		if "`C'"=="SE" 	{
			local C_tit "Sweden"
			local M1_order=2
			local M2_order=3
			local M3_order=3
		}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Generate country specific dataset
*------------------------------------------------------------------------------------------------
	* Select relevant observations
		use sample_income, clear
		`keep'
		
	* Construct list of predictors
		global CC="`C'"
		global V="`V'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		dropping `U' 		${U_X}
		dropping `I_Y' 		${I_Y_X}					if `U'==1
		dropping `E_imp' 		${E_X} 	${wgt}			if `U'==1 
		dropping `Y_imp' 		${Y_imp_X} 	${wgt}		if `U'==1 
		dropping `E' 	 	${E_X}						if `U'==1 & `I_E'==1 
		dropping `Y' 	 	${Y_X}						if `U'==1 & `I_Y'==1 

		keep sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V'	///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  
		order sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' ///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  

		merge sampid using "${PL_DEGREE}/trimm_`V'_`C'", sort
		drop _merge
		compress
		saveold "${TS_EST}/temp_`V'_`C'", replace
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Loop over models
*------------------------------------------------------------------------------------------------
noi di _n in gr "`C' & " _continue  

foreach M of local Model_list {

	if "`M'"=="M1" {
		local porder=`M1_order'		
		local sample 	"sam3_`V'_`C'"
		local name1 	"ln_hincome_1_`V'" 
		local name2 	"ln_hincome_1_`V'2" 
		local name3 	"ln_hincome_1_`V'3"
		local bestim 	"TS_BOOT\\`V'_`C'_`M'" 
		local R=1000
		local bname1 	"w_food_`V'_b_`name1'"
		local bname2 	"w_food_`V'_b_`name2'"
		local bname3 	"w_food_`V'_b_`name3'"

	}
	if "`M'"=="M2" {
		local porder=`M2_order'		
		local sample	"`U'"
		local name1 	"ln_hincome_1_`V'" 
		local name2 	"ln_hincome_1_`V'2" 
		local name3 	"ln_hincome_1_`V'3"
		local bestim 	"TS_BOOT\\`V'_`C'_`M'" 
		local R=1000
		local bname1 	"w_food_imp1_`V'_b_`name1'"
		local bname2 	"w_food_imp1_`V'_b_`name2'"
		local bname3 	"w_food_imp1_`V'_b_`name3'"
	}
	if "`M'"=="M3" {
		local porder=`M3_order'		
		local sample 	"sam3_`V'_`C'"
		local name1 	"ln_hincome_1_`V'" 
		local name2 	"END_2" 
		local name3 	"END_3"
		local bestim 	"TS_BOOT\\`V'_`C'_`M'" 
		local R=1000
		local bname1 	"w_food_`V'_b_`name1'"
		local bname2 	"w_food_`V'_b_`name2'"
		local bname3 	"w_food_`V'_b_`name3'"
	}

	use "${TS_EST}/temp_`V'_`C'", clear
	if "`M'"=="M2" {
		cap drop ln_hincome_1_`V'
		rename ln_hincome_imp1_1_$V ln_hincome_1_`V'
	}
	noi kdensity `Xvar' if `sample'==1, at(`Xvar') gen(ln_income density) nodraw 
	sum density 										if `sample'==1
	gen double weights=density/r(sum)

	estread "${TS_EST}/`V'_`C'_`M'", estsave id(sampid2)
	estimates restore `M'
	local a1=_b[`name1']
	if `porder'>=2 local a2=_b[`name2']
	if `porder'>=3 local a3=_b[`name3']

	if `porder'==1 		gen double der_g=(`a1')									if `sample'==1
	if `porder'==2 		gen double der_g=(`a1'+2*`a2'*`name1')					if `sample'==1
	if `porder'==3 		gen double der_g=(`a1'+2*`a2'*`name1'+3*`a3'*`name1'^2)	if `sample'==1
	gen double ad=der_g*weights													if `sample'==1
	keep sampid country weights ad der_g `name1' `sample'
	saveold "${TS_EST}/temp_2", replace
	collapse (sum) ad , fast
	gen r=0
	saveold "${TS_EST}/WAD_`V'_`C'_`M'", replace

	forvalues r=1(1)`R'{ 
		use "`bestim'", clear
		local a1=`bname1'[`r']
		if `porder'>=2 local a2=`bname2'[`r']
		if `porder'>=3 local a3=`bname3'[`r']
		
		use "${TS_EST}/temp_2", clear
		cap drop ad
		cap drop der_g
		if `porder'==1 		gen double der_g=(`a1')							if `sample'==1
		if `porder'==2 		gen double der_g=(`a1'+2*`a2'*`name1')				if `sample'==1
		if `porder'==3 		gen double der_g=(`a1'+2*`a2'*`name1'+3*`a3'*`name1'^2)	if `sample'==1
		gen double ad=der_g*weights										if `sample'==1
		collapse (sum) ad , fast
		gen r=`r'
		append using "${TS_EST}/WAD_`V'_`C'_`M'"
		saveold "${TS_EST}/WAD_`V'_`C'_`M'", replace
	}
	cap erase "${TS_EST}/temp_2.dta" 
	sum ad if r==0
	local ad =r(mean)
	sum ad if r>0
	local sd_ad =r(sd)
	if "`M'"!="M3" 	noi di _continue %9.2f `ad' "&" %9.3f `sd_ad' "&"
	else 			noi di _continue %9.2f `ad' "&" %9.3f `sd_ad' "\\"
}
cap erase "${TS_EST}/temp_`V'_`C'.dta"

}
}

cap log close
}

