qui {

*------------------------------------------------------------------------------------------------
* Define list of variables
	local Variables1 		"a"
	local Country_list1 	"DK ES IT NL SE"
	local Model_list1 		"M1 M2 M3"
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------
* Do estimates
*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over Variables1
*------------------------------------------------------------------------------------------------
foreach V of local Variables1 {

	* Dependent variables
		local U		="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y		="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Loop over Country_list1
*------------------------------------------------------------------------------------------------

foreach C of local Country_list1 {

	* Select country
		if "`C'"!="ALL" local keep "keep if `C'==1"
		else local keep ""

	* Country specific elements
	if "`V'"=="a" 	{
		if "`C'"=="DK" 	{
			local C_tit "Denmark"

			local order_MCAR=3
			local order1_MCAR=3
			local order2_MCAR=3

			local order_MAR=3
			local order1_MAR=3
			local order2_MAR=3

			local K1=3
			local K2=2
			local s2list1 " "
			local s3list1 "0_2_0 0_0_2"
			local s3list2 "2 3"
		}
		if "`C'"=="ES" 	{
			local C_tit "Spain"

			local order_MCAR=1
			local order1_MCAR=1
			local order2_MCAR=1

			local order_MAR=3
			local order1_MAR=3
			local order2_MAR=2

			local K1=3
			local K2=3
			local s2list1 " "
			local s3list1 " "
			local s3list2 " "
		}
		if "`C'"=="IT" 	{
			local C_tit "Italy"

			local order_MCAR=2
			local order1_MCAR=1
			local order2_MCAR=2

			local order_MAR=3
			local order1_MAR=1
			local order2_MAR=2

			local K1=3
			local K2=3
			local s2list1 " "
			local s3list1 "0_0_2"
			local s3list2 " "
		}
		if "`C'"=="NL" 	{
			local C_tit "Netherland"

			local order_MCAR=2
			local order1_MCAR=1
			local order2_MCAR=2

			local order_MAR=3
			local order1_MAR=3
			local order2_MAR=2

			local K1=3
			local K2=2
			local s2list1 "2_0"
			local s3list1 "2_0_0 0_2_0 0_0_2 1_1_0 1_0_1 0_1_1 2_1_0 2_0_1 0_3_0 0_2_1 0_0_3"
			local s3list2 " "
		}
		if "`C'"=="SE" 	{
			local C_tit "Sweden"

			local order_MCAR=2
			local order1_MCAR=2
			local order2_MCAR=3

			local order_MAR=3
			local order1_MAR=2
			local order2_MAR=3

			local K1=3
			local K2=3
			local s2list1 "2_0 1_1 0_2 3_0 2_1 1_2"
			local s3list1 "2_0_0 0_2_0 0_0_2 1_1_0 1_0_1 0_1_1 2_0_1 0_1_2 0_0_3"
			local s3list2 "2 3"
		}
	}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Generate country specific dataset
*------------------------------------------------------------------------------------------------
	* Select relevant observations
		use sample_income, clear
		`keep'
		
	* Construct list of predictors
		global CC="`C'"
		global V="`V'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		noi di _n in gr "{hline 75}" _n in ye						///
			"Dropping other missing data on predictors "			///
			_n in gr "{hline 75}"
			noi di _n in gr "Unit"
			noi dropping `U' 		${U_X}
			noi di _n in gr "Item"
			noi dropping `I_Y' 	${I_Y_X}					if `U'==1
			noi di _n in gr "Endogenous imputed"
			noi dropping `E_imp' 	${E_X} 	${wgt}			if `U'==1 
			noi di _n in gr "Budget share imputed"
			noi dropping `Y_imp' 	${Y_imp_X} 	${wgt}		if `U'==1 
			noi di _n in gr "Endogenous"
			noi dropping `E' 	 	${E_X}					if `U'==1 & `I_E'==1 
			noi di _n in gr "Budget share"
			noi dropping `Y' 	 	${Y_X}					if `U'==1 & `I_Y'==1 

	* Tabulate nonresponse indicators
		noi di _n in gr "{hline 75}" _n in ye		///
			"Tabulate nonresponse indicators"		///
			_n in gr "{hline 75}"
		noi tab `U', mis
		noi tab `I_Y' 				if `U'==1, mis
		noi tab `I_E' 				if `U'==1, mis
		noi tab `I_E' `I_Y' 	, mis ce 
		noi sum `E_imp' `Y_imp' `E' `Y'  if `U'==1 & `I_Y'==1

		keep sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V'	///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  
		order sampid2 country							///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  			///
			${U_X} ${I_Y_X} ${E_X} 						///
			${Y_X} ${Y_imp_X} 							///
			ln_hincome_1_`V' ln_hincome_2_`V' 			///
			ln_hincome_3_`V' ln_hincome_4_`V' 			///
			ln_hincome_5_`V' 							///
			ln_hincome_imp1_1_`V' ln_hincome_imp1_2_`V'	///
			ln_hincome_imp1_3_`V' ln_hincome_imp1_4_`V' ///
			ln_hincome_imp1_5_`V' 						///
			${wgt}  

		merge sampid using "${PL_DEGREE}/trimm_`V'_`C'", sort
		noi tab _merge
		drop _merge
		compress
		saveold "${TS_EST}/temp_`V'_`C'", replace
		noi di _n in gr "{hline 85}"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Loop by models
*------------------------------------------------------------------------------------------------
foreach m of local Model_list1 {

	* Variable, country and model specific log file
		cap log close
		log using "${TS_EST}/`V'_`C'_`m'", replace text
		estimates clear

*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Define starting values of the SNP estimator
*------------------------------------------------------------------------------------------------
	if "`m'"=="M3"	{
		if "`C'"=="IT"|"`C'"=="ES"|"`C'"=="SE" {
			estread "${FS_DEGREE}/`V'_`C'_snp", estsave id(sampid2)
			estimates restore SNP_3_2
			matrix b_32=e(b)
			local k0=e(k)-6
			local k1=e(k)-5
			local k2=e(k)-4
			local k3=e(k)-3
			local k4=e(k)-2
			local k5=e(k)-1
			matrix b0=b_32[1,1..`k0']
			matrix g1=(b_32[1,`k1'..`k2'],0)
			matrix g2=(b_32[1,`k3'..`k4'],0)
			matrix g3=(b_32[1,`k5'..e(k)],0)
			matrix b_start_33=(b0,g1,g2,g3)
			matrix drop b0 g1 g2 g3
			local from "from(b_start_33, copy)"
		}
		if "`C'"=="DK"|"`C'"=="NL" {
			local from "startprobit"
		}
	}
*------------------------------------------------------------------------------------------------




*------------------------------------------------------------------------------------------------
* M1: Model 1 
*------------------------------------------------------------------------------------------------
if "`m'"=="M1" {

	* Title
		noi di _n in gr "{hline 78}" _n in ye		///
		"M1: Model 1"								///
		_n in gr "{hline 78}"

	* Load data
		use "${TS_EST}/temp_`V'_`C'", replace

	* Second step - food budget share 
		noi plinear `Y' ${denom} ${Y_X}, 					///
			nonlinear(${denom}) order(`order_MCAR') trim(1)	///
			save("TS_BOOT\\`V'_`C'_`m'")					///
			reps(1000) seed($seed) 	 
		noi di e(N)

		estimates store `m'
		estwrite `m' using "${TS_EST}/`V'_`C'_`m'", estsave replace id(sampid2)
		noi di _n in gr "{hline 78}"
}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* M2: Model 2 
*------------------------------------------------------------------------------------------------
if "`m'"=="M2" {

	* Title
		noi di _n in gr "{hline 78}" _n in ye	///
		"M2: Model 2"							///
		_n in gr "{hline 78}"

	* Load data
		use "${TS_EST}/temp_`V'_`C'", replace
		drop ln_hincome_1_`V' ln_hincome_2_`V' ln_hincome_3_`V' ln_hincome_4_`V' ln_hincome_5_`V'
		rename ln_hincome_imp1_1_$V ln_hincome_1_`V'
		rename ln_hincome_imp1_2_$V ln_hincome_2_`V'
		rename ln_hincome_imp1_3_$V ln_hincome_3_`V'
		rename ln_hincome_imp1_4_$V ln_hincome_4_`V'
		rename ln_hincome_imp1_5_$V ln_hincome_5_`V'

	* Second step - food budget share 
		noi plinear `Y_imp' ${denom} ${Y_X} [pw=${wgt}], 		///
			nonlinear(${denom}) order(`order_MAR') trim(1)		///
			save("TS_BOOT\\`V'_`C'_`m'")						///
			reps(1000) seed($seed) 	 
		noi di e(N)

		estimates store `m'
		estwrite `m' using "${TS_EST}/`V'_`C'_`m'", estsave replace id(sampid2)
		noi di _n in gr "{hline 78}"
}
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* M3: Model 4 
*------------------------------------------------------------------------------------------------
if "`m'"=="M3" {

	* Title
		noi di _n in gr "{hline 78}" _n in ye	///
		"M3: Model 4"							///
		_n in gr "{hline 78}"

	* Load data
		use "${TS_EST}/temp_`V'_`C'", replace

	* Third step 
		noi pl2se `Y' ${Y_X} ${denom},						///
			sel1(`U'=${U_X}) sel2(`I_Y'=${I_Y_X})			///
			endog(${denom}=${E_X})  						///
			first s1order1(`K1') s1order2(`K2') `from' 		///
			second s2list1(`s2list1') sample2(sam2_`V'_`C') ///
			s3list1(`s3list1') s3list2(`s3list2')			///
			sample3(sam3_`V'_`C')							///				
			save("TS_BOOT\\`V'_`C'_`m'")					///
			reps(1000) seed($seed) iter($iter)	

		estimates store `m'
		estwrite `m' using "${TS_EST}/`V'_`C'_`m'", estsave replace id(sampid2)
		noi di _n in gr "{hline 78}"

}
*------------------------------------------------------------------------------------------------


*------------------------------------------------------------------------------------------------
* Close loops
*------------------------------------------------------------------------------------------------
			cap log close
		}					// Close Loop over Models
		cap erase "${TS_EST_COU}/temp_`V'_`C'.dta"
	}						// Close Loop over Country
}							// Close Loop over Variables
*------------------------------------------------------------------------------------------------
*------------------------------------------------------------------------------------------------
}

