qui {

*------------------------------------------------------------------------------------------------
* Define list of variables
	local Variables "a"
	local Country_list "ALL"
	local trim= 1
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Loop over variables
foreach V of local Variables {

	* Dependent variables
		local U		="part"
		local I_Y	="w_food_obs_`V'"
		local Y_imp	="w_food_imp1_`V'"
		local Y		="w_food_`V'"
		local I_E 	="hincome_obs_`V'"
		local E_imp	="ln_hincome_imp1_`V'"
		local E 	="ln_hincome_`V'"
*------------------------------------------------------------------------------------------------



*------------------------------------------------------------------------------------------------
* Loop over country_list1
foreach C of local Country_list {

	* Select country
		if "`C'"!="ALL" local keep "keep if `C'==1"
		else local keep ""

	* Country title
		if "`C'"=="DK" 	local C_tit "Denmark"
		if "`C'"=="ES" 	local C_tit "Spain"
		if "`C'"=="IT" 	local C_tit "Italy"
		if "`C'"=="NL" 	local C_tit "Netherland"
		if "`C'"=="SE" 	local C_tit "Sweden"
		if "`C'"=="ALL" local C_tit "All countries"

	* Variable and country specific log file
		cap log close
		log using "${PL_DEGREE}/`V'_`C'_44", replace text
		estimates clear
*------------------------------------------------------------------------------------------------






*------------------------------------------------------------------------------------------------
* Generate country specific dataset

	* Select relevant observations
		use sample_income, clear
		`keep'
		
	* Construct list of predictors
		global CC="`C'"
		global V="`V'"
		run 0_Predictors.do
		run 0_TRANSFORM_NUTS.do

	* Dropping missing data on predictors 
		noi di _n in gr "{hline 75}" _n in ye						///
			"Dropping other missing data on predictors "			///
			_n in gr "{hline 75}"
			noi di _n in gr "Unit"
			noi dropping `U' 		${U_X}
			noi di _n in gr "Item"
			noi dropping `I_Y' 	${I_Y_X}							if `U'==1
			noi di _n in gr "Endogenous imputed"
			noi dropping `E_imp' 	${E_X} 	${wgt}					if `U'==1 
			noi di _n in gr "Budget share imputed"
			noi dropping `Y_imp' 	${Y_imp_X} 	${denom_imp} ${wgt}	if `U'==1 
			noi di _n in gr "Endogenous"
			noi dropping `E' 	 	${E_X}							if `U'==1 & `I_Y'==1 
			noi di _n in gr "Budget share"
			noi dropping `Y' 	 	${Y_X}							if `U'==1 & `I_Y'==1 

	* Tabulate nonresponse indicators
		noi di _n in gr "{hline 75}" _n in ye		///
			"Tabulate nonresponse indicators"		///
			_n in gr "{hline 75}"
		noi tab `U', mis
		noi tab `I_Y' 				if `U'==1, mis
		noi tab `I_E' 				if `U'==1, mis
		noi tab `I_E' `I_Y' 	, mis ce 
		noi sum `E_imp' `Y_imp' `E' `Y'  if `U'==1 & `I_Y'==1

		keep  sampid2 country						///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  		///
			${U_X} ${I_Y_X} ${E_X} 					///
			${Y_X} ${Y_imp_X} 						///
			${denom} ${denom_imp}					///
			${wgt} 		 
		order sampid2 country						///
			`U' `I_Y' `E' `Y' `E_imp' `Y_imp'  		///
			${U_X} ${I_Y_X} ${E_X} 					///
			${Y_X} ${Y_imp_X} 						///
			${denom} ${denom_imp}					///
			${wgt} 		 
		compress
		saveold "${PL_DEGREE}/temp_`V'_`C'", replace
		noi di _n in gr "{hline 85}"
*------------------------------------------------------------------------------------------------





*------------------------------------------------------------------------------------------------
* CV on second and third semiparametric estimation step  
noi di _n in gr "{hline 80}" _n in ye								///
"CV on second and third semiparametric estimation step  - `C_tit'"	///
_n in gr "{hline 80}"

	* Load data
		use "${PL_DEGREE}/temp_`V'_`C'", clear
	
	* Starting values SNP estimator
		if "`V'"=="a" {
			if "`C'"=="ALL"|"`C'"=="IT"|"`C'"=="ES"|"`C'"=="SE" {
				estread "${FS_DEGREE}/`V'_`C'_snp", estsave id(sampid2)
				estimates restore SNP_3_3
				matrix b_33=e(b)
				local k0=e(k)-9
				local k1=e(k)-8
				local k2=e(k)-6
				local k3=e(k)-5
				local k4=e(k)-3         
				local k5=e(k)-2         
				matrix b0=b_33[1,1..`k0']
				matrix g1=(b_33[1,`k1'..`k2'],0)
				matrix g2=(b_33[1,`k3'..`k4'],0)
				matrix g3=(b_33[1,`k5'..e(k)],0)
				matrix b_start_44=(b0,g1,g2,g3,0,0,0,0)
				local from "from(b_start_44, copy)"
				matrix drop b0 g1 g2 g3
				local K1=4
				local K2=4
			}
			if "`C'"=="DK"|"`C'"=="NL" {
				local from "startprobit"
				local K1=3
				local K2=2
			}
		}
		if "`V'"=="b" {
			if "`C'"=="ALL"|"`C'"=="IT"|"`C'"=="ES"|"`C'"=="NL"|"`C'"=="SE" {
				estread "${FS_DEGREE}/`V'_`C'_snp", estsave id(sampid2)
				estimates restore SNP_3_2
				matrix b_32=e(b)
				local k0=e(k)-6
				local k1=e(k)-5
				local k2=e(k)-4
				local k3=e(k)-3
				local k4=e(k)-2
				local k5=e(k)-1
				matrix b0=b_32[1,1..`k0']
				matrix g1=(b_32[1,`k1'..`k2'],0)
				matrix g2=(b_32[1,`k3'..`k4'],0)
				matrix g3=(b_32[1,`k5'..e(k)],0)
				matrix b_start_33=(b0,g1,g2,g3)
				matrix drop b0 g1 g2 g3
				local from "from(b_start_33, copy)"
				local K1=3
				local K2=3
			}
			if "`C'"=="DK" {
				local from "startprobit"
				local K1=3
				local K2=2
			}
		}

	* Third step - Budget share
		noi h2ssd `Y' ${Y_X} ${denom},					///
			sel1(`U'=${U_X}) sel2(`I_Y'=${I_Y_X})		///
			endog(${denom}=${E_X})  					///
			trim(`trim') 								///
			first s1order1(`K1') s1order2(`K2') `from' 	///
			second s2order1(3)							///
			s3order1(3) s3order2(3)						///
			sample2(sam2_`V'_`C') sample3(sam3_`V'_`C')

		noi di "sig_13= " e(sig_13) 
		noi di "sig_23= " e(sig_23) 
		noi di "sig_3= " e(sig_3) 

		noi di "rho_12= " e(rho_12) 
		noi di "rho_13= " e(rho_13) 
		noi di "rho_23= " e(rho_23) 
		noi di "rho_12_3= " e(rho_12_3) 

		keep sampid sam2_`V'_`C' sam3_`V'_`C'
		saveold "${PL_DEGREE}/trimm_`V'_`C'_44", replace

noi di _n in gr "{hline 80}"
*------------------------------------------------------------------------------------------------
	
		cap log close
		cap erase "${PL_DEGREE}/temp_`V'_`C'.dta"
	}						// Close Loop over Country
}							// Close Loop over Variables

}							// End quitely

