clear all
set matsize 10000

* locals
local x $x
local y $y
local s $subsample
local inter $inter

// Open log
cap log close
log using gsem_`inter'_`x'_`y'_`s', replace


use "Output/database_model_final",clear
rename $x x
rename $y y
rename $inter inter

drop if missing(y)
drop if missing(x)
drop if missing(inter)

// Random drop
gen random=runiform()
drop if random>$sample


// Make instrument
merge m:1 niscode sector using "Output/minimumdist_adnr"
drop if _merge==2
drop _merge
merge m:1 niscode sector using "Output/minimumdist_adnr_count"
drop if _merge==2
drop _merge

gen mindist_treat=d_scho_ASO
gen mindist_notreat=.
foreach var of varlist d_scho_noASO d_scho_mixed {
replace mindist_notreat=`var' if `var'<mindist_notreat
}

gen z=mindist_notreat-mindist_treat
label var z "Dist nonElite - dist Elite"
global propvars z

// Number of schools within 5 km distance
gen totsch5 =  tot_5km_scho_notreat + tot_5km_scho_treat

// Drop observations without control variables
foreach var of varlist $controls2{
drop if missing(`var')
}

// Selection of the sample
if $subsample==2 {
drop if totsch5==0
drop if totsch5==1 
drop if totsch5==2
drop if totsch5==3
}
if $subsample==3 {
drop if d4_scho_any< d_scho_ASO
}
if $subsample==4 {
keep if ASO2==1
}
if $subsample==5 {
keep if scho_someASO==1
}
if $subsample==6 {
drop if dropout_uncertain==1
}


*add distance to closest tracks to decisions
gen drel_someASO=min(d_scho_someTSO,d_scho_someKSO,d_scho_someBSO)-d_scho_someASO


*specify variables
global xvars 					z 	$controls2 	drel_someASO 	
global intervars				$controls2 	drel_someASO 	 
global yvars 					$controls2 					 	
	
*keep only essential info and drop missings
keep $xvars x y inter location

foreach var of var * { 
di "`var'"
drop if missing(`var') 
}

*create potential outcomes by setting to missing
gen y0=y if x==0
gen y1=y if x==1

gen inter0=inter if x==0
gen inter1=inter if x==1

gen y0_inter=y0 	if inter==1
gen y0_nointer=y0	if inter==0
gen y1_inter=y1		if inter==1
gen y1_nointer=y1	if inter==0

*specify constraints
local i=0		
foreach var of varlist $controlsdemo {
local i=`i'+1
constraint `i' [inter0]_b[`var']=[inter1]_b[`var']
local i=`i'+1
constraint `i' [y1_inter]_b[`var']=[y1_nointer]_b[`var']
local i=`i'+1
constraint `i' [y0_inter]_b[`var']=[y0_nointer]_b[`var']
}

*estimate (first on subsample)
gen random=runiform()
gsem ///
( $xvars 		ability@1  	-> x, probit) /// elite school
( $intervars 	ability	  	-> inter0, probit)  /// intermediate steps
( $intervars 	ability	  	-> inter1, probit)  /// 
( $yvars 		ability 	-> y1_inter, probit) /// outcomes
( $yvars 		ability 	-> y0_inter, probit) ///
( $yvars 		ability 	-> y1_nointer, probit) ///
( $yvars 		ability 	-> y0_nointer, probit) ///
if random<0.2, covstruct(_lexogenous, diagonal) latent(ability ) means( ability@0) cov( ability@1) nocapslatent vce(cluster location) 	constraints(1-`i') 
drop random
mat init=e(b)

gsem ///
( $xvars 		ability@1  	-> x, probit) /// elite school
( $intervars 	ability	  	-> inter0, probit)  /// intermediate steps
( $intervars 	ability	  	-> inter1, probit)  /// 
( $yvars 		ability 	-> y1_inter, probit) /// outcomes
( $yvars 		ability 	-> y0_inter, probit) ///
( $yvars 		ability 	-> y1_nointer, probit) ///
( $yvars 		ability 	-> y0_nointer, probit) ///
, covstruct(_lexogenous, diagonal) latent(ability ) means( ability@0) cov( ability@1) nocapslatent vce(cluster location) 	constraints(1-`i') from(init)
est store threestage	
est save "Output/threestage",replace

drop y0* y1* inter0 inter1

*according to this model, what are treatment effects? 
gen zb=[x]_cons+[x]_b[z]*z+[x]_b[drel_someASO]*drel_someASO

gen inter0=[inter0]_cons+[inter0]_b[drel_someASO]*drel_someASO				
gen inter1=[inter1]_cons+[inter1]_b[drel_someASO]*drel_someASO

gen xb0_nointer=[y0_nointer]_cons
gen xb1_nointer=[y1_nointer]_cons

gen xb0_inter=[y0_inter]_cons	
gen xb1_inter=[y1_inter]_cons

qui foreach var of varlist $controls2  { //other vars
replace zb=zb+[x]_b[`var']*`var'

replace inter0=inter0+[inter0]_b[`var']*`var'
replace inter1=inter1+[inter1]_b[`var']*`var'

replace xb0_nointer=xb0_nointer+[y0_nointer]_b[`var']*`var'
replace xb1_nointer=xb1_nointer+[y1_nointer]_b[`var']*`var'

replace xb0_inter=xb0_inter+[y0_inter]_b[`var']*`var'
replace xb1_inter=xb1_inter+[y1_inter]_b[`var']*`var'
}

gen prob1= 		normal(inter1) * ///
				(normal(xb1_inter) ) /// 
			+	(1-normal(inter1)) * ///
				( normal(xb1_nointer)) //

gen prob0= 		normal(inter0) * /// 
				(normal(xb0_inter) ) /// 
			+	(1-normal(inter0)) * ///
				( normal(xb0_nointer)) //

gen te=prob1-prob0
sum te

tempfile startpred
save `startpred',replace
use `startpred',clear

	*te and distributional effects using simulated ability
		gen psel_sim=0
		
		gen treat_sim=0
		gen prob0_sim=0
		gen prob1_sim=0
		
		gen gain_sim=0
		gen loose_sim=0
		gen gain_tt_sim=0
		gen loose_tt_sim=0 
		gen gain_ut_sim=0
		gen loose_ut_sim=0			
					
		gen prob0_sim3=0
		gen prob1_sim3=0
		
		gen gain_sim3=0
		gen loose_sim3=0
		gen gain_tt_sim3=0
		gen loose_tt_sim3=0 
		gen gain_ut_sim3=0
		gen loose_ut_sim3=0
		
		gen prob0_sim4=0
		gen prob1_sim4=0
		
		gen gain_sim4=0
		gen loose_sim4=0
		gen gain_tt_sim4=0
		gen loose_tt_sim4=0 
		gen gain_ut_sim4=0
		gen loose_ut_sim4=0

		gen aso_psel_sim=0
		
		gen aso_treat_sim=0
		gen aso_prob0_sim=0
		gen aso_prob1_sim=0
		
		gen aso_gain_sim=0
		gen aso_loose_sim=0
		gen aso_gain_tt_sim=0
		gen aso_loose_tt_sim=0 
		gen aso_gain_ut_sim=0
		gen aso_loose_ut_sim=0
		
		gen track_gain_sim=0
		gen track_loose_sim=0
		gen track_gain_tt_sim=0
		gen track_loose_tt_sim=0
		gen track_gain_ut_sim=0
		gen track_loose_ut_sim=0
			
		
		foreach var of varlist zb   inter0 inter1	  xb0_nointer xb1_nointer xb0_inter xb1_inter {
		clonevar `var'_base=`var'
		}

		gen inter0_sim=.
		gen inter1_sim=.
		gen inter_sim=.
	
	

	
	qui forvalues s=1/$maxsim {
	drawnorm ability_sim
	
	drawnorm edinter0_sim
	drawnorm edinter1_sim
	
	drawnorm enointer0_sim
	drawnorm enointer1_sim
	drawnorm einter0_sim
	drawnorm einter1_sim
	
	drawnorm ed_sim



	*simulation of stage 1: elite school
	replace treat_sim=(zb_base+[x]_b[ability]*ability_sim+ed_sim>0)
	
	*simulation of stage 2: inter
	replace inter0_sim=(inter0_base+[inter0]_b[ability]*ability_sim+edinter0_sim>0)
	replace inter1_sim=(inter1_base+[inter1]_b[ability]*ability_sim+edinter1_sim>0)

	*simulation of stage 3: outcome
	replace prob0_sim=xb0_nointer_base	+	[y0_nointer]_b[ability]*ability_sim	+enointer0_sim>0	if inter0_sim==0 
	replace prob0_sim=xb0_inter_base	+	[y0_inter]_b[ability]*ability_sim	+einter0_sim>0		if inter0_sim==1 
	
	replace prob1_sim=xb1_nointer_base	+	[y1_nointer]_b[ability]*ability_sim	+enointer1_sim>0	if inter1_sim==0 
	replace prob1_sim=xb1_inter_base	+	[y1_inter]_b[ability]*ability_sim	+einter1_sim>0		if inter1_sim==1 
			
		*simulation of stage 3: outcome, with everyone doing inter 
		replace prob0_sim3=xb0_inter_base	+	[y0_inter]_b[ability]*ability_sim	+einter0_sim>0		
		replace prob1_sim3=xb1_inter_base	+	[y1_inter]_b[ability]*ability_sim	+einter1_sim>0	
		
		*simulation of stage 3: outcome, with everyone not doing inter 
		replace prob0_sim4=xb0_nointer_base	+	[y0_nointer]_b[ability]*ability_sim	+enointer0_sim>0	
		replace prob1_sim4=xb1_nointer_base	+	[y1_nointer]_b[ability]*ability_sim	+enointer1_sim>0	

		*simulation of stage 3 conditional on track
		*no aso
		replace aso_prob0_sim=xb0_nointer_base	+	[y0_nointer]_b[ability]*ability_sim	+enointer0_sim>0	if treat_sim==0
		replace aso_prob0_sim=xb1_nointer_base	+	[y1_nointer]_b[ability]*ability_sim	+enointer1_sim>0	if treat_sim==1
		
		*aso
		replace aso_prob1_sim=xb0_inter_base	+	[y0_inter]_b[ability]*ability_sim	+einter0_sim>0		if treat_sim==0 
		replace aso_prob1_sim=xb1_inter_base	+	[y1_inter]_b[ability]*ability_sim	+einter1_sim>0		if treat_sim==1 
	
	*individual treatment effects
	replace gain_sim=(gain_sim+prob1_sim*(1-prob0_sim))
	replace loose_sim=(loose_sim+(1-prob1_sim)*prob0_sim)
	replace gain_tt_sim=(gain_tt_sim+prob1_sim*(1-prob0_sim)*treat_sim)
	replace loose_tt_sim=(loose_tt_sim+(1-prob1_sim)*prob0_sim*treat_sim)
	replace gain_ut_sim=(gain_ut_sim+prob1_sim*(1-prob0_sim)*(1-treat_sim))
	replace loose_ut_sim=(loose_ut_sim+(1-prob1_sim)*prob0_sim*(1-treat_sim)) 
	
	
	*individual treatment effects on track choice
	replace track_gain_sim=(track_gain_sim+inter1_sim*(1-inter0_sim))
	replace track_loose_sim=(track_loose_sim+(1-inter1_sim)*inter0_sim)
	replace track_gain_tt_sim=(track_gain_tt_sim+inter1_sim*(1-inter0_sim)*treat_sim)
	replace track_loose_tt_sim=(track_loose_tt_sim+(1-inter1_sim)*inter0_sim*treat_sim)
	replace track_gain_ut_sim=(track_gain_ut_sim+inter1_sim*(1-inter0_sim)*(1-treat_sim))
	replace track_loose_ut_sim=(track_loose_ut_sim+(1-inter1_sim)*inter0_sim*(1-treat_sim)) 
		 
	 	*individual treatment effects, with everyone doing inter
		replace gain_sim3=(gain_sim3+prob1_sim3*(1-prob0_sim3))
		replace loose_sim3=(loose_sim3+(1-prob1_sim3)*prob0_sim3)
		replace gain_tt_sim3=(gain_tt_sim3+prob1_sim3*(1-prob0_sim3)*treat_sim)
		replace loose_tt_sim3=(loose_tt_sim3+(1-prob1_sim3)*prob0_sim3*treat_sim)
		replace gain_ut_sim3=(gain_ut_sim3+prob1_sim3*(1-prob0_sim3)*(1-treat_sim))
		replace loose_ut_sim3=(loose_ut_sim3+(1-prob1_sim3)*prob0_sim3*(1-treat_sim)) 

		*individual treatment effects, with everyone not doing inter
		replace gain_sim4=(gain_sim4+prob1_sim4*(1-prob0_sim4))
		replace loose_sim4=(loose_sim4+(1-prob1_sim4)*prob0_sim4)
		replace gain_tt_sim4=(gain_tt_sim4+prob1_sim4*(1-prob0_sim4)*treat_sim)
		replace loose_tt_sim4=(loose_tt_sim4+(1-prob1_sim4)*prob0_sim4*treat_sim)
		replace gain_ut_sim4=(gain_ut_sim4+prob1_sim4*(1-prob0_sim4)*(1-treat_sim))
		replace loose_ut_sim4=(loose_ut_sim4+(1-prob1_sim4)*prob0_sim4*(1-treat_sim)) 
		
	*number of times treated (needed for denominator after loop)
	replace psel_sim=psel_sim+treat_sim
	
		
		*individual treatment effects OF INTER
		replace aso_gain_sim=(aso_gain_sim+aso_prob1_sim*(1-aso_prob0_sim))
		
		replace inter_sim=inter1_sim if x==1
		replace inter_sim=inter0_sim if x==0
		
		replace aso_loose_sim=(aso_loose_sim+(1-aso_prob1_sim)*aso_prob0_sim)
		replace aso_gain_tt_sim=(aso_gain_tt_sim+aso_prob1_sim*(1-aso_prob0_sim)*inter_sim)
		replace aso_loose_tt_sim=(aso_loose_tt_sim+(1-aso_prob1_sim)*aso_prob0_sim*inter_sim)
		replace aso_gain_ut_sim=(aso_gain_ut_sim+aso_prob1_sim*(1-aso_prob0_sim)*(1-inter_sim))
		replace aso_loose_ut_sim=(aso_loose_ut_sim+(1-aso_prob1_sim)*aso_prob0_sim*(1-inter_sim)) 

		
		*number of times treated (needed for denominator after loop)
		replace aso_psel_sim=aso_psel_sim+inter_sim
	
	
		drop ability_sim e*0_sim e*1_sim ed_sim 
	}

	*average treatment effects
	replace psel_sim=psel_sim/$maxsim

	replace gain_sim=(gain_sim/$maxsim)
	replace loose_sim=(loose_sim/$maxsim)
	replace gain_tt_sim=(gain_tt_sim/$maxsim)/psel_sim
	replace loose_tt_sim=(loose_tt_sim/$maxsim)/psel_sim
	replace gain_ut_sim=(gain_ut_sim/$maxsim)/(1-psel_sim)
	replace loose_ut_sim=(loose_ut_sim/$maxsim)/(1-psel_sim)

	replace gain_tt_sim=. if x==0 //such that expectation over X is okay
	replace loose_tt_sim=. if x==0
	replace gain_ut_sim=. if x==1 
	replace loose_ut_sim=. if x==1

	gen ate=gain_sim-loose_sim
	gen att=gain_tt_sim-loose_tt_sim
	gen atnt=gain_ut_sim-loose_ut_sim

	tabstat ate gain_sim loose_sim,stats(mean) c(s)  varwidth(32)
	tabstat att gain_tt_sim loose_tt_sim,stats(mean) c(s)  varwidth(32)
	tabstat atnt gain_ut_sim loose_ut_sim,stats(mean) c(s)  varwidth(32)

	*average treatment effects on track choice
	replace track_gain_sim=(track_gain_sim/$maxsim)
	replace track_loose_sim=(track_loose_sim/$maxsim)
	replace track_gain_tt_sim=(track_gain_tt_sim/$maxsim)/psel_sim
	replace track_loose_tt_sim=(track_loose_tt_sim/$maxsim)/psel_sim
	replace track_gain_ut_sim=(track_gain_ut_sim/$maxsim)/(1-psel_sim)
	replace track_loose_ut_sim=(track_loose_ut_sim/$maxsim)/(1-psel_sim)

	replace track_gain_tt_sim=. if x==0 //such that expectation over X is okay
	replace track_loose_tt_sim=. if x==0
	replace track_gain_ut_sim=. if x==1 
	replace track_loose_ut_sim=. if x==1

	gen track_ate=track_gain_sim-track_loose_sim
	gen track_att=track_gain_tt_sim-track_loose_tt_sim
	gen track_atnt=track_gain_ut_sim-track_loose_ut_sim

	tabstat track_ate track_gain_sim track_loose_sim,stats(mean) c(s)  varwidth(32)
	tabstat track_att track_gain_tt_sim track_loose_tt_sim,stats(mean) c(s)  varwidth(32)
	tabstat track_atnt track_gain_ut_sim track_loose_ut_sim,stats(mean) c(s)  varwidth(32)
		
	
	*average treatment effects, cond on everyone doing inter
	replace gain_sim3=(gain_sim3/$maxsim)
	replace loose_sim3=(loose_sim3/$maxsim)
	replace gain_tt_sim3=(gain_tt_sim3/$maxsim)/psel_sim
	replace loose_tt_sim3=(loose_tt_sim3/$maxsim)/psel_sim
	replace gain_ut_sim3=(gain_ut_sim3/$maxsim)/(1-psel_sim)
	replace loose_ut_sim3=(loose_ut_sim3/$maxsim)/(1-psel_sim)

	replace gain_tt_sim3=. if x==0 //such that expectation over X is okay
	replace loose_tt_sim3=. if x==0
	replace gain_ut_sim3=. if x==1 
	replace loose_ut_sim3=. if x==1

	gen ate3=gain_sim3-loose_sim3
	gen att3=gain_tt_sim3-loose_tt_sim3
	gen atnt3=gain_ut_sim3-loose_ut_sim3

	tabstat ate3 gain_sim3 loose_sim3,stats(mean) c(s)  varwidth(32)
	tabstat att3 gain_tt_sim3 loose_tt_sim3,stats(mean) c(s)  varwidth(32)
	tabstat atnt3 gain_ut_sim3 loose_ut_sim3,stats(mean) c(s)  varwidth(32)

		
		
	*average treatment effects, cond on everyone not doing inter
	replace gain_sim4=(gain_sim4/$maxsim)
	replace loose_sim4=(loose_sim4/$maxsim)
	replace gain_tt_sim4=(gain_tt_sim4/$maxsim)/psel_sim
	replace loose_tt_sim4=(loose_tt_sim4/$maxsim)/psel_sim
	replace gain_ut_sim4=(gain_ut_sim4/$maxsim)/(1-psel_sim)
	replace loose_ut_sim4=(loose_ut_sim4/$maxsim)/(1-psel_sim)

	replace gain_tt_sim4=. if x==0 //such that expectation over X is okay
	replace loose_tt_sim4=. if x==0
	replace gain_ut_sim4=. if x==1 
	replace loose_ut_sim4=. if x==1

	gen ate4=gain_sim4-loose_sim4
	gen att4=gain_tt_sim4-loose_tt_sim4
	gen atnt4=gain_ut_sim4-loose_ut_sim4

	tabstat ate4 gain_sim4 loose_sim4,stats(mean) c(s)  varwidth(32)
	tabstat att4 gain_tt_sim4 loose_tt_sim4,stats(mean) c(s)  varwidth(32)
	tabstat atnt4 gain_ut_sim4 loose_ut_sim4,stats(mean) c(s)  varwidth(32)
		
				
	*average treatment effects for aso
	replace aso_psel_sim=aso_psel_sim/$maxsim

	replace aso_gain_sim=(aso_gain_sim/$maxsim)
	replace aso_loose_sim=(aso_loose_sim/$maxsim)
	replace aso_gain_tt_sim=(aso_gain_tt_sim/$maxsim)/aso_psel_sim
	replace aso_loose_tt_sim=(aso_loose_tt_sim/$maxsim)/aso_psel_sim
	replace aso_gain_ut_sim=(aso_gain_ut_sim/$maxsim)/(1-aso_psel_sim)
	replace aso_loose_ut_sim=(aso_loose_ut_sim/$maxsim)/(1-aso_psel_sim)

	replace aso_gain_tt_sim=. if inter==0 //such that expectation over X is okay
	replace aso_loose_tt_sim=. if inter==0
	replace aso_gain_ut_sim=. if inter==1 
	replace aso_loose_ut_sim=. if inter==1

	gen aso_ate=aso_gain_sim-aso_loose_sim
	gen aso_att=aso_gain_tt_sim-aso_loose_tt_sim
	gen aso_atnt=aso_gain_ut_sim-aso_loose_ut_sim

	tabstat aso_ate aso_gain_sim aso_loose_sim,stats(mean) c(s)  varwidth(32)
	tabstat aso_att aso_gain_tt_sim aso_loose_tt_sim,stats(mean) c(s)  varwidth(32)
	tabstat aso_atnt aso_gain_ut_sim aso_loose_ut_sim,stats(mean) c(s)  varwidth(32)
	
				

*collect all interesting statistics
	*stats for which we don't need weights
	foreach var of varlist ate gain_sim loose_sim  att gain_tt_sim loose_tt_sim atnt gain_ut_sim loose_ut_sim ///
	 track_ate track_gain_sim track_loose_sim  track_att track_gain_tt_sim track_loose_tt_sim track_atnt track_gain_ut_sim track_loose_ut_sim ///
		  ate3 gain_sim3 loose_sim3  att3 gain_tt_sim3 loose_tt_sim3 atnt3 gain_ut_sim3 loose_ut_sim3 ///
		   ate4 gain_sim4 loose_sim4  att4 gain_tt_sim4 loose_tt_sim4 atnt4 gain_ut_sim4 loose_ut_sim4 ///
			aso_ate aso_gain_sim aso_loose_sim aso_att aso_gain_tt_sim aso_loose_tt_sim aso_atnt aso_gain_ut_sim aso_loose_ut_sim ///
				 {
	qui sum `var'
	scalar scal_`var'=r(mean)
	}
			
		
		
//calculate standard errors
*set nr parameter draws we want
clear
set obs $bootloop

*load estimates
est restore threestage
mat mat_coef=e(b)
mat mat_covar=e(V)


*take draws
global input
	*variables of x 
	foreach var in $xvars ability cons {
	global input $input x_`var'
	}
	*variables of inter0
	foreach var in $intervars ability	cons  {
	global input $input inter0_`var'
	}
	*variables of inter1
	foreach var in $intervars ability 	cons  {
	global input $input inter1_`var'
	}
	*variables of y1_inter
	foreach var in $yvars ability	cons  {
	global input $input y1_inter_`var'
	}
	*variables of y0_inter
	foreach var in $yvars ability	cons  {
	global input $input y0_inter_`var'
	}
	*variables of y1_nointer
	foreach var in $yvars ability	cons  {
	global input $input y1_nointer_`var'
	}
	*variables of y0_nointer
	foreach var in $yvars ability	cons  {
	global input $input y0_nointer_`var'
	}
	*variance of ability
	global input $input varability
	
di "$input"
drawnorm $input ,means(mat_coef) cov(mat_covar)

gen drawnumber=_n
compress
save "Output/paramdraws",replace
		

*calculate statistics for each draw (do this in parallel to speed things up)		
*clean database
use `startpred',clear
keep x z $controls2 drel_someASO inter
compress
save "Output/startpred_clean",replace 

if $parallel_allow==1 {
parallel setclusters 5,force
global loopspercluster=$bootloop/5 
parallel do "threestage_draws.do", nodata
}
else {
global PLL_CLUSTERS=1
global pll_instance=1
global loopspercluster=$bootloop
do "threestage_draws.do"
}
	
*summarize the draws
use "Output/threestage_draw_1",clear
forvalues i=2/$bootloop {
merge 1:1 var using  "Output/threestage_draw_`i'",keep(3) nogen
}

egen sd=rowsd(draw*)
levelsof var,local(vars)


*also calculate difference of treatment effects of estimates
	foreach var in  ate3 ate4  {
	scal scal_`var'_d=scal_`var'-scal_ate
	}
	foreach var in	att3 att4 {
	scal scal_`var'_d=scal_`var'-scal_att	
	}
	foreach var in	atnt3 atnt4  {
	scal scal_`var'_d=scal_`var'-scal_atnt		
	}

gen est=.
foreach var in `vars' {
replace est=scal_`var' if var=="`var'"
}
order est,before(sd)
gen star=""
replace star="*" if abs(est)-1.96*sd>0

keep var est sd star

**Table 7
*Overall effects
list if var=="ate" | var=="gain_sim" | var=="loose_sim" 
*Overall effects treated
list if var=="att" | var=="gain_tt_sim" | var=="loose_tt_sim"
*Overall effects nontreated
list if var=="atnt" | var=="gain_ut_sim" | var=="loose_ut_sim"

*effects on track
list if var=="track_ate" | var=="track_gain_sim" | var=="track_loose_sim" 
*effects on track treated
list if var=="track_att" | var=="track_gain_tt_sim" | var=="track_loose_tt_sim"
*effects on track nontreated
list if var=="track_atnt" | var=="track_gain_ut_sim" | var=="track_loose_ut_sim"

*Effects track
list if var=="aso_ate" | var=="aso_gain_sim" | var=="aso_loose_sim" 
*Effects track for those going there
list if var=="aso_att" | var=="aso_gain_tt_sim" | var=="aso_loose_tt_sim"
*Effects track for those not going there
list if var=="aso_atnt" | var=="aso_gain_ut_sim" | var=="aso_loose_ut_sim"


**Table 8
*Forcing academic track
list if var=="ate3" | var=="gain_sim3" | var=="loose_sim3"			| var=="ate3_d" 
*Treated
list if var=="att3" | var=="gain_tt_sim3" | var=="loose_tt_sim3"	| var=="att3_d" 
*Non-Treated
list if var=="atnt3" | var=="gain_ut_sim3" | var=="loose_ut_sim3"	| var=="atnt3_d" 

*Forcing no academic track
list if var=="ate4" | var=="gain_sim4" | var=="loose_sim4"			| var=="ate4_d" 
*Treated
list if var=="att4" | var=="gain_tt_sim4" | var=="loose_tt_sim4"	| var=="att4_d" 
*Non-Treated
list if var=="atnt4" | var=="gain_ut_sim4" | var=="loose_ut_sim4"	| var=="atnt4_d" 



log close
