set more off

cap log close
log using "Output/distance_count",replace

local i=5 //radius used
*qui{
set more off
use  "Output/schoolchar_adnr",clear

gen scho_treat=1 if scho_ASO==1
gen scho_notreat=1 if scho_noASO==1 | scho_mixed==1

 set more off
 global schools scho_treat scho_notreat

 
 
*take extremely far distances if unknown 
gen random=runiform()
replace g_lon=-179+0.01*random if missing(g_lon)
replace g_lat=-89-0.01*random if missing(g_lat)

 tempfile temp_adnr
 sort adnr 
 gen n=_n
 local N=_N
 
 keep adnr n g_lon g_lat $schools  
 save `temp_adnr',replace
 
append using "Source/shape file/Belgium/statsector_data_be_1984",gen(mindonor)
gen donor=1-mindonor
replace g_lat=y_centr if missing(g_lat)
replace g_lon=x_centr if missing(g_lon)

tempfile restorethis
save `restorethis',replace

tempfile temp
keep ID_be
drop if missing(ID_be)
duplicates drop
save `temp',replace


 foreach track of global schools {
 use `restorethis',clear
 di "`track'"
 
 keep if mindonor==1 | (mindonor==0 & `track'==1 )
 replace adnr=10000000+_n if missing(adnr)
 
 *if no schools, go to next track in loop
 qui sum `track' if `track'==1
 scalar scal_N=r(N)
 if scal_N>=1 {

 gen g_lat_donor=g_lat if donor==1
 gen g_lon_donor=g_lon if donor==1
 gen g_lat_rec=g_lat if donor==0
 gen g_lon_rec=g_lon if donor==0
 
 nearstat g_lat_rec  g_lon_rec, near(g_lat_donor g_lon_donor) distvar(_dist1) dband(0 `i') ncount(total_`i') 
 
 keep ID_be CODE1001 _dist1 /*_adnr1*/ mindonor  total_`i'
 replace _dist1=. if _dist1>1000
 rename _dist1 d_`track'
 rename total_`i' tot_`i'km_`track'
 keep if mindonor==1
 merge 1:1 ID_be using `temp'
 drop _merge
 save `temp',replace
 }
 }
 

 use `temp',clear
 
drop mindonor
drop ID_be
di _N

*take mean distance if two coordinates for a sector
*drop id_ if multiple schools are therefore possible matches
di _N
collapse (mean) d_* (max) tot_* ,by(CODE1001)
di _N

gen niscode=substr(CODE1001,1,5)
destring niscode,replace
gen sector=substr(CODE1001,6,.)
order niscode sector
drop CODE1001

save "Output/minimumdist_adnr_count",replace

log close
