	local loop=1
	forvalues tot=1/$PLL_CLUSTERS {
	di `tot'
	if ($pll_instance==`tot') {
	local loop_min=`loop'
	local loop_max=`loop'+$loopspercluster-1
	}
	local loop=`loop'+$loopspercluster
	}
	di "loopmin " `loop_min'
	di "loopmax " `loop_max'	
	
	
forvalues draw=`loop_min'/`loop_max' {

//Load sample used in estimation
use "Output/startpred_clean_twostage",clear 

bsample,cluster(location)
switch_probit y $controlvar, select(x z $controlvar) cluster(location)
est store baseline`draw'
predict att,tt
predict ate,te
predict atnt,tu


//distributional
est restore baseline`draw'
scalar scal_rho1=e(rho1)
di scal_rho1
scalar scal_rho0=e(rho0)
di scal_rho0

nlcom tanh(_b[/athrho1]),post
mat mat_temp=e(V)
scalar scal_rho1_se=sqrt(mat_temp[1,1])
di scal_rho1_se
est restore baseline`draw'
nlcom tanh(_b[/athrho0]),post
mat mat_temp=e(V)
scalar scal_rho0_se=sqrt(mat_temp[1,1])
di scal_rho0_se
est restore baseline`draw'


*predictions to calculate other effects
predict psel, psel //probability of treatment
predict xb1,xb1 //linear prediction of outcome equation if treated
predict xb0,xb0 // "" nontreated
predict zb,zb // "" of participation equation


**marginal effects on TE


*categorical variable
foreach effect in  tt te tu {
clonevar opl_moe1_clone=opl_moe1
clonevar opl_moe2_clone=opl_moe2
di "`effect'"
replace opl_moe1=0
replace opl_moe2=0
predict temp0,`effect'

replace opl_moe1=1
predict temp1,`effect'
gen me_`effect'_opl_moe1=temp1-temp0
drop temp1

replace opl_moe1=0
replace opl_moe2=1
predict temp1,`effect'
gen me_`effect'_opl_moe2=temp1-temp0
drop temp1 temp0

replace opl_moe2=opl_moe2_clone
replace opl_moe1=opl_moe1_clone
drop opl_moe1_clone opl_moe2_clone

* categorical variable rural/urban (stad_1 = big cities (reference cat), stad_2 = regional cities, stad_3 = medium-sized cities, stad_4 = rural)
clonevar stad_2_clone=stad_2
clonevar stad_3_clone=stad_3
clonevar stad_4_clone=stad_4
di "`effect'"
replace stad_2=0
replace stad_3=0
replace stad_4=0
predict temp0,`effect'

replace stad_4=1
predict temp1,`effect'
gen me_`effect'_stad_4=temp1-temp0
drop temp1

replace stad_2=0
replace stad_3=1
replace stad_4=0
predict temp1,`effect'
gen me_`effect'_stad_3=temp1-temp0
drop temp1

replace stad_2=1
replace stad_3=0
replace stad_4=0
predict temp1,`effect'
gen me_`effect'_stad_2=temp1-temp0
drop temp0 temp1

replace stad_2=stad_2_clone
replace stad_3=stad_3_clone
replace stad_4=stad_4_clone
drop stad_2_clone stad_3_clone stad_4_clone


* categorical variable province (prov_1 (reference cat), prov_2, prov_3, prov_4, prov_5)
clonevar prov_2_clone=prov_2
clonevar prov_3_clone=prov_3
clonevar prov_4_clone=prov_4
clonevar prov_5_clone=prov_5
di "`effect'"
replace prov_2=0
replace prov_3=0
replace prov_4=0
replace prov_5=0
predict temp0,`effect'

replace prov_5=1
predict temp1,`effect'
gen me_`effect'_prov_5=temp1-temp0
drop temp1

replace prov_2=0
replace prov_3=0
replace prov_4=1
replace prov_5=0
predict temp1,`effect'
gen me_`effect'_prov_4=temp1-temp0
drop temp1

replace prov_2=0
replace prov_3=1
replace prov_4=0
replace prov_5=0
predict temp1,`effect'
gen me_`effect'_prov_3=temp1-temp0
drop temp1

replace prov_2=1
replace prov_3=0
replace prov_4=0
replace prov_5=0
predict temp1,`effect'
gen me_`effect'_prov_2=temp1-temp0
drop temp0 temp1

replace prov_2=prov_2_clone
replace prov_3=prov_3_clone
replace prov_4=prov_4_clone
replace prov_5=prov_5_clone
drop prov_2_clone prov_3_clone prov_4_clone prov_5_clone

* dummy variables: effect of a change from 0 to 1
foreach var of varlist no_ned_thuis toelage_SO male repeated{
clonevar `var'_clone=`var'
replace `var'=0
predict temp0,`effect'
replace `var'=1
predict temp1,`effect'
gen me_`effect'_`var'=temp1-temp0
drop temp1 temp0
replace `var'=`var'_clone
drop `var'_clone
}

* continuous variables: effect of a unit increase
foreach var of varlist bev bev_nis{
clonevar `var'_clone=`var'
predict temp0,`effect'
replace `var'=`var'+1
predict temp1,`effect'
gen me_`effect'_`var'=temp1-temp0
drop temp1 temp0
replace `var'=`var'_clone
drop `var'_clone
}

}

*get out probs
gen prob0=normal(xb0) //prob to succeed, cond on no treatment
gen prob1=normal(xb1)
gen treat=normal(zb)

*gain and loose
scalar scal_rho01=2*scal_rho0*scal_rho1
gen gain=prob1-binormal(xb0,xb1,scal_rho01)
gen loose=(1-prob1)-binormal(-xb0,-xb1,scal_rho01)

set more off
*gain and loose if (un)treated (simulation assisted)
matrix mat_M=(0,0,0)
scal scal_rho01=2*scal_rho0*scal_rho1 //this does not change predicted probs but it does change gain from treatment!
matrix mat_V=(1,scal_rho0,scal_rho1 \ scal_rho0,1,scal_rho01 \ scal_rho1,scal_rho01,1)

	gen psel_sim=0
	gen treat_sim=0
	gen prob0_sim=0
	gen prob1_sim=0
	gen gain_tt_sim=0
	gen loose_tt_sim=0 
	gen gain_ut_sim=0
	gen loose_ut_sim=0

qui forvalues s=1/$maxsim {
drawnorm UD U0 U1, corr(mat_V) means(mat_M)
replace treat_sim=(zb+UD>0)
replace prob0_sim=(xb0+U0>0)
replace prob1_sim=(xb1+U1>0)

replace gain_tt_sim=(gain_tt_sim+prob1_sim*(1-prob0_sim)*treat_sim)
replace loose_tt_sim=(loose_tt_sim+(1-prob1_sim)*prob0_sim*treat_sim)
replace gain_ut_sim=(gain_ut_sim+prob1_sim*(1-prob0_sim)*(1-treat_sim))
replace loose_ut_sim=(loose_ut_sim+(1-prob1_sim)*prob0_sim*(1-treat_sim)) 
 
replace psel_sim=psel_sim+treat_sim
drop UD U0 U1
}

replace psel_sim=psel_sim/$maxsim
replace gain_tt_sim=(gain_tt_sim/$maxsim)/psel_sim
replace loose_tt_sim=(loose_tt_sim/$maxsim)/psel_sim
replace gain_ut_sim=(gain_ut_sim/$maxsim)/(1-psel_sim)
replace loose_ut_sim=(loose_ut_sim/$maxsim)/(1-psel_sim)

replace gain_tt_sim=. if x==0 //such that expectation over X is okay
replace loose_tt_sim=. if x==0
replace gain_ut_sim=. if x==1 
replace loose_ut_sim=. if x==1

foreach var of varlist att ate atnt gain loose gain_tt_sim loose_tt_sim gain_ut_sim loose_ut_sim ///    
				me_te_opl_moe1 me_te_opl_moe2 me_te_no_ned_thuis me_te_toelage_SO me_te_male me_te_repeated me_te_stad_2 me_te_stad_3 me_te_stad_4 me_te_prov_2 me_te_prov_3 me_te_prov_4 me_te_prov_5  ///
				me_te_bev me_te_bev_nis ///
				me_tt_opl_moe1 me_tt_opl_moe2 me_tt_no_ned_thuis me_tt_toelage_SO me_tt_male me_tt_repeated me_tt_stad_2 me_tt_stad_3 me_tt_stad_4 me_tt_prov_2 me_tt_prov_3 me_tt_prov_4 me_tt_prov_5  ///
				me_tt_bev me_tt_bev_nis ///
				me_tu_opl_moe1 me_tu_opl_moe2 me_tu_no_ned_thuis me_tu_toelage_SO me_tu_male me_tu_repeated me_tu_stad_2 me_tu_stad_3 me_tu_stad_4 me_tu_prov_2 me_tu_prov_3 me_tu_prov_4 me_tu_prov_5  ///
				me_tu_bev me_tu_bev_nis {
sum `var'
local `var'_`draw'=r(mean)
}

 		
	
	clear
	set obs 150 //at least number of statistics we're interested in
	
	gen var=""
	gen draw`draw'=.

	
	local i=0
	foreach var in  	att ate atnt gain loose gain_tt_sim loose_tt_sim gain_ut_sim loose_ut_sim ///    
						me_te_opl_moe1 me_te_opl_moe2 me_te_no_ned_thuis me_te_toelage_SO me_te_male me_te_repeated me_te_stad_2 me_te_stad_3 me_te_stad_4 me_te_prov_2 me_te_prov_3 me_te_prov_4 me_te_prov_5  ///
						me_te_bev me_te_bev_nis ///
						me_tt_opl_moe1 me_tt_opl_moe2 me_tt_no_ned_thuis me_tt_toelage_SO me_tt_male me_tt_repeated me_tt_stad_2 me_tt_stad_3 me_tt_stad_4 me_tt_prov_2 me_tt_prov_3 me_tt_prov_4 me_tt_prov_5  ///
						me_tt_bev me_tt_bev_nis ///
						me_tu_opl_moe1 me_tu_opl_moe2 me_tu_no_ned_thuis me_tu_toelage_SO me_tu_male me_tu_repeated me_tu_stad_2 me_tu_stad_3 me_tu_stad_4 me_tu_prov_2 me_tu_prov_3 me_tu_prov_4 me_tu_prov_5  ///
						me_tu_bev me_tu_bev_nis ///
						{
									
	local i=`i'+1
	replace var="`var'" in `i'
	replace draw`draw'=``var'_`draw'' if var=="`var'"					
	}
	
	
	drop if missing(var)
	save "Output/twostage_draw_`draw'",replace
	}
	
	