/*******************************************************************
 This file suspends some sample restrictions and tests the 
 sensitivity of the estimates for completed school track to 
 alternative samples and model specifications. It generates
 the Appendix Table C.4.
********************************************************************/

use "$sample\compuls.dta", clear
gen welle=year+1900

* sample restrictions 
 
gen dif = length - school /*generate length of school variable*/
gen diff_yos = dif < -2 | dif > 4 /*don't clean, generate dummy for to be cleaned*/
drop dif

*drop if school2 == . | exp == . | lnw == . /*don't drop missings for education*/
drop if lnw == .
gen edu_mis = ed == .  /*generate dummy for missing education*/
gen school_mis = school2 == . /*generate dummy for missing schooling*/

*generate indicators for too large and too small values (1 and 99 percentile)
gen yos_1_99 = length>=6 & length <=21 /*dummy for 6-21 years of schooling*/

keep if yob >= 30 & yob <= 60 /*cohorts 1930-1960*/
keep if age >= 19 & age <= 65 /*age 19-65*/
keep if bula < 11 /*only West German states (excl. Berlin)*/

gen yob_=yob
replace yob = yob+1900
gen yos=length /*rename years of schooling*/
gen lhwage=lnw /*rename wages*/

gen N_=. /*dummy for estimation sample*/
count

count
* Generate dummies for the highest completed school track
recode degree* (3 4=3) (5=.)
egen degree_max=rowmax(degree degree_) if welle==1999
replace degree=degree_max if welle==1999 & degree_!=.
drop degree_max
lab def degree 0 "0: no degree" 1 "1: basic" 2 "2: intermediate" ///
				3 "3: high (Abi/Fachabi)" 5 "4: other"
lab val degree degree
tab degree, gen(degree_) mis
replace degree_2=degree_1+degree_2
lab var degree_2 "Basic track (at most)"
lab var degree_3 "Middle track"
lab var degree_4 "Academic track"


***** Estimations for Table C.4: PvW’s reduced-form estimate of the effect of
*     the ninth compulsory school year on completed school track: replication 
*     and sensitivity tests
estimates drop _all

***** PvW Replication*****
global instr switch2
global contr age* female year79 year85 year92 year99  

foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) 	title ("PvW Replication") collabel(, none) ///
    stats(N, fmt( 0 0 0) label(  )) replace stardetach    modelwidth(8)

*****  S1: yob>=1931 *****
foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
& yob>=1931 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S1: yob>=1931") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)
	

***** S2: yob>=1945 *****
foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
& yob>=1945 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S2: yob>=1945") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)
	
***** S3 & S4: temporary extensions *****
preserve
gen temp=bula==3 & yob>=1935 & yob<=1940
replace temp=1 if bula==5 & yob>=1935 & yob<=1939
replace temp=1 if bula==6 & ((yob>=1936 & yob<=1941) | yob==1933)
replace temp=1 if bula==7 & yob>=1938 & yob<=1942
replace temp=1 if bula==8 & yob>=1938 & yob<=1941
replace temp=1 if bula==9 & yob>=1938 & yob<=1943

*two instruments 
global instr switch2 temp
global contr age* female year79 year85 year92 year99 

foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep(switch2) title ("S3: temp extensions - two instr") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)


*combined instrument
replace switch2=switch2+temp

global instr switch2 
global contr age* female year79  year85 year92 year99 

foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S4: temp extensions - combined instr") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)
restore
	
	
***** S5: age 19-60 *****
foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
		& age>=19 & age<=60 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S5: age 19-60") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)


***** S6: age 19-55 *****
foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
		& age>=19 & age<=55 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S6: age 19-55") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)

	
***** S7: age 25-65 *****
foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
		& age>=25 & age<=65 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S7: age 25-65") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)

	
***** S8: wage outliers *****
preserve
foreach welle of numlist 1979 1985 1992 1999  {
qui centile w if welle==`welle' & diff_yos==0 & edu_mis==0 & school_mis==0, c(0.25 99.75)  
drop if welle==`welle' & diff_yos==0 & edu_mis==0 & school_mis==0 & (w<r(c_1) | w>r(c_2))

}

foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S8: wage outliers") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)
restore


***** S9: SSY *****
cap drop SSY*
*** Short school years: Pischke (2007), but age at enrollment 6 (not 7) ****
gen SSY1=(yob==1953 | yob==1961) & (bula==5 | bula==6 | bula==7 | bula==8) 
replace SSY1=1 if (yob==1952 | yob==1961) & (bula==1 | bula==4 | bula==10) /*1952 due to C9==1*/

gen SSY2=(yob>1953 & yob<1961) & (bula==5 | bula==6 | bula==7 | bula==8)
replace SSY2=1 if (yob>1952 & yob<1961) & (bula==1 | bula==4 | bula==10) 

gen SSY=SSY1+SSY2
lab var SSY "Affected by SSY (basic track)"

global instr switch2
global contr age* female year79  year85 year92 year99 SSY 


foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S9: SSY") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)
	
	
***** S10: squared trends *****
global instr switch2
global contr age* female year79  year85 year92 year99 

foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_##c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S10: quadr. trends") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)

	
***** S11: man only *****
preserve
keep if female==0
foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula#c.yob_  ///
if diff_yos==0 & edu_mis==0 & school_mis==0 ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
restore

estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S11: man only") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)
	
	
***** S12: incl. missings on education *****
foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if diff_yos==0  ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S12: missing educ") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)


***** S13: years of schooling 6-21 (1-99 percentile) *****
foreach num of numlist 2(1)4  {
qui reg  degree_`num'  $instr  i.yob i.bula $contr i.bula##c.yob_  ///
if yos>=6 & yos<22  ///
 ,    vce(cluster clust)  
estimates store degree_`num'
} 
estout degree_*   ///
using "${sample}\tabC4_degree.xls" ///
	, cells(b(fmt(3) star) se(par)) starlevels(* 0.1 ** 0.05 *** 0.01)  ///
	keep($instr) title ("S13: yos 6-22") collabel(, none) ///
    stats(N, fmt(0) label( )) append stardetach modelwidth(8)








